/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.canvas;

import java.util.ArrayList;
import java.util.Locale;
import net.codecrete.qrbill.canvas.CharWidthData;

public class FontMetrics {
    private static final double PT_TO_MM = 0.35277777777777775;
    private final String fontFamilyList;
    private final String firstFontFamily;
    private final char[] charWidthx20x7E;
    private final char[] charWidthxA0x17F;
    private final char[] charWidthx218x21B;
    private final char charDefaultWidth;
    private final char charNDashWidth;
    private final char charEuroWidth;
    private final FontMetrics boldMetrics;

    public FontMetrics(String fontFamilyList) {
        char boldCharEuroWidth;
        char boldCharNDashWidth;
        char boldCharDefaultWidth;
        char[] boldCharWidthx218x21B;
        char[] boldCharWidthxA0x17F;
        char[] boldCharWidthx20x7F;
        this.fontFamilyList = fontFamilyList;
        this.firstFontFamily = FontMetrics.getFirstFontFamily(fontFamilyList);
        String family = this.firstFontFamily.toLowerCase(Locale.US);
        if (family.contains("arial")) {
            this.charWidthx20x7E = CharWidthData.ARIAL_NORMAL_20_7E;
            this.charWidthxA0x17F = CharWidthData.ARIAL_NORMAL_A0_17F;
            this.charWidthx218x21B = CharWidthData.ARIAL_NORMAL_218_21B;
            this.charDefaultWidth = (char)556;
            this.charNDashWidth = (char)556;
            this.charEuroWidth = (char)556;
            boldCharWidthx20x7F = CharWidthData.ARIAL_BOLD_20_7E;
            boldCharWidthxA0x17F = CharWidthData.ARIAL_BOLD_A0_17F;
            boldCharWidthx218x21B = CharWidthData.ARIAL_BOLD_218_21B;
            boldCharDefaultWidth = '\u0263';
            boldCharNDashWidth = '\u022c';
            boldCharEuroWidth = '\u022c';
        } else if (family.contains("liberation") && family.contains("sans")) {
            this.charWidthx20x7E = CharWidthData.LIBERATION_SANS_NORMAL_20_7E;
            this.charWidthxA0x17F = CharWidthData.LIBERATION_SANS_NORMAL_A0_17F;
            this.charWidthx218x21B = CharWidthData.LIBERATION_SANS_NORMAL_218_21B;
            this.charDefaultWidth = (char)556;
            this.charNDashWidth = (char)556;
            this.charEuroWidth = (char)556;
            boldCharWidthx20x7F = CharWidthData.LIBERATION_SANS_BOLD_20_7E;
            boldCharWidthxA0x17F = CharWidthData.LIBERATION_SANS_BOLD_A0_17F;
            boldCharWidthx218x21B = CharWidthData.LIBERATION_SANS_BOLD_218_21B;
            boldCharDefaultWidth = '\u0263';
            boldCharNDashWidth = '\u022c';
            boldCharEuroWidth = '\u022c';
        } else if (family.contains("frutiger")) {
            this.charWidthx20x7E = CharWidthData.FRUTIGER_NORMAL_20_7E;
            this.charWidthxA0x17F = CharWidthData.FRUTIGER_NORMAL_A0_17F;
            this.charWidthx218x21B = CharWidthData.FRUTIGER_NORMAL_218_21B;
            this.charDefaultWidth = (char)556;
            this.charNDashWidth = (char)500;
            this.charEuroWidth = (char)556;
            boldCharWidthx20x7F = CharWidthData.FRUTIGER_BOLD_20_7E;
            boldCharWidthxA0x17F = CharWidthData.FRUTIGER_BOLD_A0_17F;
            boldCharWidthx218x21B = CharWidthData.FRUTIGER_BOLD_218_21B;
            boldCharDefaultWidth = '\u0263';
            boldCharNDashWidth = '\u01f4';
            boldCharEuroWidth = '\u022c';
        } else {
            this.charWidthx20x7E = CharWidthData.HELVETICA_NORMAL_20_7E;
            this.charWidthxA0x17F = CharWidthData.HELVETICA_NORMAL_A0_17F;
            this.charWidthx218x21B = CharWidthData.HELVETICA_NORMAL_218_21B;
            this.charDefaultWidth = (char)556;
            this.charNDashWidth = (char)556;
            this.charEuroWidth = (char)744;
            boldCharWidthx20x7F = CharWidthData.HELVETICA_BOLD_20_7E;
            boldCharWidthxA0x17F = CharWidthData.HELVETICA_BOLD_A0_17F;
            boldCharWidthx218x21B = CharWidthData.HELVETICA_BOLD_218_21B;
            boldCharDefaultWidth = '\u0263';
            boldCharNDashWidth = '\u022c';
            boldCharEuroWidth = '\u02e8';
        }
        this.boldMetrics = new FontMetrics(boldCharWidthx20x7F, boldCharWidthxA0x17F, boldCharWidthx218x21B, boldCharDefaultWidth, boldCharNDashWidth, boldCharEuroWidth);
    }

    private FontMetrics(char[] charWidthx20x7E, char[] charWidthxA0x17F, char[] charWidthx218x21B, char charDefaultWidth, char charNDashWidth, char charEuroWidth) {
        this.fontFamilyList = null;
        this.firstFontFamily = null;
        this.charWidthx20x7E = charWidthx20x7E;
        this.charWidthxA0x17F = charWidthxA0x17F;
        this.charWidthx218x21B = charWidthx218x21B;
        this.charDefaultWidth = charDefaultWidth;
        this.charNDashWidth = charNDashWidth;
        this.charEuroWidth = charEuroWidth;
        this.boldMetrics = null;
    }

    public String getFontFamilyList() {
        return this.fontFamilyList;
    }

    public String getFirstFontFamily() {
        return this.firstFontFamily;
    }

    public double getAscender(int fontSize) {
        return (double)fontSize * 0.8 * 0.35277777777777775;
    }

    public double getDescender(int fontSize) {
        return (double)fontSize * 0.2 * 0.35277777777777775;
    }

    public double getLineHeight(int fontSize) {
        return (double)fontSize * 0.35277777777777775;
    }

    public String[] splitLines(String text, double maxLength, int fontSize) {
        ArrayList<String> lines = new ArrayList<String>();
        int max = (int)(maxLength * 1000.0 / (double)fontSize);
        int len = text.length();
        int pos = 0;
        int lineStartPos = 0;
        int lineWidth = 0;
        boolean addEmptyLine = true;
        while (pos < len) {
            char ch = text.charAt(pos);
            if (ch == ' ' && pos == lineStartPos) {
                ++lineStartPos;
                ++pos;
                continue;
            }
            addEmptyLine = false;
            if (ch == '\n' || (lineWidth += this.getCharWidth(ch)) > max) {
                int breakPos;
                if (ch == '\n') {
                    breakPos = pos;
                } else {
                    int spacePos;
                    for (spacePos = pos - 1; spacePos > lineStartPos && text.charAt(spacePos) != ' '; --spacePos) {
                    }
                    breakPos = spacePos > lineStartPos ? spacePos : (pos > lineStartPos ? pos : lineStartPos + 1);
                }
                FontMetrics.addResultLine(lines, text, lineStartPos, breakPos);
                lineStartPos = breakPos;
                if (ch == '\n') {
                    lineStartPos = breakPos + 1;
                    addEmptyLine = true;
                }
                pos = lineStartPos;
                lineWidth = 0;
                continue;
            }
            ++pos;
        }
        if (pos > lineStartPos) {
            FontMetrics.addResultLine(lines, text, lineStartPos, pos);
        } else if (addEmptyLine) {
            lines.add("");
        }
        return lines.toArray(new String[0]);
    }

    private static void addResultLine(ArrayList<String> lines, String text, int start, int end) {
        while (end > start && text.charAt(end - 1) == ' ') {
            --end;
        }
        lines.add(text.substring(start, end));
    }

    public double getTextWidth(CharSequence text, int fontSize, boolean isBold) {
        if (isBold) {
            return this.boldMetrics.getTextWidth(text, fontSize, false);
        }
        double width = 0.0;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            width += (double)this.getCharWidth(text.charAt(i));
        }
        return width * (double)fontSize / 1000.0 * 0.35277777777777775;
    }

    private char getCharWidth(char ch) {
        char width = '\u0000';
        if (ch >= ' ' && ch <= '~') {
            width = this.charWidthx20x7E[ch - 32];
        } else if (ch >= '\u00a0' && ch <= '\u017f') {
            width = this.charWidthxA0x17F[ch - 160];
        } else if (ch >= '\u0218' && ch <= '\u021b') {
            width = this.charWidthx218x21B[ch - 536];
        } else if (ch == '\u2013') {
            width = this.charNDashWidth;
        } else if (ch == '\u20ac') {
            width = this.charEuroWidth;
        }
        if (width == '\u0000' && ch != '\n' && ch != '\r') {
            width = this.charDefaultWidth;
        }
        return width;
    }

    private static String getFirstFontFamily(String fontFamilyList) {
        int index = fontFamilyList.indexOf(44);
        if (index < 0) {
            return fontFamilyList;
        }
        String fontFamily = fontFamilyList.substring(0, index).trim();
        if (fontFamily.startsWith("\"")) {
            fontFamily = fontFamily.substring(1);
        }
        if (fontFamily.endsWith("\"")) {
            fontFamily = fontFamily.substring(0, fontFamily.length() - 1);
        }
        return fontFamily;
    }
}

