/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.canvas;

import java.nio.file.Path;

public class PDFFontSettings {
    private final FontEmbedding fontEmbedding;
    private final String fontFamily;
    private final Path regularFontPath;
    private final Path boldFontPath;

    private PDFFontSettings(FontEmbedding fontEmbedding, String fontFamily, Path regularFontPath, Path boldFontPath) {
        this.fontEmbedding = fontEmbedding;
        this.fontFamily = fontFamily;
        this.regularFontPath = regularFontPath;
        this.boldFontPath = boldFontPath;
    }

    public static PDFFontSettings standardHelvetica() {
        return new PDFFontSettings(FontEmbedding.STANDARD_HELVETICA, "Helvetica", null, null);
    }

    public static PDFFontSettings embeddedLiberationSans() {
        return new PDFFontSettings(FontEmbedding.EMBEDDED_LIBERATION_SANS, "Liberation Sans", null, null);
    }

    public static PDFFontSettings embeddedCustomFont(String fontFamily, Path regularFontPath, Path boldFontPath) {
        return new PDFFontSettings(FontEmbedding.EMBEDDED_CUSTOM, fontFamily, regularFontPath, boldFontPath);
    }

    public FontEmbedding getFontEmbedding() {
        return this.fontEmbedding;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public Path getRegularFontPath() {
        return this.regularFontPath;
    }

    public Path getBoldFontPath() {
        return this.boldFontPath;
    }

    public static enum FontEmbedding {
        STANDARD_HELVETICA,
        EMBEDDED_LIBERATION_SANS,
        EMBEDDED_CUSTOM;

    }
}

