/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.canvas;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import net.codecrete.qrbill.canvas.ByteArrayResult;
import net.codecrete.qrbill.canvas.Graphics2DCanvas;
import net.codecrete.qrbill.generator.QRBillGenerationException;

public class PNGCanvas
extends Graphics2DCanvas
implements ByteArrayResult {
    private static final String METADATA_KEY_VALUE = "value";
    private static final String METADATA_KEY_KEYWORD = "keyword";
    private BufferedImage image;
    private Graphics2D graphics;
    private final int resolution;
    private static final String PNG_STANDARD_METADATA_FORMAT = "javax_imageio_1.0";

    public PNGCanvas(double width, double height, int resolution, String fontFamilyList) {
        super(fontFamilyList);
        this.resolution = resolution;
        float scale = (float)((double)resolution / 25.4);
        int w = (int)(width * (double)scale + 0.5);
        int h = (int)(height * (double)scale + 0.5);
        this.image = new BufferedImage(w, h, 10);
        this.graphics = this.image.createGraphics();
        this.graphics.setColor(new Color(0xFFFFFF));
        this.graphics.fillRect(0, 0, w, h);
        this.setOffset(0.0f, h);
        this.initGraphics(this.graphics, false, scale);
    }

    @Override
    public byte[] toByteArray() throws IOException {
        this.graphics.dispose();
        this.graphics = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PNGCanvas.createPNG(this.image, os, this.resolution);
        return os.toByteArray();
    }

    public void writeTo(OutputStream os) throws IOException {
        this.graphics.dispose();
        this.graphics = null;
        PNGCanvas.createPNG(this.image, os, this.resolution);
    }

    public void saveAs(Path path) throws IOException {
        this.graphics.dispose();
        this.graphics = null;
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            PNGCanvas.createPNG(this.image, os, this.resolution);
        }
    }

    @Override
    public void close() {
        if (this.graphics != null) {
            this.graphics.dispose();
            this.graphics = null;
        }
        this.image = null;
    }

    private static void createPNG(BufferedImage image, OutputStream os, int resolution) throws IOException {
        ImageWriter writer = null;
        ImageWriteParam writeParam = null;
        IIOMetadata metadata = null;
        Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName("png");
        while (iw.hasNext()) {
            writer = iw.next();
            writeParam = writer.getDefaultWriteParam();
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(image.getType());
            metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
            break;
        }
        if (writer == null || writeParam == null) {
            throw new QRBillGenerationException("No valid PNG writer found");
        }
        PNGCanvas.addDpiMetadata(metadata, resolution);
        PNGCanvas.addTextMetadata(metadata);
        try (ImageOutputStream stream = ImageIO.createImageOutputStream(os);){
            writer.setOutput(stream);
            writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
        }
    }

    private static void addDpiMetadata(IIOMetadata metadata, int dpi) throws IIOInvalidTreeException {
        double pixelsPerMeter = (double)dpi / 25.4 * 1000.0;
        String pixelsPerMeterString = Integer.toString((int)(pixelsPerMeter + 0.5));
        IIOMetadataNode physNode = new IIOMetadataNode("pHYs");
        physNode.setAttribute("pixelsPerUnitXAxis", pixelsPerMeterString);
        physNode.setAttribute("pixelsPerUnitYAxis", pixelsPerMeterString);
        physNode.setAttribute("unitSpecifier", "meter");
        IIOMetadataNode root = new IIOMetadataNode(metadata.getNativeMetadataFormatName());
        root.appendChild(physNode);
        metadata.mergeTree(metadata.getNativeMetadataFormatName(), root);
        IIOMetadataNode dimension = PNGCanvas.createDimensionNode(dpi);
        root = new IIOMetadataNode(PNG_STANDARD_METADATA_FORMAT);
        root.appendChild(dimension);
        metadata.mergeTree(PNG_STANDARD_METADATA_FORMAT, root);
    }

    private static IIOMetadataNode createDimensionNode(int dpi) {
        double pixelsPerMM = (double)dpi / 25.4;
        String pixelsPerMMString = Double.toString(pixelsPerMM);
        IIOMetadataNode horizontalPixelSize = new IIOMetadataNode("HorizontalPixelSize");
        horizontalPixelSize.setAttribute(METADATA_KEY_VALUE, pixelsPerMMString);
        IIOMetadataNode verticalPixelSize = new IIOMetadataNode("VerticalPixelSize");
        verticalPixelSize.setAttribute(METADATA_KEY_VALUE, pixelsPerMMString);
        IIOMetadataNode dimension = new IIOMetadataNode("Dimension");
        dimension.appendChild(horizontalPixelSize);
        dimension.appendChild(verticalPixelSize);
        return dimension;
    }

    private static void addTextMetadata(IIOMetadata metadata) throws IIOInvalidTreeException {
        IIOMetadataNode textEntry = new IIOMetadataNode("tEXtEntry");
        textEntry.setAttribute(METADATA_KEY_KEYWORD, "Title");
        textEntry.setAttribute(METADATA_KEY_VALUE, "Swiss QR Bill");
        IIOMetadataNode text = new IIOMetadataNode("tEXt");
        text.appendChild(textEntry);
        IIOMetadataNode commentMetadata = new IIOMetadataNode(metadata.getNativeMetadataFormatName());
        commentMetadata.appendChild(text);
        metadata.mergeTree(metadata.getNativeMetadataFormatName(), commentMetadata);
    }
}

