/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.io.Serializable;
import java.util.Objects;
import net.codecrete.qrbill.generator.GraphicsFormat;
import net.codecrete.qrbill.generator.Language;
import net.codecrete.qrbill.generator.OutputSize;
import net.codecrete.qrbill.generator.SeparatorType;

public class BillFormat
implements Serializable {
    public static final double DEFAULT_MARGIN_WIDTH = 5.0;
    private static final long serialVersionUID = -2874086922578292745L;
    private OutputSize outputSize = OutputSize.QR_BILL_ONLY;
    private Language language = Language.EN;
    private SeparatorType separatorType = SeparatorType.DASHED_LINE_WITH_SCISSORS;
    private String fontFamily = "Helvetica,Arial,\"Liberation Sans\"";
    private GraphicsFormat graphicsFormat = GraphicsFormat.SVG;
    private int resolution = 144;
    private double marginLeft = 5.0;
    private double marginRight = 5.0;
    private String localCountryCode = "CH";

    public BillFormat() {
    }

    public BillFormat(BillFormat format) {
        this.outputSize = format.outputSize;
        this.language = format.language;
        this.separatorType = format.separatorType;
        this.fontFamily = format.fontFamily;
        this.graphicsFormat = format.graphicsFormat;
        this.resolution = format.resolution;
        this.marginLeft = format.marginLeft;
        this.marginRight = format.marginRight;
        this.localCountryCode = format.localCountryCode;
    }

    public OutputSize getOutputSize() {
        return this.outputSize;
    }

    public void setOutputSize(OutputSize outputSize) {
        this.outputSize = outputSize;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public SeparatorType getSeparatorType() {
        return this.separatorType;
    }

    public void setSeparatorType(SeparatorType separatorType) {
        this.separatorType = separatorType;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public GraphicsFormat getGraphicsFormat() {
        return this.graphicsFormat;
    }

    public void setGraphicsFormat(GraphicsFormat graphicsFormat) {
        this.graphicsFormat = graphicsFormat;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public double getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(double marginLeft) {
        this.marginLeft = marginLeft;
    }

    public double getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(double marginRight) {
        this.marginRight = marginRight;
    }

    public String getLocalCountryCode() {
        return this.localCountryCode;
    }

    public void setLocalCountryCode(String localCountryCode) {
        this.localCountryCode = localCountryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillFormat that = (BillFormat)o;
        return this.outputSize == that.outputSize && this.language == that.language && this.separatorType == that.separatorType && Objects.equals(this.fontFamily, that.fontFamily) && this.graphicsFormat == that.graphicsFormat && this.resolution == that.resolution && this.marginLeft == that.marginLeft && this.marginRight == that.marginRight && Objects.equals(this.localCountryCode, that.localCountryCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.outputSize, this.language, this.separatorType, this.fontFamily, this.graphicsFormat, this.resolution, this.marginLeft, this.marginLeft, this.localCountryCode});
    }

    public String toString() {
        return "BillFormat{outputSize=" + (Object)((Object)this.outputSize) + ", language=" + (Object)((Object)this.language) + ", separatorType=" + (Object)((Object)this.separatorType) + ", fontFamily='" + this.fontFamily + '\'' + ", graphicsFormat=" + (Object)((Object)this.graphicsFormat) + ", resolution=" + this.resolution + ", marginLeft=" + this.marginLeft + ", marginRight=" + this.marginRight + ", localCountryCode='" + this.localCountryCode + '\'' + '}';
    }
}

