/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.codecrete.qrbill.generator.Address;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.BillFormat;
import net.codecrete.qrbill.generator.Payments;
import net.codecrete.qrbill.generator.ValidationResult;
import net.codecrete.qrbill.generator.Validator;

public class BillTextFormatter {
    private final Bill bill;

    public BillTextFormatter(Bill bill) {
        this(bill, false);
    }

    public BillTextFormatter(Bill bill, boolean isValidated) {
        if (!isValidated) {
            ValidationResult result = Validator.validate(bill);
            this.bill = result.getCleanedBill();
        } else {
            this.bill = bill;
        }
    }

    public String getPayableTo() {
        return this.getAccount() + "\n" + this.getCreditorAddress();
    }

    public String getPayableToReduced() {
        return this.getAccount() + "\n" + this.getCreditorAddressReduced();
    }

    public String getAccount() {
        return Payments.formatIBAN(this.bill.getAccount());
    }

    public String getCreditorAddress() {
        return BillTextFormatter.formatAddressForDisplay(this.bill.getCreditor(), this.isCreditorWithCountryCode());
    }

    public String getCreditorAddressReduced() {
        return BillTextFormatter.formatAddressForDisplay(this.createReducedAddress(this.bill.getCreditor()), this.isCreditorWithCountryCode());
    }

    public String getReference() {
        return BillTextFormatter.formatReferenceNumber(this.bill.getReference());
    }

    public String getAmount() {
        if (this.bill.getAmount() == null) {
            return null;
        }
        return BillTextFormatter.formatAmountForDisplay(this.bill.getAmount());
    }

    public String getPayableBy() {
        if (this.bill.getDebtor() == null) {
            return null;
        }
        return BillTextFormatter.formatAddressForDisplay(this.bill.getDebtor(), this.isDebtorWithCountryCode());
    }

    public String getPayableByReduced() {
        if (this.bill.getDebtor() == null) {
            return null;
        }
        return BillTextFormatter.formatAddressForDisplay(this.createReducedAddress(this.bill.getDebtor()), this.isDebtorWithCountryCode());
    }

    public String getAdditionalInformation() {
        String info = this.bill.getUnstructuredMessage();
        if (this.bill.getBillInformation() != null) {
            info = info == null ? this.bill.getBillInformation() : info + "\n" + this.bill.getBillInformation();
        }
        return info;
    }

    private static String formatAmountForDisplay(BigDecimal amount) {
        return BillTextFormatter.createAmountFormatter().format(amount);
    }

    private static String formatAddressForDisplay(Address address, boolean withCountryCode) {
        StringBuilder sb = new StringBuilder();
        sb.append(address.getName());
        if (address.getType() == Address.Type.STRUCTURED) {
            String houseNo;
            String street = address.getStreet();
            if (street != null) {
                sb.append("\n");
                sb.append(street);
            }
            if ((houseNo = address.getHouseNo()) != null) {
                sb.append(street != null ? " " : "\n");
                sb.append(houseNo);
            }
            sb.append("\n");
            if (withCountryCode) {
                sb.append(address.getCountryCode());
                sb.append(" \u2013 ");
            }
            sb.append(address.getPostalCode());
            sb.append(" ");
            sb.append(address.getTown());
        } else if (address.getType() == Address.Type.COMBINED_ELEMENTS) {
            if (address.getAddressLine1() != null) {
                sb.append("\n");
                sb.append(address.getAddressLine1());
            }
            sb.append("\n");
            if (withCountryCode) {
                sb.append(address.getCountryCode());
                sb.append(" \u2013 ");
            }
            sb.append(address.getAddressLine2());
        }
        return sb.toString();
    }

    private static String formatReferenceNumber(String refNo) {
        if (refNo == null) {
            return null;
        }
        int len = (refNo = refNo.trim()).length();
        if (len == 0) {
            return null;
        }
        if (refNo.startsWith("RF")) {
            return Payments.formatIBAN(refNo);
        }
        return Payments.formatQRReferenceNumber(refNo);
    }

    private boolean isCreditorWithCountryCode() {
        return BillTextFormatter.isForeignAddress(this.bill.getCreditor(), this.bill.getFormat()) || BillTextFormatter.isForeignAddress(this.bill.getDebtor(), this.bill.getFormat());
    }

    private boolean isDebtorWithCountryCode() {
        return BillTextFormatter.isForeignAddress(this.bill.getDebtor(), this.bill.getFormat());
    }

    private static boolean isForeignAddress(Address address, BillFormat format) {
        return address != null && !format.getLocalCountryCode().equals(address.getCountryCode());
    }

    private Address createReducedAddress(Address address) {
        Address reducedAddress = new Address();
        reducedAddress.setName(address.getName());
        reducedAddress.setCountryCode(address.getCountryCode());
        if (address.getType() == Address.Type.STRUCTURED) {
            reducedAddress.setPostalCode(address.getPostalCode());
            reducedAddress.setTown(address.getTown());
        } else if (address.getType() == Address.Type.COMBINED_ELEMENTS) {
            reducedAddress.setAddressLine2(address.getAddressLine2());
        }
        return reducedAddress;
    }

    private static DecimalFormat createAmountFormatter() {
        DecimalFormat format = new DecimalFormat("###,##0.00");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(' ');
        format.setDecimalFormatSymbols(symbols);
        return format;
    }
}

