/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.util.Locale;
import net.codecrete.qrbill.generator.SPSCharacterSet;
import net.codecrete.qrbill.generator.StringCleanup;
import net.codecrete.qrbill.generator.Strings;

public class Payments {
    private static final int[] MOD_10 = new int[]{0, 9, 4, 6, 8, 2, 7, 1, 3, 5};

    private Payments() {
    }

    static String cleanedText(String text, SPSCharacterSet characterSet) {
        return StringCleanup.cleanedText(text, characterSet);
    }

    static String cleanedAndTrimmedText(String text, SPSCharacterSet characterSet) {
        return StringCleanup.cleanedAndTrimmedText(text, characterSet);
    }

    public static boolean isValidText(String text, SPSCharacterSet characterSet) {
        return StringCleanup.isValidText(text, characterSet);
    }

    public static boolean isValidIBAN(String iban) {
        int len = (iban = Strings.whiteSpaceRemoved(iban)).length();
        if (len < 5) {
            return false;
        }
        if (!Payments.isAlphaNumeric(iban)) {
            return false;
        }
        if (!Character.isLetter(iban.charAt(0)) || !Character.isLetter(iban.charAt(1))) {
            return false;
        }
        if (!Character.isDigit(iban.charAt(2)) || !Character.isDigit(iban.charAt(3))) {
            return false;
        }
        String checkDigits = iban.substring(2, 4);
        if ("00".equals(checkDigits) || "01".equals(checkDigits) || "99".equals(checkDigits)) {
            return false;
        }
        return Payments.hasValidMod97CheckDigits(iban);
    }

    public static boolean isQRIBAN(String iban) {
        return !(!Payments.isValidIBAN(iban = Strings.whiteSpaceRemoved(iban).toUpperCase(Locale.US)) || !iban.startsWith("CH") && !iban.startsWith("LI") || iban.charAt(4) != '3' || iban.charAt(5) != '0' && iban.charAt(5) != '1');
    }

    public static String formatIBAN(String iban) {
        StringBuilder sb = new StringBuilder(25);
        int len = iban.length();
        for (int pos = 0; pos < len; pos += 4) {
            int endPos = pos + 4;
            if (endPos > len) {
                endPos = len;
            }
            sb.append(iban, pos, endPos);
            if (endPos == len) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public static boolean isValidISO11649Reference(String reference) {
        if ((reference = Strings.whiteSpaceRemoved(reference)).length() < 5 || reference.length() > 25) {
            return false;
        }
        if (!Payments.isAlphaNumeric(reference)) {
            return false;
        }
        if (reference.charAt(0) != 'R' || reference.charAt(1) != 'F') {
            return false;
        }
        if (!Character.isDigit(reference.charAt(2)) || !Character.isDigit(reference.charAt(3))) {
            return false;
        }
        return Payments.hasValidMod97CheckDigits(reference);
    }

    public static String createISO11649Reference(String rawReference) {
        String whiteSpaceRemoved = Strings.whiteSpaceRemoved(rawReference);
        int modulo = Payments.calculateMod97("RF00" + whiteSpaceRemoved);
        return String.format("RF%02d", 98 - modulo) + whiteSpaceRemoved;
    }

    private static boolean hasValidMod97CheckDigits(String number) {
        return Payments.calculateMod97(number) == 1;
    }

    private static int calculateMod97(String reference) {
        int len = reference.length();
        if (len < 5) {
            throw new IllegalArgumentException("Insufficient characters for checksum calculation");
        }
        String rearranged = reference.substring(4) + reference.substring(0, 4);
        int sum = 0;
        for (int i = 0; i < len; ++i) {
            char ch = rearranged.charAt(i);
            if (ch >= '0' && ch <= '9') {
                sum = sum * 10 + (ch - 48);
            } else if (ch >= 'A' && ch <= 'Z') {
                sum = sum * 100 + (ch - 65 + 10);
            } else if (ch >= 'a' && ch <= 'z') {
                sum = sum * 100 + (ch - 97 + 10);
            } else {
                throw new IllegalArgumentException("Invalid character in reference: " + ch);
            }
            if (sum <= 9999999) continue;
            sum %= 97;
        }
        return sum %= 97;
    }

    public static boolean isValidQRReference(String reference) {
        if (!Payments.isNumeric(reference = Strings.whiteSpaceRemoved(reference))) {
            return false;
        }
        int len = reference.length();
        if (len != 27) {
            return false;
        }
        if ("000000000000000000000000000".equals(reference)) {
            return false;
        }
        return Payments.calculateMod10(reference) == 0;
    }

    public static String createQRReference(String rawReference) {
        String rawRef = Strings.whiteSpaceRemoved(rawReference);
        if (!Payments.isNumeric(rawRef)) {
            throw new IllegalArgumentException("Invalid character in reference (digits allowed only)");
        }
        if (rawRef.length() > 26) {
            throw new IllegalArgumentException("Reference number is too long");
        }
        int mod10 = Payments.calculateMod10(rawRef);
        return "00000000000000000000000000".substring(0, 26 - rawRef.length()) + rawRef + (char)(48 + mod10);
    }

    private static int calculateMod10(String reference) {
        int len = reference.length();
        int carry = 0;
        for (int i = 0; i < len; ++i) {
            int digit = reference.charAt(i) - 48;
            carry = MOD_10[(carry + digit) % 10];
        }
        return (10 - carry) % 10;
    }

    public static String formatQRReferenceNumber(String refNo) {
        int len = refNo.length();
        StringBuilder sb = new StringBuilder();
        int t = 0;
        while (t < len) {
            int n = t + (len - t - 1) % 5 + 1;
            if (t != 0) {
                sb.append(" ");
            }
            sb.append(refNo, t, n);
            t = n;
        }
        return sb.toString();
    }

    static boolean isNumeric(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    static boolean isAlphaNumeric(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') continue;
            return false;
        }
        return true;
    }

    static boolean isAlpha(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') continue;
            return false;
        }
        return true;
    }
}

