/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.regex.Pattern;
import net.codecrete.qrbill.generator.Address;
import net.codecrete.qrbill.generator.AlternativeScheme;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.QRBillValidationError;
import net.codecrete.qrbill.generator.QrDataSeparator;
import net.codecrete.qrbill.generator.ValidationMessage;
import net.codecrete.qrbill.generator.ValidationResult;

public class QRCodeText {
    private final Bill bill;
    private final StringBuilder textBuilder;
    private final String dataSeparator;
    private static final Pattern VALID_VERSION = Pattern.compile("^02\\d\\d$");
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\r?\n|\r");

    private QRCodeText(Bill bill) {
        this.bill = bill;
        this.textBuilder = new StringBuilder();
        this.dataSeparator = bill.getSeparator() == QrDataSeparator.CR_LF ? "\r\n" : "\n";
    }

    public static String create(Bill bill) {
        QRCodeText qrCodeText = new QRCodeText(bill);
        return qrCodeText.createText();
    }

    private String createText() {
        boolean hasAlternativeSchemes;
        this.textBuilder.append("SPC");
        this.appendDataField("0200");
        this.appendDataField("1");
        this.appendDataField(this.bill.getAccount());
        this.appendPerson(this.bill.getCreditor());
        this.appendPerson(null);
        this.appendDataField(this.bill.getAmount() == null ? "" : QRCodeText.formatAmountForCode(this.bill.getAmount()));
        this.appendDataField(this.bill.getCurrency());
        this.appendPerson(this.bill.getDebtor());
        this.appendDataField(this.bill.getReferenceType());
        this.appendDataField(this.bill.getReference());
        this.appendDataField(this.bill.getUnstructuredMessage());
        this.appendDataField("EPD");
        boolean bl = hasAlternativeSchemes = this.bill.getAlternativeSchemes() != null && this.bill.getAlternativeSchemes().length > 0;
        if (hasAlternativeSchemes || this.bill.getBillInformation() != null) {
            this.appendDataField(this.bill.getBillInformation());
        }
        if (hasAlternativeSchemes) {
            this.appendDataField(this.bill.getAlternativeSchemes()[0].getInstruction());
            if (this.bill.getAlternativeSchemes().length > 1) {
                this.appendDataField(this.bill.getAlternativeSchemes()[1].getInstruction());
            }
        }
        return this.textBuilder.toString();
    }

    private void appendPerson(Address address) {
        if (address != null) {
            this.appendDataField(address.getType() == Address.Type.STRUCTURED ? "S" : "K");
            this.appendDataField(address.getName());
            this.appendDataField(address.getType() == Address.Type.STRUCTURED ? address.getStreet() : address.getAddressLine1());
            this.appendDataField(address.getType() == Address.Type.STRUCTURED ? address.getHouseNo() : address.getAddressLine2());
            this.appendDataField(address.getPostalCode());
            this.appendDataField(address.getTown());
            this.appendDataField(address.getCountryCode());
        } else {
            for (int i = 0; i < 7; ++i) {
                this.appendDataField(null);
            }
        }
    }

    private void appendDataField(String value) {
        if (value == null) {
            value = "";
        }
        this.textBuilder.append(this.dataSeparator).append(value);
    }

    private static DecimalFormat createAmountFormatter() {
        DecimalFormat format = new DecimalFormat("0.00");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        symbols.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(symbols);
        format.setParseBigDecimal(true);
        return format;
    }

    private static String formatAmountForCode(BigDecimal amount) {
        return QRCodeText.createAmountFormatter().format(amount);
    }

    public static Bill decode(String text) {
        String[] lines = QRCodeText.splitLines(text);
        QRCodeText.validateHeader(lines);
        Bill bill = new Bill();
        bill.setVersion(Bill.Version.V2_0);
        bill.setSeparator(text.contains("\r\n") ? QrDataSeparator.CR_LF : QrDataSeparator.LF);
        bill.setAccount(lines[3]);
        bill.setCreditor(QRCodeText.decodeAddress(lines, 4, false));
        if (!lines[18].isEmpty()) {
            ParsePosition position = new ParsePosition(0);
            BigDecimal amount = (BigDecimal)QRCodeText.createAmountFormatter().parse(lines[18], position);
            if (position.getIndex() == lines[18].length()) {
                bill.setAmount(amount);
            } else {
                QRCodeText.throwSingleValidationError("amount", "number_invalid");
            }
        } else {
            bill.setAmount(null);
        }
        bill.setCurrency(lines[19]);
        bill.setDebtor(QRCodeText.decodeAddress(lines, 20, true));
        bill.setReference(lines[28]);
        bill.setReferenceType(lines[27]);
        bill.setUnstructuredMessage(lines[29]);
        if (!"EPD".equals(lines[30])) {
            QRCodeText.throwSingleValidationError("trailer", "data_structure_invalid");
        }
        bill.setBillInformation(lines.length > 31 ? lines[31] : "");
        QRCodeText.decodeAlternativeSchemes(lines, bill);
        return bill;
    }

    private static void validateHeader(String[] lines) {
        if (!(lines.length >= 31 && lines.length <= 34 || lines.length == 35 && lines[34].isEmpty())) {
            QRCodeText.throwSingleValidationError("qrText", "data_structure_invalid");
        }
        if (!"SPC".equals(lines[0])) {
            QRCodeText.throwSingleValidationError("qrText", "data_structure_invalid");
        }
        if (!VALID_VERSION.matcher(lines[1]).matches()) {
            QRCodeText.throwSingleValidationError("version", "version_unsupported");
        }
        if (!"1".equals(lines[2])) {
            QRCodeText.throwSingleValidationError("codingType", "coding_type_unsupported");
        }
    }

    private static void decodeAlternativeSchemes(String[] lines, Bill bill) {
        AlternativeScheme[] alternativeSchemes = null;
        int numSchemes = lines.length - 32;
        if (numSchemes > 0 && lines[32 + numSchemes - 1].isEmpty()) {
            --numSchemes;
        }
        if (numSchemes > 0) {
            alternativeSchemes = new AlternativeScheme[numSchemes];
            for (int i = 0; i < numSchemes; ++i) {
                AlternativeScheme scheme = new AlternativeScheme();
                scheme.setInstruction(lines[32 + i]);
                alternativeSchemes[i] = scheme;
            }
        }
        bill.setAlternativeSchemes(alternativeSchemes);
    }

    private static Address decodeAddress(String[] lines, int startLine, boolean isOptional) {
        boolean isEmpty;
        boolean bl = isEmpty = lines[startLine].isEmpty() && lines[startLine + 1].isEmpty() && lines[startLine + 2].isEmpty() && lines[startLine + 3].isEmpty() && lines[startLine + 4].isEmpty() && lines[startLine + 5].isEmpty() && lines[startLine + 6].isEmpty();
        if (isEmpty && isOptional) {
            return null;
        }
        Address address = new Address();
        boolean isStructuredAddress = "S".equals(lines[startLine]);
        address.setName(lines[startLine + 1]);
        if (isStructuredAddress) {
            address.setStreet(lines[startLine + 2]);
            address.setHouseNo(lines[startLine + 3]);
        } else {
            address.setAddressLine1(lines[startLine + 2]);
            address.setAddressLine2(lines[startLine + 3]);
        }
        if (!lines[startLine + 4].isEmpty()) {
            address.setPostalCode(lines[startLine + 4]);
        }
        if (!lines[startLine + 5].isEmpty()) {
            address.setTown(lines[startLine + 5]);
        }
        address.setCountryCode(lines[startLine + 6]);
        return address;
    }

    private static String[] splitLines(String text) {
        return NEWLINE_PATTERN.split(text, -1);
    }

    private static void throwSingleValidationError(String field, String messageKey) {
        ValidationResult result = new ValidationResult();
        result.addMessage(ValidationMessage.Type.ERROR, field, messageKey);
        throw new QRBillValidationError(result);
    }
}

