/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.util.function.Predicate;

public enum SPSCharacterSet {
    LATIN_1_SUBSET(SPSCharacterSet::isInLatin1Subset),
    EXTENDED_LATIN(SPSCharacterSet::isInExtendedLatin),
    FULL_UNICODE(SPSCharacterSet::isInUnicode);

    private final Predicate<Integer> containsCharacter;

    private SPSCharacterSet(Predicate<Integer> containsCharacter) {
        this.containsCharacter = containsCharacter;
    }

    public boolean contains(char ch) {
        return this.containsCharacter.test(Integer.valueOf(ch));
    }

    public boolean contains(int codePoint) {
        return this.containsCharacter.test(codePoint);
    }

    private static boolean isInLatin1Subset(int codePoint) {
        if (codePoint < 32) {
            return false;
        }
        if (codePoint == 94) {
            return false;
        }
        if (codePoint <= 126) {
            return true;
        }
        if (codePoint == 163 || codePoint == 180) {
            return true;
        }
        if (codePoint < 192 || codePoint > 253) {
            return false;
        }
        if (codePoint == 195 || codePoint == 197 || codePoint == 198) {
            return false;
        }
        if (codePoint == 208 || codePoint == 213 || codePoint == 215 || codePoint == 216) {
            return false;
        }
        if (codePoint == 221 || codePoint == 222) {
            return false;
        }
        if (codePoint == 227 || codePoint == 229 || codePoint == 230) {
            return false;
        }
        return codePoint != 240 && codePoint != 245 && codePoint != 248;
    }

    private static boolean isInExtendedLatin(int codePoint) {
        if (codePoint >= 32 && codePoint <= 126) {
            return true;
        }
        if (codePoint >= 160 && codePoint <= 383) {
            return true;
        }
        if (codePoint >= 536 && codePoint <= 539) {
            return true;
        }
        return codePoint == 8364;
    }

    private static boolean isInUnicode(int codePoint) {
        return true;
    }
}

