/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.codecrete.usb.USBDevice;
import net.codecrete.usb.USBDevicePredicate;
import net.codecrete.usb.common.USBDeviceRegistry;
import net.codecrete.usb.linux.LinuxUSBDeviceRegistry;
import net.codecrete.usb.macos.MacosUSBDeviceRegistry;
import net.codecrete.usb.windows.WindowsUSBDeviceRegistry;

public class USB {
    private static USBDeviceRegistry singletonInstance = null;

    private static USBDeviceRegistry createInstance() {
        USBDeviceRegistry impl;
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        if (osName.equals("Mac OS X") && (osArch.equals("x86_64") || osArch.equals("aarch64"))) {
            impl = new MacosUSBDeviceRegistry();
        } else if (osName.startsWith("Windows") && osArch.equals("amd64")) {
            impl = new WindowsUSBDeviceRegistry();
        } else if (osName.equals("Linux") && (osArch.equals("amd64") || osArch.equals("aarch64"))) {
            impl = new LinuxUSBDeviceRegistry();
        } else {
            throw new UnsupportedOperationException(String.format("Java Does USB has no implementation for architecture %s/%s", osName, osArch));
        }
        return impl;
    }

    private static synchronized USBDeviceRegistry instance() {
        if (singletonInstance == null) {
            singletonInstance = USB.createInstance();
            singletonInstance.start();
        }
        return singletonInstance;
    }

    private USB() {
    }

    public static List<USBDevice> getAllDevices() {
        return USB.instance().getAllDevices();
    }

    public static List<USBDevice> getDevices(USBDevicePredicate predicate) {
        return USB.instance().getAllDevices().stream().filter(predicate::matches).toList();
    }

    public static Optional<USBDevice> getDevice(USBDevicePredicate predicate) {
        return USB.instance().getAllDevices().stream().filter(predicate::matches).findFirst();
    }

    public static Optional<USBDevice> getDevice(int vendorId, int productId) {
        return USB.getDevice(device -> device.vendorId() == vendorId && device.productId() == productId);
    }

    public static void setOnDeviceConnected(Consumer<USBDevice> handler) {
        USB.instance().setOnDeviceConnected(handler);
    }

    public static void setOnDeviceDisconnected(Consumer<USBDevice> handler) {
        USB.instance().setOnDeviceDisconnected(handler);
    }
}

