/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.io.IOException;
import java.io.InputStream;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.concurrent.ArrayBlockingQueue;
import net.codecrete.usb.USBDirection;
import net.codecrete.usb.USBException;
import net.codecrete.usb.common.Transfer;
import net.codecrete.usb.common.USBDeviceImpl;

public abstract class EndpointInputStream
extends InputStream {
    protected USBDeviceImpl device;
    protected final int endpointNumber;
    protected final Arena arena;
    protected final int transferSize;
    private final ArrayBlockingQueue<Transfer> completedTransferQueue;
    private int numOutstandingTransfers;
    private Transfer currentTransfer;
    private int readOffset;

    protected EndpointInputStream(USBDeviceImpl device, int endpointNumber, int bufferSize) {
        this.device = device;
        this.endpointNumber = endpointNumber;
        this.arena = Arena.ofShared();
        int packetSize = device.getEndpoint(USBDirection.IN, endpointNumber).packetSize();
        int numPacketsPerTransfer = (int)Math.round(Math.sqrt((double)bufferSize / (double)packetSize));
        numPacketsPerTransfer = Math.min(Math.max(numPacketsPerTransfer, 4), 32);
        this.transferSize = numPacketsPerTransfer * packetSize;
        int maxOutstandingTransfers = Math.max((bufferSize + this.transferSize / 2) / this.transferSize, 3);
        this.configureEndpoint();
        this.completedTransferQueue = new ArrayBlockingQueue(maxOutstandingTransfers);
        try {
            for (int i = 0; i < maxOutstandingTransfers; ++i) {
                Transfer transfer = device.createTransfer();
                transfer.setData(this.arena.allocate(this.transferSize, 8L));
                transfer.setDataSize(this.transferSize);
                transfer.setCompletion(this::onCompletion);
                if (i == 0) {
                    this.currentTransfer = transfer;
                    continue;
                }
                this.submitTransfer(transfer);
            }
        }
        catch (Exception t) {
            this.collectOutstandingTransfers();
            throw t;
        }
    }

    private boolean isClosed() {
        return this.device == null;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.device.abortTransfers(USBDirection.IN, this.endpointNumber);
        }
        catch (USBException uSBException) {
            // empty catch block
        }
        this.device = null;
        this.collectOutstandingTransfers();
    }

    @Override
    public int read() throws IOException {
        if (this.isClosed()) {
            return -1;
        }
        if (this.available() == 0) {
            this.receiveMoreData();
        }
        int b = this.currentTransfer.data().get(ValueLayout.JAVA_BYTE, (long)this.readOffset) & 0xFF;
        ++this.readOffset;
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n;
        if (this.isClosed()) {
            return -1;
        }
        int numRead = 0;
        do {
            if (this.available() == 0) {
                this.receiveMoreData();
            }
            n = Math.min(len - numRead, this.currentTransfer.resultSize() - this.readOffset);
            MemorySegment.copy(this.currentTransfer.data(), this.readOffset, MemorySegment.ofArray(b), (long)off + (long)numRead, n);
            this.readOffset += n;
        } while ((numRead += n) < len && this.hasMoreTransfers());
        return numRead;
    }

    @Override
    public int available() throws IOException {
        return this.currentTransfer.resultSize() - this.readOffset;
    }

    private boolean hasMoreTransfers() {
        return !this.completedTransferQueue.isEmpty();
    }

    private void receiveMoreData() throws IOException {
        try {
            do {
                this.submitTransfer(this.currentTransfer);
                this.currentTransfer = this.waitForCompletedTransfer();
                this.readOffset = 0;
                if (this.currentTransfer.resultCode() == 0) continue;
                this.device.throwOSException(this.currentTransfer.resultCode(), "error occurred while reading from endpoint %d", this.endpointNumber);
            } while (this.currentTransfer.resultSize() <= 0);
        }
        catch (Exception t) {
            this.close();
            throw t;
        }
    }

    private Transfer waitForCompletedTransfer() {
        while (true) {
            try {
                Transfer transfer = this.completedTransferQueue.take();
                --this.numOutstandingTransfers;
                return transfer;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private void submitTransfer(Transfer transfer) {
        this.submitTransferIn(transfer);
        ++this.numOutstandingTransfers;
    }

    private void onCompletion(Transfer transfer) {
        this.completedTransferQueue.add(transfer);
    }

    private void collectOutstandingTransfers() {
        while (this.numOutstandingTransfers > 0) {
            this.waitForCompletedTransfer();
        }
        this.completedTransferQueue.clear();
        this.currentTransfer = null;
        this.arena.close();
    }

    protected abstract void submitTransferIn(Transfer var1);

    protected void configureEndpoint() {
    }
}

