/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Collections;
import java.util.List;
import java.util.function.IntFunction;
import net.codecrete.usb.USBDevice;
import net.codecrete.usb.USBDirection;
import net.codecrete.usb.USBEndpoint;
import net.codecrete.usb.USBException;
import net.codecrete.usb.USBInterface;
import net.codecrete.usb.USBTimeoutException;
import net.codecrete.usb.USBTransferType;
import net.codecrete.usb.Version;
import net.codecrete.usb.common.Configuration;
import net.codecrete.usb.common.ConfigurationParser;
import net.codecrete.usb.common.Transfer;
import net.codecrete.usb.common.USBInterfaceImpl;
import net.codecrete.usb.usbstandard.DeviceDescriptor;

public abstract class USBDeviceImpl
implements USBDevice {
    protected final Object uniqueDeviceId;
    protected List<USBInterface> interfaceList;
    protected byte[] rawDeviceDescriptor;
    protected byte[] rawConfigurationDescriptor;
    protected final int vid;
    protected final int pid;
    protected String manufacturerString;
    protected String productString;
    protected String serialString;
    protected int deviceClass;
    protected int deviceSubclass;
    protected int deviceProtocol;
    protected Version versionUSB;
    protected Version versionDevice;

    protected USBDeviceImpl(Object id, int vendorId, int productId) {
        assert (id != null);
        this.uniqueDeviceId = id;
        this.vid = vendorId;
        this.pid = productId;
    }

    @Override
    public void detachStandardDrivers() {
        if (this.isOpen()) {
            throw new USBException("detachStandardDrivers() must not be called while the device is open");
        }
    }

    @Override
    public void attachStandardDrivers() {
        if (this.isOpen()) {
            throw new USBException("attachStandardDrivers() must not be called while the device is open");
        }
    }

    protected void checkIsOpen() {
        if (!this.isOpen()) {
            throw new USBException("device needs to be opened first for this operation");
        }
    }

    @Override
    public int productId() {
        return this.pid;
    }

    @Override
    public int vendorId() {
        return this.vid;
    }

    @Override
    public String product() {
        return this.productString;
    }

    @Override
    public String manufacturer() {
        return this.manufacturerString;
    }

    @Override
    public String serialNumber() {
        return this.serialString;
    }

    @Override
    public int classCode() {
        return this.deviceClass;
    }

    @Override
    public int subclassCode() {
        return this.deviceSubclass;
    }

    @Override
    public int protocolCode() {
        return this.deviceProtocol;
    }

    @Override
    public Version usbVersion() {
        return this.versionUSB;
    }

    @Override
    public Version deviceVersion() {
        return this.versionDevice;
    }

    @Override
    public byte[] configurationDescriptor() {
        return this.rawConfigurationDescriptor;
    }

    @Override
    public byte[] deviceDescriptor() {
        return this.rawDeviceDescriptor;
    }

    public Object getUniqueId() {
        return this.uniqueDeviceId;
    }

    public void setFromDeviceDescriptor(MemorySegment descriptor) {
        this.rawDeviceDescriptor = descriptor.toArray(ValueLayout.JAVA_BYTE);
        DeviceDescriptor deviceDescriptor = new DeviceDescriptor(descriptor);
        this.deviceClass = deviceDescriptor.deviceClass() & 0xFF;
        this.deviceSubclass = deviceDescriptor.deviceSubClass() & 0xFF;
        this.deviceProtocol = deviceDescriptor.deviceProtocol() & 0xFF;
        this.versionUSB = new Version(deviceDescriptor.usbVersion());
        this.versionDevice = new Version(deviceDescriptor.deviceVersion());
    }

    protected Configuration setConfigurationDescriptor(MemorySegment descriptor) {
        this.rawConfigurationDescriptor = descriptor.toArray(ValueLayout.JAVA_BYTE);
        Configuration configuration = ConfigurationParser.parseConfigurationDescriptor(descriptor);
        this.interfaceList = configuration.interfaces();
        return configuration;
    }

    public void setProductStrings(String manufacturer, String product, String serialNumber) {
        this.manufacturerString = manufacturer;
        this.productString = product;
        this.serialString = serialNumber;
    }

    public void setProductString(MemorySegment descriptor, IntFunction<String> stringLookup) {
        DeviceDescriptor deviceDescriptor = new DeviceDescriptor(descriptor);
        this.manufacturerString = stringLookup.apply(deviceDescriptor.iManufacturer());
        this.productString = stringLookup.apply(deviceDescriptor.iProduct());
        this.serialString = stringLookup.apply(deviceDescriptor.iSerialNumber());
    }

    public void setClassCodes(int classCode, int subclassCode, int protocolCode) {
        this.deviceClass = classCode;
        this.deviceSubclass = subclassCode;
        this.deviceProtocol = protocolCode;
    }

    public void setVersions(int usbVersion, int deviceVersion) {
        this.versionUSB = new Version(usbVersion);
        this.versionDevice = new Version(deviceVersion);
    }

    @Override
    public List<USBInterface> interfaces() {
        return Collections.unmodifiableList(this.interfaceList);
    }

    public void setClaimed(int interfaceNumber, boolean claimed) {
        for (USBInterface intf : this.interfaceList) {
            if (intf.number() != interfaceNumber) continue;
            ((USBInterfaceImpl)intf).setClaimed(claimed);
            return;
        }
        throw new USBException("internal error (interface not found)");
    }

    @Override
    public USBInterfaceImpl getInterface(int interfaceNumber) {
        return this.interfaceList.stream().filter(intf -> intf.number() == interfaceNumber).findFirst().orElse(null);
    }

    public USBInterfaceImpl getInterfaceWithCheck(int interfaceNumber, boolean isClaimed) {
        USBInterfaceImpl intf = this.getInterface(interfaceNumber);
        if (intf == null) {
            throw new USBException(String.format("invalid interface number: %d", interfaceNumber));
        }
        if (isClaimed && !intf.isClaimed()) {
            throw new USBException(String.format("interface %d must be claimed first", interfaceNumber));
        }
        if (!isClaimed && intf.isClaimed()) {
            throw new USBException(String.format("interface %d has already been claimed", interfaceNumber));
        }
        return intf;
    }

    @Override
    public USBEndpoint getEndpoint(USBDirection direction, int endpointNumber) {
        for (USBInterface intf : this.interfaceList) {
            for (USBEndpoint endpoint : intf.alternate().endpoints()) {
                if (endpoint.direction() != direction || endpoint.number() != endpointNumber) continue;
                return endpoint;
            }
        }
        return null;
    }

    protected EndpointInfo getEndpoint(USBDirection direction, int endpointNumber, USBTransferType transferType1, USBTransferType transferType2) {
        this.checkIsOpen();
        if (endpointNumber >= 1 && endpointNumber <= 127) {
            for (USBInterface intf : this.interfaceList) {
                if (!intf.isClaimed()) continue;
                for (USBEndpoint ep : intf.alternate().endpoints()) {
                    if (ep.number() != endpointNumber || ep.direction() != direction || ep.transferType() != transferType1 && ep.transferType() != transferType2) continue;
                    return new EndpointInfo(intf.number(), ep.number(), (byte)(endpointNumber | (direction == USBDirection.IN ? 128 : 0)), ep.packetSize(), ep.transferType());
                }
            }
        }
        this.throwInvalidEndpointException(direction, endpointNumber, transferType1, transferType2);
        return null;
    }

    protected void throwInvalidEndpointException(USBDirection direction, int endpointNumber, USBTransferType transferType1, USBTransferType transferType2) {
        String transferTypeDesc = transferType2 == null ? transferType1.name() : String.format("%s or %s", transferType1.name(), transferType2.name());
        throw new USBException(String.format("endpoint number %d does not exist, is not part of a claimed interface or is not valid for %s transfer in %s direction", endpointNumber, transferTypeDesc, direction.name()));
    }

    protected int getInterfaceNumber(USBDirection direction, int endpointNumber) {
        if (endpointNumber < 1 || endpointNumber > 127) {
            return -1;
        }
        for (USBInterface intf : this.interfaceList) {
            if (!intf.isClaimed()) continue;
            for (USBEndpoint ep : intf.alternate().endpoints()) {
                if (ep.number() != endpointNumber || ep.direction() != direction) continue;
                return intf.number();
            }
        }
        return -1;
    }

    @Override
    public void transferOut(int endpointNumber, byte[] data) {
        this.transferOut(endpointNumber, data, 0, data.length, 0);
    }

    @Override
    public void transferOut(int endpointNumber, byte[] data, int timeout) {
        this.transferOut(endpointNumber, data, 0, data.length, timeout);
    }

    @Override
    public byte[] transferIn(int endpointNumber) {
        return this.transferIn(endpointNumber, 0);
    }

    protected void waitForTransfer(Transfer transfer, int timeout, USBDirection direction, int endpointNumber) {
        if (timeout <= 0) {
            USBDeviceImpl.waitNoTimeout(transfer);
        } else {
            boolean hasTimedOut = USBDeviceImpl.waitWithTimeout(transfer, timeout);
            if (hasTimedOut && transfer.resultCode() == 0) {
                this.abortTransfers(direction, endpointNumber);
                USBDeviceImpl.waitNoTimeout(transfer);
                throw new USBTimeoutException(USBDeviceImpl.getOperationDescription(direction, endpointNumber) + "aborted due to timeout");
            }
        }
        if (transfer.resultCode() != 0) {
            String operation = USBDeviceImpl.getOperationDescription(direction, endpointNumber);
            this.throwOSException(transfer.resultCode(), operation + " failed", new Object[0]);
        }
    }

    private static void waitNoTimeout(Transfer transfer) {
        while (transfer.resultSize() == -1) {
            try {
                transfer.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static boolean waitWithTimeout(Transfer transfer, int timeout) {
        long expiration = System.currentTimeMillis() + (long)timeout;
        long remainingTimeout = timeout;
        while (remainingTimeout > 0L && transfer.resultSize() == -1) {
            try {
                transfer.wait(remainingTimeout);
                remainingTimeout = expiration - System.currentTimeMillis();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return remainingTimeout <= 0L;
    }

    protected static String getOperationDescription(USBDirection direction, int endpointNumber) {
        if (endpointNumber == 0) {
            return "control transfer";
        }
        return String.format("transfer %s on endpoint %d", direction.name(), endpointNumber);
    }

    protected abstract Transfer createTransfer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void onSyncTransferCompleted(Transfer transfer) {
        Transfer transfer2 = transfer;
        synchronized (transfer2) {
            transfer.notify();
        }
    }

    protected abstract void throwOSException(int var1, String var2, Object ... var3);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        USBDeviceImpl that = (USBDeviceImpl)o;
        return this.uniqueDeviceId.equals(that.uniqueDeviceId);
    }

    public int hashCode() {
        return this.uniqueDeviceId.hashCode();
    }

    public String toString() {
        return "VID: 0x" + String.format("%04x", this.vid) + ", PID: 0x" + String.format("%04x", this.pid) + ", manufacturer: " + this.manufacturerString + ", product: " + this.productString + ", serial: " + this.serialString + ", ID: " + String.valueOf(this.uniqueDeviceId);
    }

    public record EndpointInfo(int interfaceNumber, int endpointNumber, byte endpointAddress, int packetSize, USBTransferType transferType) {
    }
}

