/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import net.codecrete.usb.USBDevice;
import net.codecrete.usb.USBException;
import net.codecrete.usb.common.USBDeviceImpl;

public abstract class USBDeviceRegistry {
    private static final System.Logger LOG = System.getLogger(USBDeviceRegistry.class.getName());
    private List<USBDevice> devices;
    private Throwable failureCause;
    protected Consumer<USBDevice> onDeviceConnectedHandler;
    protected Consumer<USBDevice> onDeviceDisconnectedHandler;
    private final Lock lock = new ReentrantLock();
    private final Condition enumerationComplete = this.lock.newCondition();

    public void start() {
        this.startDeviceMonitor(this::monitorDevices);
    }

    protected abstract void monitorDevices();

    public synchronized List<USBDevice> getAllDevices() {
        return Collections.unmodifiableList(this.devices);
    }

    public void setOnDeviceConnected(Consumer<USBDevice> handler) {
        this.onDeviceConnectedHandler = handler;
    }

    public void setOnDeviceDisconnected(Consumer<USBDevice> handler) {
        this.onDeviceDisconnectedHandler = handler;
    }

    protected void emitOnDeviceConnected(USBDevice device) {
        if (this.onDeviceConnectedHandler == null) {
            return;
        }
        try {
            this.onDeviceConnectedHandler.accept(device);
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, "unhandled exception in 'onDeviceConnected' handler - ignoring", (Throwable)e);
        }
    }

    protected void emitOnDeviceDisconnected(USBDevice device) {
        if (this.onDeviceDisconnectedHandler == null) {
            return;
        }
        try {
            this.onDeviceDisconnectedHandler.accept(device);
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, "unhandled exception in 'onDeviceDisconnected' handler - ignoring", (Throwable)e);
        }
    }

    protected void startDeviceMonitor(Runnable monitorTask) {
        Thread t = new Thread(monitorTask, "USB device monitor");
        t.setDaemon(true);
        t.start();
        this.lock.lock();
        try {
            while (this.devices == null && this.failureCause == null) {
                this.enumerationComplete.awaitUninterruptibly();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.failureCause != null) {
            throw new USBException("initial device enumeration has failed", this.failureCause);
        }
    }

    private void signalEnumerationComplete() {
        this.lock.lock();
        try {
            this.enumerationComplete.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void enumerationFailed(Throwable e) {
        this.failureCause = e;
        this.signalEnumerationComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInitialDeviceList(List<USBDevice> deviceList) {
        USBDeviceRegistry uSBDeviceRegistry = this;
        synchronized (uSBDeviceRegistry) {
            this.devices = deviceList;
        }
        this.signalEnumerationComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDevice(USBDevice device) {
        USBDeviceRegistry uSBDeviceRegistry = this;
        synchronized (uSBDeviceRegistry) {
            if (this.findDeviceIndex(this.devices, ((USBDeviceImpl)device).getUniqueId()) >= 0) {
                return;
            }
            ArrayList<USBDevice> newDeviceList = new ArrayList<USBDevice>(this.devices.size() + 1);
            newDeviceList.addAll(this.devices);
            newDeviceList.add(device);
            this.devices = newDeviceList;
        }
        this.emitOnDeviceConnected(device);
    }

    protected void closeAndRemoveDevice(Object deviceId) {
        USBDevice device = this.findDevice(deviceId);
        if (device == null) {
            return;
        }
        try {
            device.close();
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.INFO, "failed to close USB device - ignoring exception", (Throwable)e);
        }
        this.removeDevice(deviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDevice(Object deviceId) {
        USBDevice device;
        USBDeviceRegistry uSBDeviceRegistry = this;
        synchronized (uSBDeviceRegistry) {
            int index = this.findDeviceIndex(this.devices, deviceId);
            if (index < 0) {
                return;
            }
            device = this.devices.get(index);
            ArrayList<USBDevice> newDeviceList = new ArrayList<USBDevice>(this.devices);
            newDeviceList.remove(index);
            this.devices = newDeviceList;
        }
        this.emitOnDeviceDisconnected(device);
    }

    protected int findDeviceIndex(List<USBDevice> deviceList, Object deviceId) {
        for (int i = 0; i < deviceList.size(); ++i) {
            USBDeviceImpl dev = (USBDeviceImpl)deviceList.get(i);
            if (!deviceId.equals(dev.getUniqueId())) continue;
            return i;
        }
        return -1;
    }

    protected USBDevice findDevice(Object deviceId) {
        int index = this.findDeviceIndex(this.devices, deviceId);
        if (index < 0) {
            return null;
        }
        return this.devices.get(index);
    }
}

