/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.util.Collections;
import java.util.List;
import net.codecrete.usb.USBAlternateInterface;
import net.codecrete.usb.USBInterface;

public class USBInterfaceImpl
implements USBInterface {
    private final int interfaceNumber;
    private USBAlternateInterface currentAlternate;
    private final List<USBAlternateInterface> alternateInterfaces;
    private boolean claimed;

    public USBInterfaceImpl(int number, List<USBAlternateInterface> alternates) {
        this.interfaceNumber = number;
        this.alternateInterfaces = alternates;
        this.currentAlternate = alternates.get(0);
    }

    @Override
    public int number() {
        return this.interfaceNumber;
    }

    @Override
    public boolean isClaimed() {
        return this.claimed;
    }

    public void setClaimed(boolean claimed) {
        this.claimed = claimed;
    }

    @Override
    public USBAlternateInterface alternate() {
        return this.currentAlternate;
    }

    @Override
    public USBAlternateInterface getAlternate(int alternateNumber) {
        return this.alternateInterfaces.stream().filter(alt -> alt.number() == alternateNumber).findFirst().orElse(null);
    }

    @Override
    public List<USBAlternateInterface> alternates() {
        return Collections.unmodifiableList(this.alternateInterfaces);
    }

    void addAlternate(USBAlternateInterface alt) {
        this.alternateInterfaces.add(alt);
    }

    public void setAlternate(USBAlternateInterface alternate) {
        this.currentAlternate = alternate;
    }
}

