/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos.gen.iokit;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentAllocator;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

final class RuntimeHelper {
    private static final Linker LINKER = Linker.nativeLinker();
    private static final ClassLoader LOADER = RuntimeHelper.class.getClassLoader();
    private static final MethodHandles.Lookup MH_LOOKUP = MethodHandles.lookup();
    private static final SymbolLookup SYMBOL_LOOKUP;
    private static final SegmentAllocator THROWING_ALLOCATOR;
    static final AddressLayout POINTER;
    static final SegmentAllocator CONSTANT_ALLOCATOR;

    private RuntimeHelper() {
    }

    static <T> T requireNonNull(T obj, String symbolName) {
        if (obj == null) {
            throw new UnsatisfiedLinkError("unresolved symbol: " + symbolName);
        }
        return obj;
    }

    static MemorySegment lookupGlobalVariable(String name, MemoryLayout layout) {
        return SYMBOL_LOOKUP.find(name).map(s -> s.reinterpret(layout.byteSize())).orElse(null);
    }

    static MethodHandle downcallHandle(String name, FunctionDescriptor fdesc) {
        return SYMBOL_LOOKUP.find(name).map(addr -> LINKER.downcallHandle((MemorySegment)addr, fdesc, new Linker.Option[0])).orElse(null);
    }

    static MethodHandle downcallHandle(FunctionDescriptor fdesc) {
        return LINKER.downcallHandle(fdesc, new Linker.Option[0]);
    }

    static MethodHandle downcallHandleVariadic(String name, FunctionDescriptor fdesc) {
        return SYMBOL_LOOKUP.find(name).map(addr -> VarargsInvoker.make(addr, fdesc)).orElse(null);
    }

    static MethodHandle upcallHandle(Class<?> fi, String name, FunctionDescriptor fdesc) {
        try {
            return MH_LOOKUP.findVirtual(fi, name, fdesc.toMethodType());
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static <Z> MemorySegment upcallStub(MethodHandle fiHandle, Z z, FunctionDescriptor fdesc, Arena scope) {
        try {
            fiHandle = fiHandle.bindTo(z);
            return LINKER.upcallStub(fiHandle, fdesc, scope, new Linker.Option[0]);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static MemorySegment asArray(MemorySegment addr, MemoryLayout layout, int numElements, Arena arena) {
        return addr.reinterpret((long)numElements * layout.byteSize(), arena, null);
    }

    static {
        THROWING_ALLOCATOR = (x, y) -> {
            throw new AssertionError((Object)"should not reach here");
        };
        POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(ValueLayout.JAVA_BYTE));
        CONSTANT_ALLOCATOR = (size, align) -> Arena.ofAuto().allocate(size, align);
        SymbolLookup loaderLookup = SymbolLookup.libraryLookup("IOKit.framework/IOKit", Arena.global());
        SYMBOL_LOOKUP = name -> loaderLookup.find(name).or(() -> LINKER.defaultLookup().find(name));
    }

    private static final class VarargsInvoker {
        private static final MethodHandle INVOKE_MH;
        private final MemorySegment symbol;
        private final FunctionDescriptor function;

        private VarargsInvoker(MemorySegment symbol, FunctionDescriptor function) {
            this.symbol = symbol;
            this.function = function;
        }

        static MethodHandle make(MemorySegment symbol, FunctionDescriptor function) {
            boolean needsAllocator;
            VarargsInvoker invoker = new VarargsInvoker(symbol, function);
            MethodHandle handle = INVOKE_MH.bindTo(invoker).asCollector(Object[].class, function.argumentLayouts().size() + 1);
            MethodType mtype = MethodType.methodType(function.returnLayout().isPresent() ? VarargsInvoker.carrier(function.returnLayout().get(), true) : Void.TYPE);
            for (MemoryLayout layout : function.argumentLayouts()) {
                mtype = mtype.appendParameterTypes(VarargsInvoker.carrier(layout, false));
            }
            mtype = mtype.appendParameterTypes(Object[].class);
            boolean bl = needsAllocator = function.returnLayout().isPresent() && function.returnLayout().get() instanceof GroupLayout;
            if (needsAllocator) {
                mtype = mtype.insertParameterTypes(0, SegmentAllocator.class);
            } else {
                handle = MethodHandles.insertArguments(handle, 0, THROWING_ALLOCATOR);
            }
            return handle.asType(mtype);
        }

        static Class<?> carrier(MemoryLayout layout, boolean ret) {
            if (layout instanceof ValueLayout) {
                ValueLayout valueLayout = (ValueLayout)layout;
                return valueLayout.carrier();
            }
            if (layout instanceof GroupLayout) {
                return MemorySegment.class;
            }
            throw new AssertionError((Object)"Cannot get here!");
        }

        private Object invoke(SegmentAllocator allocator, Object[] args) throws Throwable {
            boolean needsAllocator;
            int nNamedArgs = this.function.argumentLayouts().size();
            assert (args.length == nNamedArgs + 1);
            Object[] unnamedArgs = (Object[])args[args.length - 1];
            int argsCount = nNamedArgs + unnamedArgs.length;
            Class[] argTypes = new Class[argsCount];
            MemoryLayout[] argLayouts = new MemoryLayout[nNamedArgs + unnamedArgs.length];
            int pos = 0;
            for (pos = 0; pos < nNamedArgs; ++pos) {
                argLayouts[pos] = this.function.argumentLayouts().get(pos);
            }
            assert (pos == nNamedArgs);
            for (Object o : unnamedArgs) {
                argLayouts[pos] = this.variadicLayout(this.normalize(o.getClass()));
                ++pos;
            }
            assert (pos == argsCount);
            FunctionDescriptor f = this.function.returnLayout().isEmpty() ? FunctionDescriptor.ofVoid(argLayouts) : FunctionDescriptor.of(this.function.returnLayout().get(), argLayouts);
            MethodHandle mh = LINKER.downcallHandle(this.symbol, f, new Linker.Option[0]);
            boolean bl = needsAllocator = this.function.returnLayout().isPresent() && this.function.returnLayout().get() instanceof GroupLayout;
            if (needsAllocator) {
                mh = mh.bindTo(allocator);
            }
            Object[] allArgs = new Object[nNamedArgs + unnamedArgs.length];
            System.arraycopy(args, 0, allArgs, 0, nNamedArgs);
            System.arraycopy(unnamedArgs, 0, allArgs, nNamedArgs, unnamedArgs.length);
            return mh.asSpreader(Object[].class, argsCount).invoke(allArgs);
        }

        private static Class<?> unboxIfNeeded(Class<?> clazz) {
            if (clazz == Boolean.class) {
                return Boolean.TYPE;
            }
            if (clazz == Void.class) {
                return Void.TYPE;
            }
            if (clazz == Byte.class) {
                return Byte.TYPE;
            }
            if (clazz == Character.class) {
                return Character.TYPE;
            }
            if (clazz == Short.class) {
                return Short.TYPE;
            }
            if (clazz == Integer.class) {
                return Integer.TYPE;
            }
            if (clazz == Long.class) {
                return Long.TYPE;
            }
            if (clazz == Float.class) {
                return Float.TYPE;
            }
            if (clazz == Double.class) {
                return Double.TYPE;
            }
            return clazz;
        }

        private Class<?> promote(Class<?> c) {
            if (c == Byte.TYPE || c == Character.TYPE || c == Short.TYPE || c == Integer.TYPE) {
                return Long.TYPE;
            }
            if (c == Float.TYPE) {
                return Double.TYPE;
            }
            return c;
        }

        private Class<?> normalize(Class<?> c) {
            if ((c = VarargsInvoker.unboxIfNeeded(c)).isPrimitive()) {
                return this.promote(c);
            }
            if (c == MemorySegment.class) {
                return MemorySegment.class;
            }
            throw new IllegalArgumentException("Invalid type for ABI: " + c.getTypeName());
        }

        private MemoryLayout variadicLayout(Class<?> c) {
            if (c == Long.TYPE) {
                return ValueLayout.JAVA_LONG;
            }
            if (c == Double.TYPE) {
                return ValueLayout.JAVA_DOUBLE;
            }
            if (c == MemorySegment.class) {
                return ValueLayout.ADDRESS;
            }
            throw new IllegalArgumentException("Unhandled variadic argument class: " + String.valueOf(c));
        }

        static {
            try {
                INVOKE_MH = MethodHandles.lookup().findVirtual(VarargsInvoker.class, "invoke", MethodType.methodType(Object.class, SegmentAllocator.class, Object[].class));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

