/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.codecrete.usb.USBDevice;
import net.codecrete.usb.USBException;
import net.codecrete.usb.common.ScopeCleanup;
import net.codecrete.usb.common.USBDeviceImpl;
import net.codecrete.usb.common.USBDeviceRegistry;
import net.codecrete.usb.usbstandard.ConfigurationDescriptor;
import net.codecrete.usb.usbstandard.DeviceDescriptor;
import net.codecrete.usb.usbstandard.SetupPacket;
import net.codecrete.usb.usbstandard.StringDescriptor;
import net.codecrete.usb.windows.DeviceInfoSet;
import net.codecrete.usb.windows.DevicePropertyKey;
import net.codecrete.usb.windows.USBConstants;
import net.codecrete.usb.windows.Win;
import net.codecrete.usb.windows.WindowsUSBDevice;
import net.codecrete.usb.windows.WindowsUSBException;
import net.codecrete.usb.windows.gen.kernel32.Kernel32;
import net.codecrete.usb.windows.gen.usbioctl.USBIoctl;
import net.codecrete.usb.windows.gen.usbioctl._USB_DESCRIPTOR_REQUEST;
import net.codecrete.usb.windows.gen.usbioctl._USB_NODE_CONNECTION_INFORMATION_EX;
import net.codecrete.usb.windows.gen.user32.User32;
import net.codecrete.usb.windows.gen.user32._DEV_BROADCAST_DEVICEINTERFACE_W;
import net.codecrete.usb.windows.gen.user32._DEV_BROADCAST_HDR;
import net.codecrete.usb.windows.gen.user32.tagMSG;
import net.codecrete.usb.windows.gen.user32.tagWNDCLASSEXW;
import net.codecrete.usb.windows.winsdk.Kernel32B;
import net.codecrete.usb.windows.winsdk.User32B;

public class WindowsUSBDeviceRegistry
extends USBDeviceRegistry {
    private static final System.Logger LOG = System.getLogger(WindowsUSBDeviceRegistry.class.getName());
    private static final long REQUEST_DATA_OFFSET = _USB_DESCRIPTOR_REQUEST.$LAYOUT().byteOffset(MemoryLayout.PathElement.groupElement("Data"));

    @Override
    protected void monitorDevices() {
        Arena arena = Arena.ofConfined();
        try {
            int err;
            MemorySegment hwnd;
            MemorySegment errorState = Win.allocateErrorState(arena);
            try {
                MemorySegment className = Win.createSegmentFromString("USB_MONITOR", arena);
                MemorySegment windowName = Win.createSegmentFromString("USB device monitor", arena);
                MemorySegment instance = Kernel32.GetModuleHandleW(MemorySegment.NULL);
                MethodHandle handleWindowMessageMH = MethodHandles.lookup().findVirtual(WindowsUSBDeviceRegistry.class, "handleWindowMessage", MethodType.methodType(Long.TYPE, MemorySegment.class, Integer.TYPE, Long.TYPE, Long.TYPE)).bindTo(this);
                MemorySegment handleWindowMessageStub = Linker.nativeLinker().upcallStub(handleWindowMessageMH, FunctionDescriptor.of(ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG), arena, new Linker.Option[0]);
                MemorySegment wx = tagWNDCLASSEXW.allocate(arena);
                tagWNDCLASSEXW.cbSize$set(wx, (int)wx.byteSize());
                tagWNDCLASSEXW.lpfnWndProc$set(wx, handleWindowMessageStub);
                tagWNDCLASSEXW.hInstance$set(wx, instance);
                tagWNDCLASSEXW.lpszClassName$set(wx, className);
                short atom = User32B.RegisterClassExW(wx, errorState);
                if (atom == 0) {
                    WindowsUSBException.throwLastError(errorState, "internal error (RegisterClassExW)", new Object[0]);
                }
                if ((hwnd = User32B.CreateWindowExW(0, className, windowName, 0, 0, 0, 0, 0, User32.HWND_MESSAGE(), MemorySegment.NULL, instance, MemorySegment.NULL, errorState)).address() == 0L) {
                    WindowsUSBException.throwLastError(errorState, "internal error (CreateWindowExW)", new Object[0]);
                }
                MemorySegment notificationFilter = _DEV_BROADCAST_DEVICEINTERFACE_W.allocate(arena);
                _DEV_BROADCAST_DEVICEINTERFACE_W.dbcc_size$set(notificationFilter, (int)notificationFilter.byteSize());
                _DEV_BROADCAST_DEVICEINTERFACE_W.dbcc_devicetype$set(notificationFilter, User32.DBT_DEVTYP_DEVICEINTERFACE());
                _DEV_BROADCAST_DEVICEINTERFACE_W.dbcc_classguid$slice(notificationFilter).copyFrom(USBConstants.GUID_DEVINTERFACE_USB_DEVICE);
                MemorySegment notifyHandle = User32B.RegisterDeviceNotificationW(hwnd, notificationFilter, User32.DEVICE_NOTIFY_WINDOW_HANDLE(), errorState);
                if (notifyHandle.address() == 0L) {
                    WindowsUSBException.throwLastError(errorState, "internal error (RegisterDeviceNotificationW)", new Object[0]);
                }
                this.enumeratePresentDevices();
            }
            catch (Exception e) {
                this.enumerationFailed(e);
                if (arena != null) {
                    arena.close();
                }
                return;
            }
            MemorySegment msg = tagMSG.allocate(arena);
            while ((err = User32B.GetMessageW(msg, hwnd, 0, 0, errorState)) > 0) {
            }
            if (err == -1) {
                WindowsUSBException.throwLastError(errorState, "internal error (GetMessageW)", new Object[0]);
            }
        }
        finally {
            if (arena != null) {
                try {
                    arena.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private void enumeratePresentDevices() {
        ArrayList<USBDevice> deviceList = new ArrayList<USBDevice>();
        try (ScopeCleanup cleanup = new ScopeCleanup();
             DeviceInfoSet deviceInfoSet = DeviceInfoSet.ofPresentDevices(USBConstants.GUID_DEVINTERFACE_USB_DEVICE, null);){
            HashMap<String, MemorySegment> hubHandles = new HashMap<String, MemorySegment>();
            cleanup.add(() -> hubHandles.forEach((path, handle) -> Kernel32.CloseHandle(handle)));
            while (deviceInfoSet.next()) {
                String instanceId = deviceInfoSet.getStringProperty(DevicePropertyKey.InstanceId);
                String devicePath = DeviceInfoSet.getDevicePath(instanceId, USBConstants.GUID_DEVINTERFACE_USB_DEVICE);
                try {
                    deviceList.add(this.createDeviceFromDeviceInfo(deviceInfoSet, devicePath, hubHandles));
                }
                catch (Exception e) {
                    LOG.log(System.Logger.Level.INFO, String.format("failed to retrieve information about device %s - ignoring device", devicePath), (Throwable)e);
                }
            }
            this.setInitialDeviceList(deviceList);
        }
    }

    private USBDevice createDeviceFromDeviceInfo(DeviceInfoSet deviceInfoSet, String devicePath, HashMap<String, MemorySegment> hubHandles) {
        try (Arena arena = Arena.ofConfined();){
            int usbPortNum = deviceInfoSet.getIntProperty(DevicePropertyKey.Address);
            String parentInstanceId = deviceInfoSet.getStringProperty(DevicePropertyKey.Parent);
            String hubPath = DeviceInfoSet.getDevicePath(parentInstanceId, USBConstants.GUID_DEVINTERFACE_USB_HUB);
            MemorySegment hubHandle = hubHandles.get(hubPath);
            if (hubHandle == null) {
                MemorySegment hubPathSeg = Win.createSegmentFromString(hubPath, arena);
                MemorySegment errorState = Win.allocateErrorState(arena);
                hubHandle = Kernel32B.CreateFileW(hubPathSeg, Kernel32.GENERIC_WRITE(), Kernel32.FILE_SHARE_WRITE(), MemorySegment.NULL, Kernel32.OPEN_EXISTING(), 0, MemorySegment.NULL, errorState);
                if (Win.isInvalidHandle(hubHandle)) {
                    WindowsUSBException.throwLastError(errorState, "internal error (opening hub device)", new Object[0]);
                }
                hubHandles.put(hubPath, hubHandle);
            }
            USBDevice uSBDevice = this.createDevice(devicePath, deviceInfoSet.isCompositeDevice(), hubHandle, usbPortNum);
            return uSBDevice;
        }
    }

    private USBDevice createDevice(String devicePath, boolean isComposite, MemorySegment hubHandle, int usbPortNum) {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment connInfo = _USB_NODE_CONNECTION_INFORMATION_EX.allocate(arena);
            _USB_NODE_CONNECTION_INFORMATION_EX.ConnectionIndex$set(connInfo, usbPortNum);
            MemorySegment sizeHolder = arena.allocate(ValueLayout.JAVA_INT);
            MemorySegment errorState = Win.allocateErrorState(arena);
            if (Kernel32B.DeviceIoControl(hubHandle, USBIoctl.IOCTL_USB_GET_NODE_CONNECTION_INFORMATION_EX(), connInfo, (int)connInfo.byteSize(), connInfo, (int)connInfo.byteSize(), sizeHolder, MemorySegment.NULL, errorState) == 0) {
                WindowsUSBException.throwLastError(errorState, "internal error (getting device descriptor failed)", new Object[0]);
            }
            MemorySegment descriptorSegment = _USB_NODE_CONNECTION_INFORMATION_EX.DeviceDescriptor$slice(connInfo);
            DeviceDescriptor deviceDescriptor = new DeviceDescriptor(descriptorSegment);
            int vendorId = deviceDescriptor.vendorID();
            int productId = deviceDescriptor.productID();
            MemorySegment configDesc = this.getDescriptor(hubHandle, usbPortNum, 2, 0, (short)0, arena);
            WindowsUSBDevice device = new WindowsUSBDevice(devicePath, vendorId, productId, configDesc, isComposite);
            device.setFromDeviceDescriptor(descriptorSegment);
            device.setProductString(descriptorSegment, index -> this.getStringDescriptor(hubHandle, usbPortNum, index));
            WindowsUSBDevice windowsUSBDevice = device;
            return windowsUSBDevice;
        }
    }

    private MemorySegment getDescriptor(MemorySegment hubHandle, int usbPortNumber, int descriptorType, int index, short languageID, Arena arena) {
        return this.getDescriptor(hubHandle, usbPortNumber, descriptorType, index, languageID, 0, arena);
    }

    private MemorySegment getDescriptor(MemorySegment hubHandle, int usbPortNumber, int descriptorType, int index, short languageID, int requestSize, Arena arena) {
        int expectedSize;
        int size = requestSize != 0 ? requestSize + (int)REQUEST_DATA_OFFSET : 256;
        MemorySegment descriptorRequest = arena.allocate(size);
        _USB_DESCRIPTOR_REQUEST.ConnectionIndex$set(descriptorRequest, usbPortNumber);
        SetupPacket setupPacket = new SetupPacket(_USB_DESCRIPTOR_REQUEST.SetupPacket$slice(descriptorRequest));
        setupPacket.setRequestType(128);
        setupPacket.setRequest(6);
        setupPacket.setValue(descriptorType << 8 | index);
        setupPacket.setIndex(languageID);
        setupPacket.setLength(size - (int)REQUEST_DATA_OFFSET);
        MemorySegment effectiveSizeHolder = arena.allocate(ValueLayout.JAVA_INT);
        MemorySegment errorState = Win.allocateErrorState(arena);
        if (Kernel32B.DeviceIoControl(hubHandle, USBIoctl.IOCTL_USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION(), descriptorRequest, size, descriptorRequest, size, effectiveSizeHolder, MemorySegment.NULL, errorState) == 0) {
            WindowsUSBException.throwLastError(errorState, "internal error (retrieving descriptor %d failed)", index);
        }
        if (descriptorType != 2) {
            expectedSize = 0xFF & descriptorRequest.get(ValueLayout.JAVA_BYTE, REQUEST_DATA_OFFSET);
        } else {
            ConfigurationDescriptor configDesc = new ConfigurationDescriptor(descriptorRequest.asSlice(REQUEST_DATA_OFFSET, ConfigurationDescriptor.LAYOUT.byteSize()));
            expectedSize = configDesc.totalLength();
        }
        long effectiveSize = (long)effectiveSizeHolder.get(ValueLayout.JAVA_INT, 0L) - REQUEST_DATA_OFFSET;
        if (effectiveSize != (long)expectedSize) {
            if (requestSize != 0) {
                WindowsUSBException.throwException("internal error (unexpected descriptor size)", new Object[0]);
            }
            return this.getDescriptor(hubHandle, usbPortNumber, descriptorType, index, languageID, expectedSize, arena);
        }
        return descriptorRequest.asSlice(REQUEST_DATA_OFFSET, effectiveSize);
    }

    private String getStringDescriptor(MemorySegment hubHandle, int usbPortNumber, int index) {
        if (index == 0) {
            return null;
        }
        Arena arena = Arena.ofConfined();
        try {
            StringDescriptor stringDesc = new StringDescriptor(this.getDescriptor(hubHandle, usbPortNumber, 3, index, (short)1033, arena));
            String string2 = stringDesc.string();
            if (arena != null) {
                arena.close();
            }
            return string2;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (USBException e) {
                return null;
            }
        }
    }

    private long handleWindowMessage(MemorySegment hWnd, int uMsg, long wParam, long lParam) {
        MemorySegment data;
        if (uMsg == User32.WM_DEVICECHANGE() && (wParam == (long)User32.DBT_DEVICEARRIVAL() || wParam == (long)User32.DBT_DEVICEREMOVECOMPLETE()) && _DEV_BROADCAST_HDR.dbch_devicetype$get(data = MemorySegment.ofAddress(lParam).reinterpret(_DEV_BROADCAST_DEVICEINTERFACE_W.sizeof())) == User32.DBT_DEVTYP_DEVICEINTERFACE()) {
            MemorySegment nameSlice = MemorySegment.ofAddress(_DEV_BROADCAST_DEVICEINTERFACE_W.dbcc_name$slice(data).address()).reinterpret(500L);
            String devicePath = Win.createStringFromSegment(nameSlice);
            if (wParam == (long)User32.DBT_DEVICEARRIVAL()) {
                this.onDeviceConnected(devicePath);
            } else {
                this.onDeviceDisconnected(devicePath);
            }
            return 0L;
        }
        return User32.DefWindowProcW(hWnd, uMsg, wParam, lParam);
    }

    private void onDeviceConnected(String devicePath) {
        try (ScopeCleanup cleanup = new ScopeCleanup();
             DeviceInfoSet deviceInfoSet = DeviceInfoSet.ofPath(devicePath);){
            HashMap<String, MemorySegment> hubHandles = new HashMap<String, MemorySegment>();
            cleanup.add(() -> hubHandles.forEach((path, handle) -> Kernel32.CloseHandle(handle)));
            try {
                USBDevice device = this.createDeviceFromDeviceInfo(deviceInfoSet, devicePath, hubHandles);
                this.addDevice(device);
            }
            catch (Exception e) {
                LOG.log(System.Logger.Level.INFO, String.format("failed to retrieve information about device %s - ignoring device", devicePath), (Throwable)e);
            }
        }
    }

    private void onDeviceDisconnected(String devicePath) {
        this.closeAndRemoveDevice(devicePath);
    }

    @Override
    protected int findDeviceIndex(List<USBDevice> deviceList, Object deviceId) {
        String id = deviceId.toString();
        for (int i = 0; i < deviceList.size(); ++i) {
            USBDeviceImpl dev = (USBDeviceImpl)deviceList.get(i);
            if (!id.equalsIgnoreCase(dev.getUniqueId().toString())) continue;
            return i;
        }
        return -1;
    }
}

