/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import net.codecrete.usb.USBException;
import net.codecrete.usb.USBStallException;
import net.codecrete.usb.common.ForeignMemory;
import net.codecrete.usb.windows.Win;
import net.codecrete.usb.windows.gen.kernel32.Kernel32;
import net.codecrete.usb.windows.gen.ntdll.NtDll;

public class WindowsUSBException
extends USBException {
    private static MemorySegment ntModule;

    public WindowsUSBException(String message, int errorCode) {
        super(String.format("%s: %s", message, WindowsUSBException.getErrorMessage(errorCode)), errorCode);
    }

    static void throwException(int errorCode, String message, Object ... args) {
        String formattedMessage = String.format(message, args);
        if (errorCode == Kernel32.ERROR_GEN_FAILURE() || errorCode == NtDll.STATUS_UNSUCCESSFUL()) {
            throw new USBStallException(formattedMessage);
        }
        throw new WindowsUSBException(formattedMessage, errorCode);
    }

    static void throwException(String message, Object ... args) {
        throw new USBException(String.format(message, args));
    }

    static void throwLastError(MemorySegment errorState, String message, Object ... args) {
        WindowsUSBException.throwException(Win.getLastError(errorState), message, args);
    }

    private static MemorySegment getNtModule() {
        if (ntModule == null) {
            try (Arena arena = Arena.ofConfined();){
                MemorySegment moduleName = Win.createSegmentFromString("NTDLL.DLL", arena);
                ntModule = Kernel32.GetModuleHandleW(moduleName);
            }
        }
        return ntModule;
    }

    static String getErrorMessage(int errorCode) {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment messagePointerHolder = arena.allocate(ValueLayout.ADDRESS);
            int res = Kernel32.FormatMessageW(Kernel32.FORMAT_MESSAGE_ALLOCATE_BUFFER() | Kernel32.FORMAT_MESSAGE_FROM_SYSTEM() | Kernel32.FORMAT_MESSAGE_IGNORE_INSERTS(), MemorySegment.NULL, errorCode, 0, messagePointerHolder, 0, MemorySegment.NULL);
            if (res == 0) {
                res = Kernel32.FormatMessageW(Kernel32.FORMAT_MESSAGE_ALLOCATE_BUFFER() | Kernel32.FORMAT_MESSAGE_FROM_HMODULE() | Kernel32.FORMAT_MESSAGE_IGNORE_INSERTS(), WindowsUSBException.getNtModule(), errorCode, 0, messagePointerHolder, 0, MemorySegment.NULL);
            }
            if (res == 0) {
                String string2 = "unspecified error";
                return string2;
            }
            MemorySegment messagePointer = ForeignMemory.dereference(messagePointerHolder).reinterpret(131072L);
            String message = Win.createStringFromSegment(messagePointer);
            Kernel32.LocalFree(messagePointer);
            String string3 = message.trim();
            return string3;
        }
    }
}

