/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows.gen.kernel32;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import net.codecrete.usb.windows.gen.kernel32.RuntimeHelper;
import net.codecrete.usb.windows.gen.kernel32.constants$1;
import net.codecrete.usb.windows.gen.kernel32.constants$2;

public class Kernel32 {
    public static final ValueLayout.OfByte C_CHAR = ValueLayout.JAVA_BYTE;
    public static final ValueLayout.OfShort C_SHORT = ValueLayout.JAVA_SHORT;
    public static final ValueLayout.OfInt C_INT = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfInt C_LONG = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfLong C_LONG_LONG = ValueLayout.JAVA_LONG;
    public static final ValueLayout.OfFloat C_FLOAT = ValueLayout.JAVA_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE = ValueLayout.JAVA_DOUBLE;
    public static final AddressLayout C_POINTER = RuntimeHelper.POINTER;

    public static int FILE_SHARE_READ() {
        return 1;
    }

    public static int FILE_SHARE_WRITE() {
        return 2;
    }

    public static int FILE_ATTRIBUTE_NORMAL() {
        return 128;
    }

    public static int OPEN_EXISTING() {
        return 3;
    }

    public static int FILE_FLAG_OVERLAPPED() {
        return 0x40000000;
    }

    public static int FORMAT_MESSAGE_ALLOCATE_BUFFER() {
        return 256;
    }

    public static int FORMAT_MESSAGE_IGNORE_INSERTS() {
        return 512;
    }

    public static int FORMAT_MESSAGE_FROM_HMODULE() {
        return 2048;
    }

    public static int FORMAT_MESSAGE_FROM_SYSTEM() {
        return 4096;
    }

    public static MethodHandle CloseHandle$MH() {
        return RuntimeHelper.requireNonNull(constants$1.const$6, "CloseHandle");
    }

    public static int CloseHandle(MemorySegment hObject) {
        MethodHandle mh$ = Kernel32.CloseHandle$MH();
        try {
            return mh$.invokeExact(hObject);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MethodHandle GetModuleHandleW$MH() {
        return RuntimeHelper.requireNonNull(constants$2.const$1, "GetModuleHandleW");
    }

    public static MemorySegment GetModuleHandleW(MemorySegment lpModuleName) {
        MethodHandle mh$ = Kernel32.GetModuleHandleW$MH();
        try {
            return mh$.invokeExact(lpModuleName);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MethodHandle LocalFree$MH() {
        return RuntimeHelper.requireNonNull(constants$2.const$2, "LocalFree");
    }

    public static MemorySegment LocalFree(MemorySegment hMem) {
        MethodHandle mh$ = Kernel32.LocalFree$MH();
        try {
            return mh$.invokeExact(hMem);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MethodHandle FormatMessageW$MH() {
        return RuntimeHelper.requireNonNull(constants$2.const$4, "FormatMessageW");
    }

    public static int FormatMessageW(int dwFlags, MemorySegment lpSource, int dwMessageId, int dwLanguageId, MemorySegment lpBuffer, int nSize, MemorySegment Arguments) {
        MethodHandle mh$ = Kernel32.FormatMessageW$MH();
        try {
            return mh$.invokeExact(dwFlags, lpSource, dwMessageId, dwLanguageId, lpBuffer, nSize, Arguments);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int GENERIC_READ() {
        return Integer.MIN_VALUE;
    }

    public static int GENERIC_WRITE() {
        return 0x40000000;
    }

    public static int INFINITE() {
        return -1;
    }

    public static int ERROR_FILE_NOT_FOUND() {
        return 2;
    }

    public static int ERROR_GEN_FAILURE() {
        return 31;
    }

    public static int ERROR_INSUFFICIENT_BUFFER() {
        return 122;
    }

    public static int ERROR_MORE_DATA() {
        return 234;
    }

    public static int ERROR_NO_MORE_ITEMS() {
        return 259;
    }

    public static int ERROR_IO_PENDING() {
        return 997;
    }

    public static int ERROR_NOT_FOUND() {
        return 1168;
    }
}

