/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.codecrete.usb.USBControlTransfer;
import net.codecrete.usb.USBDirection;
import net.codecrete.usb.USBEndpoint;
import net.codecrete.usb.USBInterface;
import net.codecrete.usb.Version;

public interface USBDevice {
    public int productId();

    public int vendorId();

    public String product();

    public String manufacturer();

    public String serialNumber();

    public int classCode();

    public int subclassCode();

    public int protocolCode();

    public Version usbVersion();

    public Version deviceVersion();

    public void detachStandardDrivers();

    public void attachStandardDrivers();

    public void open();

    public boolean isOpen();

    public void close();

    public List<USBInterface> interfaces();

    public USBInterface getInterface(int var1);

    public USBEndpoint getEndpoint(USBDirection var1, int var2);

    public void claimInterface(int var1);

    public void selectAlternateSetting(int var1, int var2);

    public void releaseInterface(int var1);

    public byte[] controlTransferIn(USBControlTransfer var1, int var2);

    public void controlTransferOut(USBControlTransfer var1, byte[] var2);

    public void transferOut(int var1, byte[] var2);

    public void transferOut(int var1, byte[] var2, int var3);

    public void transferOut(int var1, byte[] var2, int var3, int var4, int var5);

    public byte[] transferIn(int var1);

    public byte[] transferIn(int var1, int var2);

    public OutputStream openOutputStream(int var1, int var2);

    default public OutputStream openOutputStream(int endpointNumber) {
        return this.openOutputStream(endpointNumber, 1);
    }

    public InputStream openInputStream(int var1, int var2);

    default public InputStream openInputStream(int endpointNumber) {
        return this.openInputStream(endpointNumber, 1);
    }

    public void abortTransfers(USBDirection var1, int var2);

    public void clearHalt(USBDirection var1, int var2);

    public byte[] deviceDescriptor();

    public byte[] configurationDescriptor();
}

