/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import net.codecrete.usb.USBAlternateInterface;
import net.codecrete.usb.USBDirection;
import net.codecrete.usb.USBEndpoint;
import net.codecrete.usb.USBException;
import net.codecrete.usb.USBTransferType;
import net.codecrete.usb.common.CompositeFunction;
import net.codecrete.usb.common.Configuration;
import net.codecrete.usb.common.USBAlternateInterfaceImpl;
import net.codecrete.usb.common.USBEndpointImpl;
import net.codecrete.usb.common.USBInterfaceImpl;
import net.codecrete.usb.usbstandard.ConfigurationDescriptor;
import net.codecrete.usb.usbstandard.EndpointDescriptor;
import net.codecrete.usb.usbstandard.InterfaceAssociationDescriptor;
import net.codecrete.usb.usbstandard.InterfaceDescriptor;

public class ConfigurationParser {
    private final MemorySegment descriptor;
    private Configuration configuration;

    public static Configuration parseConfigurationDescriptor(MemorySegment desc) {
        ConfigurationParser parser = new ConfigurationParser(desc);
        return parser.parse();
    }

    public ConfigurationParser(MemorySegment descriptor) {
        this.descriptor = descriptor;
    }

    public Configuration parse() {
        this.parseHeader();
        USBAlternateInterfaceImpl lastAlternate = null;
        int offset = this.peekDescLength(0);
        while ((long)offset < this.descriptor.byteSize()) {
            int descLength = this.peekDescLength(offset);
            int descType = this.peekDescType(offset);
            if (descType == 4) {
                USBInterfaceImpl intf = this.parseInterface(offset);
                USBInterfaceImpl parent = this.configuration.findInterfaceByNumber(intf.number());
                if (parent != null) {
                    parent.addAlternate(intf.alternate());
                } else {
                    this.configuration.addInterface(intf);
                }
                lastAlternate = (USBAlternateInterfaceImpl)intf.alternate();
                CompositeFunction function = this.configuration.findFunction(intf.number());
                if (function == null) {
                    function = new CompositeFunction(intf.number(), 1, lastAlternate.classCode(), lastAlternate.subclassCode(), lastAlternate.protocolCode());
                    this.configuration.addFunction(function);
                }
            } else if (descType == 5) {
                USBEndpointImpl endpoint = this.parseEndpoint(offset);
                if (lastAlternate != null) {
                    lastAlternate.addEndpoint(endpoint);
                }
            } else if (descType == 11) {
                this.parseIAD(offset);
            }
            offset += descLength;
        }
        return this.configuration;
    }

    private void parseHeader() {
        ConfigurationDescriptor desc = new ConfigurationDescriptor(this.descriptor);
        if (2 != desc.descriptorType()) {
            throw new USBException("invalid USB configuration descriptor");
        }
        int totalLength = desc.totalLength();
        if (this.descriptor.byteSize() != (long)totalLength) {
            throw new USBException("invalid USB configuration descriptor (invalid length)");
        }
        this.configuration = new Configuration(desc.configurationValue(), desc.attributes(), desc.maxPower());
    }

    private USBInterfaceImpl parseInterface(int offset) {
        InterfaceDescriptor desc = new InterfaceDescriptor(this.descriptor, offset);
        USBAlternateInterfaceImpl alternate = new USBAlternateInterfaceImpl(desc.alternateSetting(), desc.interfaceClass(), desc.interfaceSubClass(), desc.interfaceProtocol(), new ArrayList<USBEndpoint>());
        ArrayList<USBAlternateInterface> alternates = new ArrayList<USBAlternateInterface>();
        alternates.add(alternate);
        return new USBInterfaceImpl(desc.interfaceNumber(), alternates);
    }

    private void parseIAD(int offset) {
        InterfaceAssociationDescriptor desc = new InterfaceAssociationDescriptor(this.descriptor, offset);
        CompositeFunction function = new CompositeFunction(desc.firstInterface(), desc.interfaceCount(), desc.functionClass(), desc.functionSubClass(), desc.functionProtocol());
        this.configuration.addFunction(function);
    }

    private USBEndpointImpl parseEndpoint(int offset) {
        EndpointDescriptor desc = new EndpointDescriptor(this.descriptor, offset);
        int address = desc.endpointAddress();
        return new USBEndpointImpl(ConfigurationParser.getEndpointNumber(address), ConfigurationParser.getEndpointDirection(address), ConfigurationParser.getEndpointType(desc.attributes()), desc.maxPacketSize());
    }

    private static USBDirection getEndpointDirection(int address) {
        return (address & 0x80) != 0 ? USBDirection.IN : USBDirection.OUT;
    }

    private static int getEndpointNumber(int address) {
        return address & 0x7F;
    }

    private static USBTransferType getEndpointType(int attributes) {
        return switch (attributes & 3) {
            case 1 -> USBTransferType.ISOCHRONOUS;
            case 2 -> USBTransferType.BULK;
            case 3 -> USBTransferType.INTERRUPT;
            default -> null;
        };
    }

    private int peekDescLength(int offset) {
        return 0xFF & this.descriptor.get(ValueLayout.JAVA_BYTE, (long)offset);
    }

    private int peekDescType(int offset) {
        return 0xFF & this.descriptor.get(ValueLayout.JAVA_BYTE, (long)offset + 1L);
    }
}

