/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.util.Collections;
import java.util.List;
import net.codecrete.usb.USBAlternateInterface;
import net.codecrete.usb.USBDirection;
import net.codecrete.usb.USBEndpoint;

public class USBAlternateInterfaceImpl
implements USBAlternateInterface {
    private final int alternateInterfaceNumber;
    private final int alternateInterfaceClass;
    private final int alternateInterfaceSubclass;
    private final int alternateInterfaceProtocol;
    private final List<USBEndpoint> endpointList;

    public USBAlternateInterfaceImpl(int number, int classCode, int subclassCode, int protocolCode, List<USBEndpoint> endpoints) {
        this.alternateInterfaceNumber = number;
        this.alternateInterfaceClass = classCode;
        this.alternateInterfaceSubclass = subclassCode;
        this.alternateInterfaceProtocol = protocolCode;
        this.endpointList = endpoints;
    }

    @Override
    public int number() {
        return this.alternateInterfaceNumber;
    }

    @Override
    public int classCode() {
        return this.alternateInterfaceClass;
    }

    @Override
    public int subclassCode() {
        return this.alternateInterfaceSubclass;
    }

    @Override
    public int protocolCode() {
        return this.alternateInterfaceProtocol;
    }

    @Override
    public List<USBEndpoint> endpoints() {
        return Collections.unmodifiableList(this.endpointList);
    }

    void addEndpoint(USBEndpoint endpoint) {
        this.endpointList.add(endpoint);
    }

    @Override
    public USBEndpoint getEndpoint(int endpointNumber, USBDirection direction) {
        return this.endpointList.stream().filter(ep -> ep.number() == endpointNumber && ep.direction() == direction).findFirst().orElse(null);
    }
}

