/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.linux;

import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import net.codecrete.usb.linux.Linux;

class IO {
    private static final Linker linker = Linker.nativeLinker();
    private static final FunctionDescriptor ioctl$FUNC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS);
    private static final MethodHandle ioctl$MH = linker.downcallHandle(linker.defaultLookup().find("ioctl").get(), ioctl$FUNC, Linux.ERRNO_STATE, Linker.Option.firstVariadicArg(2));
    private static final FunctionDescriptor open$FUNC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT);
    private static final MethodHandle open$MH = linker.downcallHandle(linker.defaultLookup().find("open").get(), open$FUNC, Linux.ERRNO_STATE);
    private static final FunctionDescriptor eventfd$FUNC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT);
    private static final MethodHandle eventfd$MH = linker.downcallHandle(linker.defaultLookup().find("eventfd").get(), eventfd$FUNC, Linux.ERRNO_STATE);
    private static final FunctionDescriptor eventfd_read$FUNC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS);
    private static final MethodHandle eventfd_read$MH = linker.downcallHandle(linker.defaultLookup().find("eventfd_read").get(), eventfd_read$FUNC, Linux.ERRNO_STATE);
    private static final FunctionDescriptor eventfd_write$FUNC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG);
    private static final MethodHandle eventfd_write$MH = linker.downcallHandle(linker.defaultLookup().find("eventfd_write").get(), eventfd_write$FUNC, Linux.ERRNO_STATE);

    private IO() {
    }

    static int ioctl(int fd, long request, MemorySegment segment, MemorySegment errno2) {
        try {
            return ioctl$MH.invokeExact(errno2, fd, request, segment);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static int open(MemorySegment file, int oflag, MemorySegment errno2) {
        try {
            return open$MH.invokeExact(errno2, file, oflag);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static int eventfd(int count, int flags, MemorySegment errno2) {
        try {
            return eventfd$MH.invokeExact(errno2, count, flags);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static int eventfd_read(int fd, MemorySegment value, MemorySegment errno2) {
        try {
            return eventfd_read$MH.invokeExact(errno2, fd, value);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static int eventfd_write(int fd, long value, MemorySegment errno2) {
        try {
            return eventfd_write$MH.invokeExact(errno2, fd, value);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

