/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.linux;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.codecrete.usb.USBTransferType;
import net.codecrete.usb.common.ForeignMemory;
import net.codecrete.usb.linux.IO;
import net.codecrete.usb.linux.Linux;
import net.codecrete.usb.linux.LinuxTransfer;
import net.codecrete.usb.linux.LinuxUSBDevice;
import net.codecrete.usb.linux.LinuxUSBException;
import net.codecrete.usb.linux.gen.errno.errno;
import net.codecrete.usb.linux.gen.poll.poll;
import net.codecrete.usb.linux.gen.poll.pollfd;
import net.codecrete.usb.linux.gen.usbdevice_fs.usbdevfs_urb;
import net.codecrete.usb.linux.gen.usbdevice_fs.usbdevice_fs;

class LinuxAsyncTask {
    static final LinuxAsyncTask INSTANCE = new LinuxAsyncTask();
    private final Arena urbArena = Arena.ofAuto();
    private final List<MemorySegment> availableURBs = new ArrayList<MemorySegment>();
    private final Map<MemorySegment, LinuxTransfer> transfersByURB = new LinkedHashMap<MemorySegment, LinuxTransfer>();
    private int[] asyncFds;
    private int asyncIOWakeUpEventFd;

    LinuxAsyncTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void asyncCompletionTask() {
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment errorState = Linux.allocateErrorState(arena);
            MemorySegment pollfdArray = pollfd.allocateArray(100L, arena);
            MemorySegment urbPointerHolder = arena.allocate(ValueLayout.ADDRESS);
            MemorySegment eventfdValueHolder = arena.allocate(ValueLayout.JAVA_LONG);
            while (true) {
                int[] fds;
                LinuxAsyncTask linuxAsyncTask = this;
                synchronized (linuxAsyncTask) {
                    fds = this.asyncFds;
                }
                this.fillPollfdArray(pollfdArray, fds);
                int n = fds.length;
                int res = poll.poll(pollfdArray, (long)n + 1L, -1);
                if (res < 0) {
                    LinuxUSBException.throwException("internal error (poll)", new Object[0]);
                }
                LinuxAsyncTask linuxAsyncTask2 = this;
                synchronized (linuxAsyncTask2) {
                    if ((pollfd.revents$get(pollfdArray, n) & poll.POLLIN()) != 0) {
                        res = IO.eventfd_read(this.asyncIOWakeUpEventFd, eventfdValueHolder, errorState);
                        if (res < 0) {
                            LinuxUSBException.throwLastError(errorState, "internal error (eventfd_read)", new Object[0]);
                        }
                        continue;
                    }
                    for (int i = 0; i < n + 1; ++i) {
                        int fd;
                        short revent = pollfd.revents$get(pollfdArray, i);
                        if (revent == 0) continue;
                        if ((revent & poll.POLLERR()) != 0) {
                            fd = pollfd.fd$get(pollfdArray, i);
                            this.removeFdFromAsyncIOCompletion(fd);
                            continue;
                        }
                        fd = pollfd.fd$get(pollfdArray, i);
                        this.reapURBs(fd, urbPointerHolder, errorState);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (arena == null) throw throwable;
            try {
                arena.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    void fillPollfdArray(MemorySegment asyncPolls, int[] fds) {
        int n = fds.length;
        for (int i = 0; i < n; ++i) {
            pollfd.fd$set(asyncPolls, i, fds[i]);
            pollfd.events$set(asyncPolls, i, (short)poll.POLLOUT());
            pollfd.revents$set(asyncPolls, i, (short)0);
        }
        pollfd.fd$set(asyncPolls, n, this.asyncIOWakeUpEventFd);
        pollfd.events$set(asyncPolls, n, (short)poll.POLLIN());
        pollfd.revents$set(asyncPolls, n, (short)0);
    }

    private void reapURBs(int fd, MemorySegment urbPointerHolder, MemorySegment errorState) {
        while (true) {
            int res;
            if ((res = IO.ioctl(fd, 1074287885L, urbPointerHolder, errorState)) < 0) {
                int err = Linux.getErrno(errorState);
                if (err == errno.EAGAIN()) {
                    return;
                }
                if (err == errno.ENODEV()) {
                    return;
                }
                LinuxUSBException.throwException(err, "internal error (reap URB)", new Object[0]);
            }
            MemorySegment urb = ForeignMemory.dereference(urbPointerHolder);
            LinuxTransfer transfer = this.getTransferResult(urb);
            transfer.completion().completed(transfer);
        }
    }

    private void notifyAsyncIOTask() {
        if (this.asyncIOWakeUpEventFd == 0) {
            this.startAsyncIOTask();
            return;
        }
        try (Arena arena = Arena.ofConfined();){
            MemorySegment errorState = Linux.allocateErrorState(arena);
            if (IO.eventfd_write(this.asyncIOWakeUpEventFd, 1L, errorState) < 0) {
                LinuxUSBException.throwLastError(errorState, "internal error (eventfd_write)", new Object[0]);
            }
        }
    }

    synchronized void addForAsyncIOCompletion(LinuxUSBDevice device) {
        int n = this.asyncFds != null ? this.asyncFds.length : 0;
        int[] fds = new int[n + 1];
        if (n > 0) {
            System.arraycopy(this.asyncFds, 0, fds, 0, n);
        }
        fds[n] = device.fileDescriptor();
        this.asyncFds = fds;
        this.notifyAsyncIOTask();
    }

    synchronized void removeFromAsyncIOCompletion(LinuxUSBDevice device) {
        this.removeFdFromAsyncIOCompletion(device.fileDescriptor());
        this.notifyAsyncIOTask();
    }

    private synchronized void removeFdFromAsyncIOCompletion(int fd) {
        int n = this.asyncFds.length;
        if (n == 0) {
            return;
        }
        int[] fds = new int[n - 1];
        int tgt = 0;
        for (int asyncFd : this.asyncFds) {
            if (asyncFd == fd) continue;
            if (tgt == n) {
                return;
            }
            fds[tgt] = asyncFd;
            ++tgt;
        }
        this.asyncFds = fds;
    }

    synchronized void submitTransfer(LinuxUSBDevice device, int endpointAddress, USBTransferType transferType, LinuxTransfer transfer) {
        this.addURB(transfer);
        MemorySegment urb = transfer.urb;
        usbdevfs_urb.type$set(urb, (byte)LinuxAsyncTask.urbTransferType(transferType));
        usbdevfs_urb.endpoint$set(urb, (byte)endpointAddress);
        usbdevfs_urb.buffer$set(urb, transfer.data());
        usbdevfs_urb.buffer_length$set(urb, transfer.dataSize());
        usbdevfs_urb.usercontext$set(urb, MemorySegment.ofAddress(device.fileDescriptor()));
        try (Arena arena = Arena.ofConfined();){
            MemorySegment errorState = Linux.allocateErrorState(arena);
            if (IO.ioctl(device.fileDescriptor(), 2151175434L, urb, errorState) < 0) {
                String action = endpointAddress >= 128 ? "reading from" : "writing to";
                String endpoint = endpointAddress == 0 ? "control endpoint" : String.format("endpoint %d", endpointAddress);
                LinuxUSBException.throwLastError(errorState, "error occurred while %s %s", action, endpoint);
            }
        }
    }

    private static int urbTransferType(USBTransferType transferType) {
        return switch (transferType) {
            default -> throw new MatchException(null, null);
            case USBTransferType.BULK -> usbdevice_fs.USBDEVFS_URB_TYPE_BULK();
            case USBTransferType.INTERRUPT -> usbdevice_fs.USBDEVFS_URB_TYPE_INTERRUPT();
            case USBTransferType.CONTROL -> usbdevice_fs.USBDEVFS_URB_TYPE_CONTROL();
            case USBTransferType.ISOCHRONOUS -> usbdevice_fs.USBDEVFS_URB_TYPE_ISO();
        };
    }

    private void addURB(LinuxTransfer transfer) {
        int size = this.availableURBs.size();
        MemorySegment urb = size > 0 ? this.availableURBs.remove(size - 1) : usbdevfs_urb.allocate(this.urbArena);
        transfer.urb = urb;
        this.transfersByURB.put(urb, transfer);
    }

    private synchronized LinuxTransfer getTransferResult(MemorySegment urb) {
        LinuxTransfer transfer = this.transfersByURB.remove(urb);
        if (transfer == null) {
            LinuxUSBException.throwException("internal error (unknown URB)", new Object[0]);
        }
        transfer.setResultCode(-usbdevfs_urb.status$get(transfer.urb));
        transfer.setResultSize(usbdevfs_urb.actual_length$get(transfer.urb));
        this.availableURBs.add(transfer.urb);
        transfer.urb = null;
        return transfer;
    }

    synchronized void abortTransfers(LinuxUSBDevice device, byte endpointAddress) {
        int fd = device.fileDescriptor();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment errorState = Linux.allocateErrorState(arena);
            for (MemorySegment urb : this.transfersByURB.keySet()) {
                if (fd != (int)usbdevfs_urb.usercontext$get(urb).address() || endpointAddress != usbdevfs_urb.endpoint$get(urb) || IO.ioctl(fd, 21771L, urb, errorState) >= 0 || Linux.getErrno(errorState) == errno.EINVAL()) continue;
                LinuxUSBException.throwLastError(errorState, "error occurred while aborting transfer", new Object[0]);
            }
        }
    }

    private void startAsyncIOTask() {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment errorState = Linux.allocateErrorState(arena);
            this.asyncIOWakeUpEventFd = IO.eventfd(0, 0, errorState);
            if (this.asyncIOWakeUpEventFd == -1) {
                this.asyncIOWakeUpEventFd = 0;
                LinuxUSBException.throwLastError(errorState, "internal error (eventfd)", new Object[0]);
            }
        }
        Thread thread = new Thread(this::asyncCompletionTask, "USB async IO");
        thread.setDaemon(true);
        thread.start();
    }
}

