/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.linux;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.ArrayList;
import java.util.List;
import net.codecrete.usb.USBDevice;
import net.codecrete.usb.common.ScopeCleanup;
import net.codecrete.usb.common.USBDeviceRegistry;
import net.codecrete.usb.linux.LinuxUSBDevice;
import net.codecrete.usb.linux.LinuxUSBException;
import net.codecrete.usb.linux.gen.poll.poll;
import net.codecrete.usb.linux.gen.poll.pollfd;
import net.codecrete.usb.linux.gen.udev.udev;

public class LinuxUSBDeviceRegistry
extends USBDeviceRegistry {
    private static final System.Logger LOG = System.getLogger(LinuxUSBDeviceRegistry.class.getName());
    private static final MemorySegment SUBSYSTEM_USB;
    private static final MemorySegment MONITOR_NAME;
    private static final MemorySegment DEVTYPE_USB_DEVICE;
    private static final MemorySegment ATTR_ID_VENDOR;
    private static final MemorySegment ATTR_ID_PRODUCT;
    private static final MemorySegment ATTR_MANUFACTURER;
    private static final MemorySegment ATTR_PRODUCT;
    private static final MemorySegment ATTR_SERIAL;

    @Override
    protected void monitorDevices() {
        int fd;
        MemorySegment monitor;
        try {
            MemorySegment udevInstance = udev.udev_new();
            if (udevInstance.address() == 0L) {
                LinuxUSBException.throwException("internal error (udev_new)", new Object[0]);
            }
            if ((monitor = udev.udev_monitor_new_from_netlink(udevInstance, MONITOR_NAME)).address() == 0L) {
                LinuxUSBException.throwException("internal error (udev_monitor_new_from_netlink)", new Object[0]);
            }
            if (udev.udev_monitor_filter_add_match_subsystem_devtype(monitor, SUBSYSTEM_USB, DEVTYPE_USB_DEVICE) < 0) {
                LinuxUSBException.throwException("internal error (udev_monitor_filter_add_match_subsystem_devtype)", new Object[0]);
            }
            if (udev.udev_monitor_enable_receiving(monitor) < 0) {
                LinuxUSBException.throwException("internal error (udev_monitor_enable_receiving)", new Object[0]);
            }
            if ((fd = udev.udev_monitor_get_fd(monitor)) < 0) {
                LinuxUSBException.throwException("internal error (udev_monitor_get_fd)", new Object[0]);
            }
            List<USBDevice> deviceList = this.enumeratePresentDevices(udevInstance);
            this.setInitialDeviceList(deviceList);
        }
        catch (Throwable e) {
            this.enumerationFailed(e);
            return;
        }
        while (true) {
            Arena arena = Arena.ofConfined();
            try {
                ScopeCleanup cleanup = new ScopeCleanup();
                try {
                    LinuxUSBDeviceRegistry.waitForFileDescriptor(fd, arena);
                    MemorySegment udevDevice = udev.udev_monitor_receive_device(monitor);
                    if (udevDevice == null) continue;
                    cleanup.add(() -> udev.udev_device_unref(udevDevice));
                    String action = LinuxUSBDeviceRegistry.getDeviceAction(udevDevice);
                    if ("add".equals(action)) {
                        this.onDeviceConnected(udevDevice);
                        continue;
                    }
                    if (!"remove".equals(action)) continue;
                    this.onDeviceDisconnected(udevDevice);
                    continue;
                }
                finally {
                    cleanup.close();
                    continue;
                }
            }
            finally {
                if (arena == null) continue;
                arena.close();
                continue;
            }
            break;
        }
    }

    private List<USBDevice> enumeratePresentDevices(MemorySegment udevInstance) {
        ArrayList<USBDevice> result = new ArrayList<USBDevice>();
        try (ScopeCleanup outerCleanup = new ScopeCleanup();){
            MemorySegment enumerate = udev.udev_enumerate_new(udevInstance);
            if (enumerate.address() == 0L) {
                LinuxUSBException.throwException("internal error (udev_enumerate_new)", new Object[0]);
            }
            outerCleanup.add(() -> udev.udev_enumerate_unref(enumerate));
            if (udev.udev_enumerate_add_match_subsystem(enumerate, SUBSYSTEM_USB) < 0) {
                LinuxUSBException.throwException("internal error (udev_enumerate_add_match_subsystem)", new Object[0]);
            }
            if (udev.udev_enumerate_scan_devices(enumerate) < 0) {
                LinuxUSBException.throwException("internal error (udev_enumerate_scan_devices)", new Object[0]);
            }
            MemorySegment entry = udev.udev_enumerate_get_list_entry(enumerate);
            while (entry.address() != 0L) {
                try (ScopeCleanup cleanup = new ScopeCleanup();){
                    MemorySegment dev;
                    MemorySegment path = udev.udev_list_entry_get_name(entry);
                    if (path.address() != 0L && (dev = udev.udev_device_new_from_syspath(udevInstance, path)).address() != 0L) {
                        cleanup.add(() -> udev.udev_device_unref(dev));
                        USBDevice device = this.getDeviceDetails(dev);
                        if (device != null) {
                            result.add(device);
                        }
                    }
                }
                entry = udev.udev_list_entry_get_next(entry);
            }
        }
        return result;
    }

    private void onDeviceConnected(MemorySegment udevDevice) {
        USBDevice device = this.getDeviceDetails(udevDevice);
        if (device != null) {
            this.addDevice(device);
        }
    }

    private void onDeviceDisconnected(MemorySegment udevDevice) {
        String devPath = LinuxUSBDeviceRegistry.getDeviceName(udevDevice);
        if (devPath == null) {
            return;
        }
        this.closeAndRemoveDevice(devPath);
    }

    private USBDevice getDeviceDetails(MemorySegment udevDevice) {
        int vendorId = 0;
        int productId = 0;
        try {
            String idVendor = LinuxUSBDeviceRegistry.getDeviceAttribute(udevDevice, ATTR_ID_VENDOR);
            if (idVendor == null) {
                return null;
            }
            String idProduct = LinuxUSBDeviceRegistry.getDeviceAttribute(udevDevice, ATTR_ID_PRODUCT);
            if (idProduct == null) {
                return null;
            }
            String devPath = LinuxUSBDeviceRegistry.getDeviceName(udevDevice);
            if (devPath == null) {
                return null;
            }
            vendorId = Integer.parseInt(idVendor, 16);
            productId = Integer.parseInt(idProduct, 16);
            LinuxUSBDevice device = new LinuxUSBDevice(devPath, vendorId, productId);
            device.setProductStrings(LinuxUSBDeviceRegistry.getDeviceAttribute(udevDevice, ATTR_MANUFACTURER), LinuxUSBDeviceRegistry.getDeviceAttribute(udevDevice, ATTR_PRODUCT), LinuxUSBDeviceRegistry.getDeviceAttribute(udevDevice, ATTR_SERIAL));
            return device;
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.INFO, String.format("failed to retrieve information about device 0x%04x/0x%04x - ignoring device", vendorId, productId), (Throwable)e);
            return null;
        }
    }

    private static String getDeviceAttribute(MemorySegment udevDevice, MemorySegment attribute) {
        MemorySegment value = udev.udev_device_get_sysattr_value(udevDevice, attribute);
        if (value.address() == 0L) {
            return null;
        }
        return value.getUtf8String(0L);
    }

    private static String getDeviceName(MemorySegment udevDevice) {
        return udev.udev_device_get_devnode(udevDevice).getUtf8String(0L);
    }

    private static String getDeviceAction(MemorySegment udevDevice) {
        return udev.udev_device_get_action(udevDevice).getUtf8String(0L);
    }

    private static void waitForFileDescriptor(int fd, Arena arena) {
        MemorySegment fds = pollfd.allocate(arena);
        pollfd.fd$set(fds, fd);
        pollfd.events$set(fds, (short)poll.POLLIN());
        int res = poll.poll(fds, 1L, -1);
        if (res < 0) {
            LinuxUSBException.throwException("internal error (poll)", new Object[0]);
        }
    }

    static {
        Arena global = Arena.global();
        SUBSYSTEM_USB = global.allocateUtf8String("usb");
        MONITOR_NAME = global.allocateUtf8String("udev");
        DEVTYPE_USB_DEVICE = global.allocateUtf8String("usb_device");
        ATTR_ID_VENDOR = global.allocateUtf8String("idVendor");
        ATTR_ID_PRODUCT = global.allocateUtf8String("idProduct");
        ATTR_MANUFACTURER = global.allocateUtf8String("manufacturer");
        ATTR_PRODUCT = global.allocateUtf8String("product");
        ATTR_SERIAL = global.allocateUtf8String("serial");
    }
}

