/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.linux;

import java.lang.foreign.MemorySegment;
import net.codecrete.usb.USBException;
import net.codecrete.usb.USBStallException;
import net.codecrete.usb.linux.Linux;
import net.codecrete.usb.linux.gen.errno.errno;

public class LinuxUSBException
extends USBException {
    public LinuxUSBException(String message, int errorCode) {
        super(String.format("%s: %s", message, Linux.getErrorMessage(errorCode)), errorCode);
    }

    static void throwException(int errorCode, String message, Object ... args) {
        String formattedMessage = String.format(message, args);
        if (errorCode == errno.EPIPE()) {
            throw new USBStallException(formattedMessage);
        }
        throw new LinuxUSBException(formattedMessage, errorCode);
    }

    static void throwException(String message, Object ... args) {
        throw new USBException(String.format(message, args));
    }

    static void throwLastError(MemorySegment errorState, String message, Object ... args) {
        LinuxUSBException.throwException(Linux.getErrno(errorState), message, args);
    }
}

