/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentAllocator;
import java.lang.foreign.ValueLayout;
import net.codecrete.usb.macos.gen.corefoundation.CFRange;
import net.codecrete.usb.macos.gen.corefoundation.CoreFoundation;

class CoreFoundationHelper {
    private CoreFoundationHelper() {
    }

    static String stringFromCFStringRef(MemorySegment string2, Arena arena) {
        long strLen = CoreFoundation.CFStringGetLength(string2);
        MemorySegment buffer = arena.allocateArray((MemoryLayout)ValueLayout.JAVA_CHAR, strLen);
        MemorySegment range = CFRange.allocate(arena);
        CFRange.location$set(range, 0L);
        CFRange.length$set(range, strLen);
        CoreFoundation.CFStringGetCharacters(string2, range, buffer);
        return new String(buffer.toArray(ValueLayout.JAVA_CHAR));
    }

    static MemorySegment createCFStringRef(String string2, SegmentAllocator allocator) {
        char[] charArray = string2.toCharArray();
        MemorySegment chars = allocator.allocateArray((MemoryLayout)ValueLayout.JAVA_CHAR, (long)charArray.length);
        chars.copyFrom(MemorySegment.ofArray(charArray));
        return CoreFoundation.CFStringCreateWithCharacters(MemorySegment.NULL, chars, string2.length());
    }
}

