/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.List;
import net.codecrete.usb.common.ScopeCleanup;
import net.codecrete.usb.windows.DevicePropertyKey;
import net.codecrete.usb.windows.Win;
import net.codecrete.usb.windows.WindowsUSBException;
import net.codecrete.usb.windows.gen.advapi32.Advapi32;
import net.codecrete.usb.windows.gen.kernel32.Kernel32;
import net.codecrete.usb.windows.gen.kernel32._GUID;
import net.codecrete.usb.windows.gen.ole32.Ole32;
import net.codecrete.usb.windows.gen.setupapi.SetupAPI;
import net.codecrete.usb.windows.gen.setupapi._SP_DEVICE_INTERFACE_DATA;
import net.codecrete.usb.windows.gen.setupapi._SP_DEVICE_INTERFACE_DETAIL_DATA_W;
import net.codecrete.usb.windows.gen.setupapi._SP_DEVINFO_DATA;
import net.codecrete.usb.windows.winsdk.SetupAPI2;

public class DeviceInfoSet
implements AutoCloseable {
    private final Arena arena = Arena.ofConfined();
    private final MemorySegment errorState;
    private final MemorySegment devInfoSet;
    private final MemorySegment devInfoData;
    private MemorySegment devIntfData;
    private int iterationIndex = -1;

    static DeviceInfoSet ofPresentDevices(MemorySegment interfaceGuid, String instanceId) {
        return new DeviceInfoSet((arena, errorState) -> {
            MemorySegment instanceIdSegment = instanceId != null ? Win.createSegmentFromString(instanceId, arena) : MemorySegment.NULL;
            return SetupAPI2.SetupDiGetClassDevsW(interfaceGuid, instanceIdSegment, MemorySegment.NULL, SetupAPI.DIGCF_PRESENT() | SetupAPI.DIGCF_DEVICEINTERFACE(), errorState);
        });
    }

    static DeviceInfoSet ofInstance(String instanceId) {
        DeviceInfoSet devInfoSet = DeviceInfoSet.ofEmpty();
        devInfoSet.addInstanceId(instanceId);
        return devInfoSet;
    }

    static DeviceInfoSet ofPath(String devicePath) {
        DeviceInfoSet devInfoSet = DeviceInfoSet.ofEmpty();
        devInfoSet.addDevicePath(devicePath);
        return devInfoSet;
    }

    private static DeviceInfoSet ofEmpty() {
        return new DeviceInfoSet((arena, errorState) -> SetupAPI2.SetupDiCreateDeviceInfoList(MemorySegment.NULL, MemorySegment.NULL, errorState));
    }

    private DeviceInfoSet(InfoSetCreator creator) {
        try {
            this.errorState = Win.allocateErrorState(this.arena);
            this.devInfoSet = creator.create(this.arena, this.errorState);
            if (Win.isInvalidHandle(this.devInfoSet)) {
                WindowsUSBException.throwLastError(this.errorState, "internal error (creating device info set)", new Object[0]);
            }
            this.devInfoData = _SP_DEVINFO_DATA.allocate(this.arena);
            _SP_DEVINFO_DATA.cbSize$set(this.devInfoData, (int)_SP_DEVINFO_DATA.$LAYOUT().byteSize());
        }
        catch (Exception e) {
            this.arena.close();
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.devIntfData != null) {
            SetupAPI.SetupDiDeleteDeviceInterfaceData(this.devInfoSet, this.devIntfData);
        }
        SetupAPI.SetupDiDestroyDeviceInfoList(this.devInfoSet);
        this.arena.close();
    }

    private void addInstanceId(String instanceId) {
        MemorySegment instanceIdSegment = Win.createSegmentFromString(instanceId, this.arena);
        if (SetupAPI2.SetupDiOpenDeviceInfoW(this.devInfoSet, instanceIdSegment, MemorySegment.NULL, 0, this.devInfoData, this.errorState) == 0) {
            WindowsUSBException.throwLastError(this.errorState, "internal error (SetupDiOpenDeviceInfoW)", new Object[0]);
        }
    }

    private void addDevicePath(String devicePath) {
        int err;
        if (this.devIntfData != null) {
            throw new AssertionError((Object)"calling addDevice() multiple times is not implemented");
        }
        MemorySegment intfData = _SP_DEVICE_INTERFACE_DATA.allocate(this.arena);
        _SP_DEVICE_INTERFACE_DATA.cbSize$set(intfData, (int)intfData.byteSize());
        MemorySegment devicePathSegment = Win.createSegmentFromString(devicePath, this.arena);
        if (SetupAPI2.SetupDiOpenDeviceInterfaceW(this.devInfoSet, devicePathSegment, 0, intfData, this.errorState) == 0) {
            WindowsUSBException.throwLastError(this.errorState, "internal error (SetupDiOpenDeviceInterfaceW)", new Object[0]);
        }
        this.devIntfData = intfData;
        if (SetupAPI2.SetupDiGetDeviceInterfaceDetailW(this.devInfoSet, intfData, MemorySegment.NULL, 0, MemorySegment.NULL, this.devInfoData, this.errorState) == 0 && (err = Win.getLastError(this.errorState)) != Kernel32.ERROR_INSUFFICIENT_BUFFER()) {
            WindowsUSBException.throwException(err, "internal error (SetupDiGetDeviceInterfaceDetailW)", new Object[0]);
        }
    }

    boolean next() {
        ++this.iterationIndex;
        if (SetupAPI2.SetupDiEnumDeviceInfo(this.devInfoSet, this.iterationIndex, this.devInfoData, this.errorState) == 0) {
            int err = Win.getLastError(this.errorState);
            if (err == Kernel32.ERROR_NO_MORE_ITEMS()) {
                return false;
            }
            WindowsUSBException.throwLastError(this.errorState, "internal error (SetupDiEnumDeviceInfo)", new Object[0]);
        }
        return true;
    }

    boolean isCompositeDevice() {
        String deviceService = this.getStringProperty(DevicePropertyKey.Service);
        return "usbccgp".equalsIgnoreCase(deviceService);
    }

    String getDevicePathByGUID(String instanceId) {
        List<String> guids = this.findDeviceInterfaceGUIDs(this.arena);
        for (String guid : guids) {
            MemorySegment clsid;
            MemorySegment guidSegment = Win.createSegmentFromString(guid, this.arena);
            if (Ole32.CLSIDFromString(guidSegment, clsid = _GUID.allocate(this.arena)) != 0) continue;
            try {
                return DeviceInfoSet.getDevicePath(instanceId, clsid);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private List<String> findDeviceInterfaceGUIDs(Arena arena) {
        try (ScopeCleanup cleanup = new ScopeCleanup();){
            int valueSize;
            MemorySegment value;
            MemorySegment regKey = SetupAPI2.SetupDiOpenDevRegKey(this.devInfoSet, this.devInfoData, SetupAPI.DICS_FLAG_GLOBAL(), 0, SetupAPI.DIREG_DEV(), Advapi32.KEY_READ(), this.errorState);
            if (Win.isInvalidHandle(regKey)) {
                WindowsUSBException.throwLastError(this.errorState, "internal error (SetupDiOpenDevRegKey)", new Object[0]);
            }
            cleanup.add(() -> Advapi32.RegCloseKey(regKey));
            MemorySegment keyNameSegment = Win.createSegmentFromString("DeviceInterfaceGUIDs", arena);
            MemorySegment valueTypeHolder = arena.allocate(ValueLayout.JAVA_INT);
            MemorySegment valueSizeHolder = arena.allocate(ValueLayout.JAVA_INT);
            int res = Advapi32.RegQueryValueExW(regKey, keyNameSegment, MemorySegment.NULL, valueTypeHolder, MemorySegment.NULL, valueSizeHolder);
            if (res == Kernel32.ERROR_FILE_NOT_FOUND()) {
                List<String> list = List.of();
                return list;
            }
            if (res != 0 && res != Kernel32.ERROR_MORE_DATA()) {
                WindowsUSBException.throwException(res, "internal error (RegQueryValueExW)", new Object[0]);
            }
            if ((res = Advapi32.RegQueryValueExW(regKey, keyNameSegment, MemorySegment.NULL, valueTypeHolder, value = arena.allocate(valueSize = valueSizeHolder.get(ValueLayout.JAVA_INT, 0L)), valueSizeHolder)) != 0) {
                WindowsUSBException.throwException(res, "internal error (RegQueryValueExW)", new Object[0]);
            }
            List<String> list = Win.createStringListFromSegment(value);
            return list;
        }
    }

    int getIntProperty(MemorySegment propertyKey) {
        MemorySegment propertyValueHolder;
        MemorySegment propertyTypeHolder = this.arena.allocate(ValueLayout.JAVA_INT);
        if (SetupAPI2.SetupDiGetDevicePropertyW(this.devInfoSet, this.devInfoData, propertyKey, propertyTypeHolder, propertyValueHolder = this.arena.allocate(ValueLayout.JAVA_INT), (int)propertyValueHolder.byteSize(), MemorySegment.NULL, 0, this.errorState) == 0) {
            WindowsUSBException.throwLastError(this.errorState, "internal error (SetupDiGetDevicePropertyW - A)", new Object[0]);
        }
        if (propertyTypeHolder.get(ValueLayout.JAVA_INT, 0L) != SetupAPI.DEVPROP_TYPE_UINT32()) {
            WindowsUSBException.throwException("internal error (expected property type UINT32)", new Object[0]);
        }
        return propertyValueHolder.get(ValueLayout.JAVA_INT, 0L);
    }

    String getStringProperty(MemorySegment propertyKey) {
        MemorySegment propertyValue = this.getVariableLengthProperty(propertyKey, SetupAPI.DEVPROP_TYPE_STRING(), this.arena);
        if (propertyValue == null) {
            return null;
        }
        return Win.createStringFromSegment(propertyValue);
    }

    List<String> getStringListProperty(MemorySegment propertyKey) {
        MemorySegment propertyValue = this.getVariableLengthProperty(propertyKey, SetupAPI.DEVPROP_TYPE_STRING() | SetupAPI.DEVPROP_TYPEMOD_LIST(), this.arena);
        if (propertyValue == null) {
            return null;
        }
        return Win.createStringListFromSegment(propertyValue);
    }

    private MemorySegment getVariableLengthProperty(MemorySegment propertyKey, int propertyType, Arena arena) {
        int stringLen;
        MemorySegment propertyValueHolder;
        MemorySegment requiredSizeHolder;
        MemorySegment propertyTypeHolder = arena.allocate(ValueLayout.JAVA_INT);
        if (SetupAPI2.SetupDiGetDevicePropertyW(this.devInfoSet, this.devInfoData, propertyKey, propertyTypeHolder, MemorySegment.NULL, 0, requiredSizeHolder = arena.allocate(ValueLayout.JAVA_INT), 0, this.errorState) == 0) {
            int err = Win.getLastError(this.errorState);
            if (err == Kernel32.ERROR_NOT_FOUND()) {
                return null;
            }
            if (err != Kernel32.ERROR_INSUFFICIENT_BUFFER()) {
                WindowsUSBException.throwException(err, "internal error (SetupDiGetDevicePropertyW - B)", new Object[0]);
            }
        }
        if (propertyTypeHolder.get(ValueLayout.JAVA_INT, 0L) != propertyType) {
            WindowsUSBException.throwException("internal error (unexpected property type)", new Object[0]);
        }
        if (SetupAPI2.SetupDiGetDevicePropertyW(this.devInfoSet, this.devInfoData, propertyKey, propertyTypeHolder, propertyValueHolder = arena.allocateArray((MemoryLayout)ValueLayout.JAVA_CHAR, (long)(stringLen = requiredSizeHolder.get(ValueLayout.JAVA_INT, 0L) / 2 - 1) + 1L), (int)propertyValueHolder.byteSize(), MemorySegment.NULL, 0, this.errorState) == 0) {
            WindowsUSBException.throwLastError(this.errorState, "internal error (SetupDiGetDevicePropertyW - C)", new Object[0]);
        }
        return propertyValueHolder;
    }

    static String getDevicePath(String instanceId, MemorySegment interfaceGuid) {
        try (Arena arena = Arena.ofConfined();){
            DeviceInfoSet deviceInfoSet = DeviceInfoSet.ofPresentDevices(interfaceGuid, instanceId);
            try {
                MemorySegment errorState = Win.allocateErrorState(arena);
                MemorySegment devIntfData = _SP_DEVICE_INTERFACE_DATA.allocate(arena);
                _SP_DEVICE_INTERFACE_DATA.cbSize$set(devIntfData, (int)devIntfData.byteSize());
                if (SetupAPI2.SetupDiEnumDeviceInterfaces(deviceInfoSet.devInfoSet, MemorySegment.NULL, interfaceGuid, 0, devIntfData, errorState) == 0) {
                    WindowsUSBException.throwLastError(errorState, "internal error (SetupDiEnumDeviceInterfaces)", new Object[0]);
                }
                int devicePathOffset = 4;
                MemorySegment intfDetailData = arena.allocate(524L);
                _SP_DEVICE_INTERFACE_DETAIL_DATA_W.cbSize$set(intfDetailData, (int)_SP_DEVICE_INTERFACE_DETAIL_DATA_W.sizeof());
                if (SetupAPI2.SetupDiGetDeviceInterfaceDetailW(deviceInfoSet.devInfoSet, devIntfData, intfDetailData, (int)intfDetailData.byteSize(), MemorySegment.NULL, MemorySegment.NULL, errorState) == 0) {
                    WindowsUSBException.throwLastError(errorState, "Internal error (SetupDiGetDeviceInterfaceDetailW)", new Object[0]);
                }
                String string2 = Win.createStringFromSegment(intfDetailData.asSlice(4L));
                if (deviceInfoSet != null) {
                    deviceInfoSet.close();
                }
                return string2;
            }
            catch (Throwable throwable) {
                if (deviceInfoSet != null) {
                    try {
                        deviceInfoSet.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    @FunctionalInterface
    static interface InfoSetCreator {
        public MemorySegment create(Arena var1, MemorySegment var2);
    }
}

