/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.codecrete.usb.windows.Win;
import net.codecrete.usb.windows.WindowsTransfer;
import net.codecrete.usb.windows.WindowsUSBException;
import net.codecrete.usb.windows.gen.kernel32.Kernel32;
import net.codecrete.usb.windows.gen.kernel32._OVERLAPPED;
import net.codecrete.usb.windows.winsdk.Kernel32B;

class WindowsAsyncTask {
    static final WindowsAsyncTask INSTANCE = new WindowsAsyncTask();
    private Map<Long, WindowsTransfer> requestsByOverlapped;
    private List<MemorySegment> availableOverlappedStructs;
    private Arena overlappedArena;
    private MemorySegment asyncIoCompletionPort = MemorySegment.NULL;

    WindowsAsyncTask() {
    }

    private void asyncCompletionTask() {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment overlappedHolder = arena.allocate(ValueLayout.ADDRESS, MemorySegment.NULL);
            MemorySegment numBytesHolder = arena.allocate(ValueLayout.JAVA_INT, 0);
            MemorySegment completionKeyHolder = arena.allocate(ValueLayout.JAVA_LONG, 0L);
            MemorySegment errorState = Win.allocateErrorState(arena);
            while (true) {
                overlappedHolder.set(ValueLayout.ADDRESS, 0L, MemorySegment.NULL);
                completionKeyHolder.set(ValueLayout.JAVA_LONG, 0L, 0L);
                int res = Kernel32B.GetQueuedCompletionStatus(this.asyncIoCompletionPort, numBytesHolder, completionKeyHolder, overlappedHolder, Kernel32.INFINITE(), errorState);
                long overlappedAddr = overlappedHolder.get(ValueLayout.JAVA_LONG, 0L);
                if (res == 0 && overlappedAddr == 0L) {
                    WindowsUSBException.throwLastError(errorState, "internal error (SetupDiGetDeviceInterfaceDetailW)", new Object[0]);
                }
                if (overlappedAddr == 0L) {
                    return;
                }
                this.completeTransfer(overlappedAddr);
            }
        }
    }

    synchronized void addDevice(MemorySegment handle) {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment errorState = Win.allocateErrorState(arena);
            MemorySegment portHandle = Kernel32B.CreateIoCompletionPort(handle, this.asyncIoCompletionPort, handle.address(), 0, errorState);
            if (portHandle == MemorySegment.NULL) {
                WindowsUSBException.throwLastError(errorState, "internal error (CreateIoCompletionPort)", new Object[0]);
            }
            if (this.asyncIoCompletionPort == MemorySegment.NULL) {
                this.asyncIoCompletionPort = portHandle;
                this.startAsyncIOTask();
            }
        }
    }

    private void startAsyncIOTask() {
        this.availableOverlappedStructs = new ArrayList<MemorySegment>();
        this.overlappedArena = Arena.ofAuto();
        this.requestsByOverlapped = new HashMap<Long, WindowsTransfer>();
        Thread thread = new Thread(this::asyncCompletionTask, "USB async IO");
        thread.setDaemon(true);
        thread.start();
    }

    synchronized void prepareForSubmission(WindowsTransfer transfer) {
        int size = this.availableOverlappedStructs.size();
        MemorySegment overlapped = size == 0 ? _OVERLAPPED.allocate(this.overlappedArena) : this.availableOverlappedStructs.remove(size - 1);
        transfer.setOverlapped(overlapped);
        transfer.setResultSize(-1);
        this.requestsByOverlapped.put(overlapped.address(), transfer);
    }

    private synchronized void completeTransfer(long overlappedAddr) {
        WindowsTransfer transfer = this.requestsByOverlapped.remove(overlappedAddr);
        if (transfer == null) {
            return;
        }
        transfer.setResultCode((int)_OVERLAPPED.Internal$get(transfer.overlapped()));
        transfer.setResultSize((int)_OVERLAPPED.InternalHigh$get(transfer.overlapped()));
        this.availableOverlappedStructs.add(transfer.overlapped());
        transfer.setOverlapped(null);
        transfer.completion().completed(transfer);
    }
}

