/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.codecrete.usb.UsbDevice;
import net.codecrete.usb.UsbDevicePredicate;
import net.codecrete.usb.common.UsbDeviceRegistry;
import net.codecrete.usb.linux.LinuxUsbDeviceRegistry;
import net.codecrete.usb.macos.MacosUsbDeviceRegistry;
import net.codecrete.usb.windows.WindowsUsbDeviceRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class Usb {
    private static UsbDeviceRegistry singletonInstance = null;

    private static UsbDeviceRegistry createInstance() {
        UsbDeviceRegistry impl;
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        if (osName.equals("Mac OS X") && (osArch.equals("x86_64") || osArch.equals("aarch64"))) {
            impl = new MacosUsbDeviceRegistry();
        } else if (osName.startsWith("Windows") && osArch.equals("amd64")) {
            impl = new WindowsUsbDeviceRegistry();
        } else if (osName.equals("Linux") && (osArch.equals("amd64") || osArch.equals("aarch64"))) {
            impl = new LinuxUsbDeviceRegistry();
        } else {
            throw new UnsupportedOperationException(String.format("Java Does USB has no implementation for architecture %s/%s", osName, osArch));
        }
        return impl;
    }

    private static synchronized UsbDeviceRegistry instance() {
        if (singletonInstance == null) {
            singletonInstance = Usb.createInstance();
            singletonInstance.start();
        }
        return singletonInstance;
    }

    private Usb() {
    }

    @NotNull
    public static @Unmodifiable Collection<UsbDevice> getDevices() {
        return Collections.unmodifiableCollection(Usb.instance().getAllDevices());
    }

    @NotNull
    public static @Unmodifiable List<UsbDevice> findDevices(@NotNull UsbDevicePredicate predicate) {
        return Usb.instance().getAllDevices().stream().filter(predicate::matches).toList();
    }

    public static Optional<UsbDevice> findDevice(@NotNull UsbDevicePredicate predicate) {
        return Usb.instance().getAllDevices().stream().filter(predicate::matches).findFirst();
    }

    public static Optional<UsbDevice> findDevice(int vendorId, int productId) {
        return Usb.findDevice(device -> device.getVendorId() == vendorId && device.getProductId() == productId);
    }

    public static void setOnDeviceConnected(@Nullable Consumer<UsbDevice> handler) {
        Usb.instance().setOnDeviceConnected(handler);
    }

    public static void setOnDeviceDisconnected(@Nullable Consumer<UsbDevice> handler) {
        Usb.instance().setOnDeviceDisconnected(handler);
    }
}

