/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.util.ArrayList;
import java.util.List;
import net.codecrete.usb.UsbInterface;
import net.codecrete.usb.common.CompositeFunction;
import net.codecrete.usb.common.UsbInterfaceImpl;

public class Configuration {
    private final List<CompositeFunction> functionList;
    private final List<UsbInterface> interfaceList;
    private final int configurationValue;
    private final int configurationAttributes;
    private final int configurationMaxPower;

    public Configuration(int configValue, int attributes, int maxPower) {
        this.configurationValue = configValue;
        this.configurationAttributes = attributes;
        this.configurationMaxPower = maxPower;
        this.functionList = new ArrayList<CompositeFunction>();
        this.interfaceList = new ArrayList<UsbInterface>();
    }

    public int configValue() {
        return this.configurationValue;
    }

    public int attributes() {
        return this.configurationAttributes;
    }

    public int maxPower() {
        return this.configurationMaxPower;
    }

    public List<UsbInterface> interfaces() {
        return this.interfaceList;
    }

    public List<CompositeFunction> functions() {
        return this.functionList;
    }

    public void addInterface(UsbInterface intf) {
        this.interfaceList.add(intf);
    }

    public UsbInterfaceImpl findInterfaceByNumber(int number) {
        return this.interfaceList.stream().filter(intf -> intf.getNumber() == number).findFirst().orElse(null);
    }

    public void addFunction(CompositeFunction function) {
        this.functionList.add(function);
    }

    public CompositeFunction findFunction(int interfaceNumber) {
        return this.functionList.stream().filter(f -> interfaceNumber >= f.firstInterfaceNumber() && interfaceNumber < f.firstInterfaceNumber() + f.numInterfaces()).findFirst().orElse(null);
    }
}

