/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.linux;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.codecrete.usb.UsbTransferType;
import net.codecrete.usb.common.ForeignMemory;
import net.codecrete.usb.linux.EPoll;
import net.codecrete.usb.linux.IO;
import net.codecrete.usb.linux.Linux;
import net.codecrete.usb.linux.LinuxTransfer;
import net.codecrete.usb.linux.LinuxUsbDevice;
import net.codecrete.usb.linux.LinuxUsbException;
import net.codecrete.usb.linux.gen.epoll.epoll;
import net.codecrete.usb.linux.gen.epoll.epoll_event;
import net.codecrete.usb.linux.gen.errno.errno;
import net.codecrete.usb.linux.gen.fcntl.fcntl;
import net.codecrete.usb.linux.gen.usbdevice_fs.usbdevfs_urb;
import net.codecrete.usb.linux.gen.usbdevice_fs.usbdevice_fs;

class LinuxAsyncTask {
    static final LinuxAsyncTask INSTANCE = new LinuxAsyncTask();
    private static final int NUM_EVENTS = 5;
    private final Arena urbArena = Arena.ofAuto();
    private final List<MemorySegment> availableURBs = new ArrayList<MemorySegment>();
    private final Map<MemorySegment, LinuxTransfer> transfersByURB = new LinkedHashMap<MemorySegment, LinuxTransfer>();
    private int epollFd = -1;

    LinuxAsyncTask() {
    }

    /*
     * Unable to fully structure code
     */
    private void asyncCompletionTask() {
        arena = Arena.ofConfined();
        try {
            errorState = Linux.allocateErrorState(arena);
            urbPointerHolder = arena.allocate(ValueLayout.ADDRESS);
            events = arena.allocateArray(epoll_event.$LAYOUT(), 5L);
            block4: while (true) {
                if ((res = EPoll.epoll_wait(this.epollFd, events, 5, -1, errorState)) < 0) {
                    err = Linux.getErrno(errorState);
                    if (err == errno.EINTR()) continue;
                    LinuxUsbException.throwException(err, "internal error (epoll_wait)", new Object[0]);
                }
                i = 0;
                while (true) {
                    if (i < res) ** break;
                    continue block4;
                    fd = EPoll.EVENT_ARRAY_DATA_FD$VH.get(events, i);
                    this.reapURBs(fd, urbPointerHolder, errorState);
                    ++i;
                }
                break;
            }
        }
        catch (Throwable var2_3) {
            if (arena != null) {
                try {
                    arena.close();
                }
                catch (Throwable var3_5) {
                    var2_3.addSuppressed(var3_5);
                }
            }
            throw var2_3;
        }
    }

    private synchronized void reapURBs(int fd, MemorySegment urbPointerHolder, MemorySegment errorState) {
        while (true) {
            int res;
            if ((res = IO.ioctl(fd, 1074287885L, urbPointerHolder, errorState)) < 0) {
                int err = Linux.getErrno(errorState);
                if (err == errno.EAGAIN()) {
                    return;
                }
                if (err == errno.ENODEV()) {
                    EPoll.removeFileDescriptor(this.epollFd, fd);
                    return;
                }
                LinuxUsbException.throwException(err, "internal error (reap URB)", new Object[0]);
            }
            MemorySegment urb = ForeignMemory.dereference(urbPointerHolder);
            LinuxTransfer transfer = this.getTransferWithResult(urb);
            transfer.completion().completed(transfer);
        }
    }

    synchronized void addForAsyncIOCompletion(LinuxUsbDevice device) {
        if (this.epollFd < 0) {
            this.startAsyncIOTask();
        }
        EPoll.addFileDescriptor(this.epollFd, epoll.EPOLLOUT() | epoll.EPOLLWAKEUP(), device.fileDescriptor());
    }

    synchronized void removeFromAsyncIOCompletion(LinuxUsbDevice device) {
        int fd = device.fileDescriptor();
        EPoll.removeFileDescriptor(this.epollFd, fd);
        try (Arena arena = Arena.ofConfined();){
            MemorySegment errorState = Linux.allocateErrorState(arena);
            MemorySegment urbPointerHolder = arena.allocate(ValueLayout.ADDRESS);
            this.reapURBs(fd, urbPointerHolder, errorState);
        }
        this.transfersByURB.entrySet().removeIf(e -> {
            boolean isMatch;
            MemorySegment urb = (MemorySegment)e.getKey();
            boolean bl = isMatch = usbdevfs_urb.usercontext$get(urb).address() == (long)fd;
            if (isMatch) {
                LinuxTransfer transfer = (LinuxTransfer)e.getValue();
                transfer.urb = null;
                transfer.setResultCode(errno.ENOENT());
                transfer.setResultSize(0);
                this.availableURBs.add(urb);
            }
            return isMatch;
        });
    }

    synchronized void submitTransfer(LinuxUsbDevice device, int endpointAddress, UsbTransferType transferType, LinuxTransfer transfer) {
        this.linkToUrb(transfer);
        MemorySegment urb = transfer.urb;
        usbdevfs_urb.type$set(urb, (byte)LinuxAsyncTask.urbTransferType(transferType));
        usbdevfs_urb.endpoint$set(urb, (byte)endpointAddress);
        usbdevfs_urb.buffer$set(urb, transfer.data());
        usbdevfs_urb.buffer_length$set(urb, transfer.dataSize());
        usbdevfs_urb.usercontext$set(urb, MemorySegment.ofAddress(device.fileDescriptor()));
        try (Arena arena = Arena.ofConfined();){
            MemorySegment errorState = Linux.allocateErrorState(arena);
            if (IO.ioctl(device.fileDescriptor(), 2151175434L, urb, errorState) < 0) {
                String action = endpointAddress >= 128 ? "reading from" : "writing to";
                String endpoint = endpointAddress == 0 ? "control endpoint" : String.format("endpoint %d", endpointAddress);
                LinuxUsbException.throwLastError(errorState, "error occurred while %s %s", action, endpoint);
            }
        }
    }

    private static int urbTransferType(UsbTransferType transferType) {
        return switch (transferType) {
            default -> throw new MatchException(null, null);
            case UsbTransferType.BULK -> usbdevice_fs.USBDEVFS_URB_TYPE_BULK();
            case UsbTransferType.INTERRUPT -> usbdevice_fs.USBDEVFS_URB_TYPE_INTERRUPT();
            case UsbTransferType.CONTROL -> usbdevice_fs.USBDEVFS_URB_TYPE_CONTROL();
            case UsbTransferType.ISOCHRONOUS -> usbdevice_fs.USBDEVFS_URB_TYPE_ISO();
        };
    }

    private void linkToUrb(LinuxTransfer transfer) {
        int size = this.availableURBs.size();
        MemorySegment urb = size > 0 ? this.availableURBs.remove(size - 1) : usbdevfs_urb.allocate(this.urbArena);
        transfer.urb = urb;
        this.transfersByURB.put(urb, transfer);
    }

    private synchronized LinuxTransfer getTransferWithResult(MemorySegment urb) {
        LinuxTransfer transfer = this.transfersByURB.remove(urb);
        if (transfer == null) {
            LinuxUsbException.throwException("internal error (unknown URB)", new Object[0]);
        }
        transfer.setResultCode(-usbdevfs_urb.status$get(transfer.urb));
        transfer.setResultSize(usbdevfs_urb.actual_length$get(transfer.urb));
        this.availableURBs.add(transfer.urb);
        transfer.urb = null;
        return transfer;
    }

    synchronized void abortTransfers(LinuxUsbDevice device, byte endpointAddress) {
        int fd = device.fileDescriptor();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment errorState = Linux.allocateErrorState(arena);
            this.transfersByURB.keySet().stream().filter(urb -> usbdevfs_urb.usercontext$get(urb).address() == (long)fd && usbdevfs_urb.endpoint$get(urb) == endpointAddress).forEach(urb -> {
                if (IO.ioctl(fd, 21771L, urb, errorState) < 0 && Linux.getErrno(errorState) != errno.EINVAL()) {
                    LinuxUsbException.throwLastError(errorState, "error occurred while aborting transfer", new Object[0]);
                }
            });
        }
    }

    private void startAsyncIOTask() {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment errorState = Linux.allocateErrorState(arena);
            this.epollFd = EPoll.epoll_create1(fcntl.FD_CLOEXEC(), errorState);
            if (this.epollFd < 0) {
                LinuxUsbException.throwLastError(errorState, "internal error (epoll_create)", new Object[0]);
            }
        }
        Thread thread = new Thread(this::asyncCompletionTask, "USB async IO");
        thread.setDaemon(true);
        thread.start();
    }
}

