/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.codecrete.usb.UsbAlternateInterface;
import net.codecrete.usb.UsbControlTransfer;
import net.codecrete.usb.UsbDirection;
import net.codecrete.usb.UsbException;
import net.codecrete.usb.UsbInterface;
import net.codecrete.usb.UsbRecipient;
import net.codecrete.usb.UsbTransferType;
import net.codecrete.usb.common.CompositeFunction;
import net.codecrete.usb.common.Configuration;
import net.codecrete.usb.common.ForeignMemory;
import net.codecrete.usb.common.Transfer;
import net.codecrete.usb.common.UsbDeviceImpl;
import net.codecrete.usb.common.UsbInterfaceImpl;
import net.codecrete.usb.usbstandard.SetupPacket;
import net.codecrete.usb.windows.DeviceInfoSet;
import net.codecrete.usb.windows.DevicePropertyKey;
import net.codecrete.usb.windows.InterfaceHandle;
import net.codecrete.usb.windows.Win;
import net.codecrete.usb.windows.WindowsAsyncTask;
import net.codecrete.usb.windows.WindowsEndpointInputStream;
import net.codecrete.usb.windows.WindowsEndpointOutputStream;
import net.codecrete.usb.windows.WindowsTransfer;
import net.codecrete.usb.windows.WindowsUsbException;
import net.codecrete.usb.windows.gen.kernel32.Kernel32;
import net.codecrete.usb.windows.gen.winusb.WinUSB;
import net.codecrete.usb.windows.winsdk.Kernel32B;
import net.codecrete.usb.windows.winsdk.WinUSB2;
import org.jetbrains.annotations.NotNull;

public class WindowsUsbDevice
extends UsbDeviceImpl {
    private static final System.Logger LOG = System.getLogger(WindowsUsbDevice.class.getName());
    private final WindowsAsyncTask asyncTask = WindowsAsyncTask.INSTANCE;
    private final boolean isComposite;
    private List<InterfaceHandle> interfaceHandles;
    private Map<Integer, String> devicePaths;
    private boolean showAsOpen;
    private static final Pattern MULTIPLE_INTERFACE_ID = Pattern.compile("USB\\\\VID_[0-9A-Fa-f]{4}&PID_[0-9A-Fa-f]{4}&MI_([0-9A-Fa-f]{2})");

    WindowsUsbDevice(String devicePath, int vendorId, int productId, MemorySegment configDesc, boolean isComposite) {
        super(devicePath, vendorId, productId);
        this.isComposite = isComposite;
        if (isComposite) {
            this.devicePaths = new HashMap<Integer, String>();
        }
        this.readDescription(configDesc);
    }

    private void readDescription(MemorySegment configDesc) {
        Configuration configuration = this.setConfigurationDescriptor(configDesc);
        this.interfaceHandles = configuration.interfaces().stream().map(intf -> {
            int interfaceNumber = intf.getNumber();
            CompositeFunction function = configuration.findFunction(interfaceNumber);
            return new InterfaceHandle(interfaceNumber, function.firstInterfaceNumber());
        }).toList();
    }

    @Override
    public boolean isOpened() {
        return this.showAsOpen;
    }

    @Override
    public synchronized void open() {
        if (this.isOpened()) {
            WindowsUsbException.throwException("device is already open", new Object[0]);
        }
        this.showAsOpen = true;
    }

    @Override
    public synchronized void close() {
        if (!this.isOpened()) {
            return;
        }
        for (UsbInterface intf : this.interfaceList) {
            if (!intf.isClaimed()) continue;
            this.releaseInterface(intf.getNumber());
        }
        this.showAsOpen = false;
    }

    @Override
    public void claimInterface(int interfaceNumber) {
        int numRetries = 30;
        while (!this.claimInteraceSynchronized(interfaceNumber)) {
            if (--numRetries == 0) {
                throw new UsbException("claiming interface failed (function has no device path / interface GUID, might be missing WinUSB driver)");
            }
            try {
                LOG.log(System.Logger.Level.DEBUG, "Sleeping for 100ms...");
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        return;
    }

    private synchronized boolean claimInteraceSynchronized(int interfaceNumber) {
        InterfaceHandle intfHandle;
        this.checkIsOpen();
        this.getInterfaceWithCheck(interfaceNumber, false);
        InterfaceHandle firstIntfHandle = intfHandle = this.getInterfaceHandle(interfaceNumber);
        if (intfHandle.firstInterfaceNumber != interfaceNumber) {
            firstIntfHandle = this.getInterfaceHandle(intfHandle.firstInterfaceNumber);
        }
        try (Arena arena = Arena.ofConfined();){
            MemorySegment errorState = Win.allocateErrorState(arena);
            if (firstIntfHandle.deviceHandle == null) {
                String devicePath = this.getInterfaceDevicePath(firstIntfHandle.interfaceNumber);
                if (devicePath == null) {
                    boolean bl = false;
                    return bl;
                }
                LOG.log(System.Logger.Level.DEBUG, "opening device {0}", devicePath);
                MemorySegment pathSegment = Win.createSegmentFromString(devicePath, arena);
                MemorySegment deviceHandle = Kernel32B.CreateFileW(pathSegment, Kernel32.GENERIC_WRITE() | Kernel32.GENERIC_READ(), Kernel32.FILE_SHARE_WRITE() | Kernel32.FILE_SHARE_READ(), MemorySegment.NULL, Kernel32.OPEN_EXISTING(), Kernel32.FILE_ATTRIBUTE_NORMAL() | Kernel32.FILE_FLAG_OVERLAPPED(), MemorySegment.NULL, errorState);
                if (Win.isInvalidHandle(deviceHandle)) {
                    WindowsUsbException.throwLastError(errorState, "claiming interface failed (opening USB device %s failed)", devicePath);
                }
                try {
                    MemorySegment interfaceHandleHolder = arena.allocate(ValueLayout.ADDRESS);
                    if (WinUSB2.WinUsb_Initialize(deviceHandle, interfaceHandleHolder, errorState) == 0) {
                        WindowsUsbException.throwLastError(errorState, "claiming interface failed", new Object[0]);
                    }
                    MemorySegment interfaceHandle = ForeignMemory.dereference(interfaceHandleHolder);
                    firstIntfHandle.deviceHandle = deviceHandle;
                    firstIntfHandle.winusbHandle = interfaceHandle;
                    this.asyncTask.addDevice(deviceHandle);
                }
                catch (Exception e) {
                    Kernel32.CloseHandle(deviceHandle);
                    throw e;
                }
            }
            if (intfHandle != firstIntfHandle) {
                MemorySegment interfaceHandleHolder = arena.allocate(ValueLayout.ADDRESS);
                if (WinUSB2.WinUsb_GetAssociatedInterface(firstIntfHandle.winusbHandle, (byte)(intfHandle.interfaceNumber - firstIntfHandle.interfaceNumber - 1), interfaceHandleHolder, errorState) == 0) {
                    WindowsUsbException.throwLastError(errorState, "claiming (associated) interface failed", new Object[0]);
                }
                intfHandle.winusbHandle = ForeignMemory.dereference(interfaceHandleHolder);
            }
        }
        ++firstIntfHandle.deviceOpenCount;
        this.setClaimed(interfaceNumber, true);
        return true;
    }

    @Override
    public synchronized void selectAlternateSetting(int interfaceNumber, int alternateNumber) {
        this.checkIsOpen();
        UsbInterfaceImpl intf = this.getInterfaceWithCheck(interfaceNumber, true);
        InterfaceHandle intfHandle = this.getInterfaceHandle(interfaceNumber);
        UsbAlternateInterface altSetting = intf.getAlternate(alternateNumber);
        try (Arena arena = Arena.ofConfined();){
            MemorySegment errorState = Win.allocateErrorState(arena);
            if (WinUSB2.WinUsb_SetCurrentAlternateSetting(intfHandle.winusbHandle, (byte)alternateNumber, errorState) == 0) {
                WindowsUsbException.throwLastError(errorState, "setting alternate interface failed", new Object[0]);
            }
        }
        intf.setAlternate(altSetting);
    }

    @Override
    public synchronized void releaseInterface(int interfaceNumber) {
        InterfaceHandle intfHandle;
        this.checkIsOpen();
        this.getInterfaceWithCheck(interfaceNumber, true);
        InterfaceHandle firstIntfHandle = intfHandle = this.getInterfaceHandle(interfaceNumber);
        if (intfHandle.firstInterfaceNumber != interfaceNumber) {
            firstIntfHandle = this.getInterfaceHandle(intfHandle.firstInterfaceNumber);
        }
        this.setClaimed(interfaceNumber, false);
        if (intfHandle != firstIntfHandle) {
            WinUSB.WinUsb_Free(intfHandle.winusbHandle);
            intfHandle.winusbHandle = null;
        }
        --firstIntfHandle.deviceOpenCount;
        if (firstIntfHandle.deviceOpenCount == 0) {
            WinUSB.WinUsb_Free(firstIntfHandle.winusbHandle);
            firstIntfHandle.winusbHandle = null;
            LOG.log(System.Logger.Level.DEBUG, "closing device {0}", this.getCachedInterfaceDevicePath(interfaceNumber));
            Kernel32.CloseHandle(firstIntfHandle.deviceHandle);
            firstIntfHandle.deviceHandle = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void controlTransferOut(@NotNull UsbControlTransfer setup, byte[] data) {
        try (Arena arena = Arena.ofConfined();){
            WindowsTransfer transfer = this.createSyncControlTransfer();
            int dataLength = data != null ? data.length : 0;
            transfer.setDataSize(dataLength);
            if (dataLength != 0) {
                MemorySegment buffer = arena.allocate(data.length);
                buffer.copyFrom(MemorySegment.ofArray(data));
                transfer.setData(buffer);
            } else {
                transfer.setData(MemorySegment.NULL);
            }
            WindowsTransfer windowsTransfer = transfer;
            synchronized (windowsTransfer) {
                this.submitControlTransfer(UsbDirection.OUT, setup, transfer);
                this.waitForTransfer(transfer, 0, UsbDirection.OUT, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte @NotNull [] controlTransferIn(@NotNull UsbControlTransfer setup, int length) {
        try (Arena arena = Arena.ofConfined();){
            WindowsTransfer transfer = this.createSyncControlTransfer();
            transfer.setData(arena.allocate(length));
            transfer.setDataSize(length);
            Object object = transfer;
            synchronized (object) {
                this.submitControlTransfer(UsbDirection.IN, setup, transfer);
                this.waitForTransfer(transfer, 0, UsbDirection.IN, 0);
            }
            object = transfer.data().asSlice(0L, transfer.resultSize()).toArray(ValueLayout.JAVA_BYTE);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferOut(int endpointNumber, byte @NotNull [] data, int offset, int length, int timeout) {
        try (Arena arena = Arena.ofConfined();){
            WindowsTransfer transfer;
            MemorySegment buffer = arena.allocate(data.length);
            buffer.copyFrom(MemorySegment.ofArray(data).asSlice((long)offset, length));
            WindowsTransfer windowsTransfer = transfer = this.createSyncTransfer(buffer);
            synchronized (windowsTransfer) {
                this.submitTransferOut(endpointNumber, transfer);
                this.waitForTransfer(transfer, timeout, UsbDirection.OUT, endpointNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte @NotNull [] transferIn(int endpointNumber, int timeout) {
        UsbDeviceImpl.EndpointInfo endpoint = this.getEndpoint(UsbDirection.IN, endpointNumber, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
        try (Arena arena = Arena.ofConfined();){
            MemorySegment buffer = arena.allocate(endpoint.packetSize());
            WindowsTransfer transfer = this.createSyncTransfer(buffer);
            Object object = transfer;
            synchronized (object) {
                this.submitTransferIn(endpointNumber, transfer);
                this.waitForTransfer(transfer, timeout, UsbDirection.IN, endpointNumber);
            }
            object = buffer.asSlice(0L, transfer.resultSize()).toArray(ValueLayout.JAVA_BYTE);
            return object;
        }
    }

    private WindowsTransfer createSyncControlTransfer() {
        WindowsTransfer transfer = new WindowsTransfer();
        transfer.setCompletion(x$0 -> UsbDeviceImpl.onSyncTransferCompleted(x$0));
        return transfer;
    }

    private WindowsTransfer createSyncTransfer(MemorySegment data) {
        WindowsTransfer transfer = new WindowsTransfer();
        transfer.setData(data);
        transfer.setDataSize((int)data.byteSize());
        transfer.setCompletion(x$0 -> UsbDeviceImpl.onSyncTransferCompleted(x$0));
        return transfer;
    }

    @Override
    protected Transfer createTransfer() {
        return new WindowsTransfer();
    }

    @Override
    protected void throwOSException(int errorCode, String message, Object ... args) {
        WindowsUsbException.throwException(errorCode, message, args);
    }

    synchronized void submitControlTransfer(UsbDirection direction, UsbControlTransfer setup, WindowsTransfer transfer) {
        this.checkIsOpen();
        InterfaceHandle intfHandle = this.findControlTransferInterface(setup);
        try (Arena arena = Arena.ofConfined();){
            int err;
            SetupPacket setupPacket = new SetupPacket(arena);
            int bmRequest = (direction == UsbDirection.IN ? 128 : 0) | setup.requestType().ordinal() << 5 | setup.recipient().ordinal();
            setupPacket.setRequestType(bmRequest);
            setupPacket.setRequest(setup.request());
            setupPacket.setValue(setup.value());
            setupPacket.setIndex(setup.index());
            setupPacket.setLength(transfer.dataSize());
            MemorySegment errorState = Win.allocateErrorState(arena);
            this.asyncTask.prepareForSubmission(transfer);
            if (WinUSB2.WinUsb_ControlTransfer(intfHandle.winusbHandle, setupPacket.segment(), transfer.data(), transfer.dataSize(), MemorySegment.NULL, transfer.overlapped(), errorState) == 0 && (err = Win.getLastError(errorState)) != Kernel32.ERROR_IO_PENDING()) {
                WindowsUsbException.throwException(err, "submitting control transfer failed", new Object[0]);
            }
        }
    }

    synchronized void submitTransferOut(int endpointNumber, WindowsTransfer transfer) {
        UsbDeviceImpl.EndpointInfo endpoint = this.getEndpoint(UsbDirection.OUT, endpointNumber, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
        InterfaceHandle intfHandle = this.getInterfaceHandle(endpoint.interfaceNumber());
        try (Arena arena = Arena.ofConfined();){
            int err;
            MemorySegment errorState = Win.allocateErrorState(arena);
            this.asyncTask.prepareForSubmission(transfer);
            if (WinUSB2.WinUsb_WritePipe(intfHandle.winusbHandle, endpoint.endpointAddress(), transfer.data(), transfer.dataSize(), MemorySegment.NULL, transfer.overlapped(), errorState) == 0 && (err = Win.getLastError(errorState)) != Kernel32.ERROR_IO_PENDING()) {
                WindowsUsbException.throwException(err, "submitting transfer OUT failed", new Object[0]);
            }
        }
    }

    synchronized void submitTransferIn(int endpointNumber, WindowsTransfer transfer) {
        UsbDeviceImpl.EndpointInfo endpoint = this.getEndpoint(UsbDirection.IN, endpointNumber, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
        InterfaceHandle intfHandle = this.getInterfaceHandle(endpoint.interfaceNumber());
        try (Arena arena = Arena.ofConfined();){
            int err;
            MemorySegment errorState = Win.allocateErrorState(arena);
            this.asyncTask.prepareForSubmission(transfer);
            if (WinUSB2.WinUsb_ReadPipe(intfHandle.winusbHandle, endpoint.endpointAddress(), transfer.data(), transfer.dataSize(), MemorySegment.NULL, transfer.overlapped(), errorState) == 0 && (err = Win.getLastError(errorState)) != Kernel32.ERROR_IO_PENDING()) {
                WindowsUsbException.throwException(err, "submitting transfer IN failed", new Object[0]);
            }
        }
    }

    synchronized void configureForAsyncIo(UsbDirection direction, int endpointNumber) {
        UsbDeviceImpl.EndpointInfo endpoint = this.getEndpoint(direction, endpointNumber, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
        InterfaceHandle intfHandle = this.getInterfaceHandle(endpoint.interfaceNumber());
        try (Arena arena = Arena.ofConfined();){
            MemorySegment errorState = Win.allocateErrorState(arena);
            MemorySegment timeoutHolder = arena.allocate(ValueLayout.JAVA_INT, 0);
            if (WinUSB2.WinUsb_SetPipePolicy(intfHandle.winusbHandle, endpoint.endpointAddress(), WinUSB.PIPE_TRANSFER_TIMEOUT(), (int)timeoutHolder.byteSize(), timeoutHolder, errorState) == 0) {
                WindowsUsbException.throwLastError(errorState, "setting timeout failed", new Object[0]);
            }
            MemorySegment rawIoHolder = arena.allocate(ValueLayout.JAVA_BYTE, (byte)1);
            if (WinUSB2.WinUsb_SetPipePolicy(intfHandle.winusbHandle, endpoint.endpointAddress(), WinUSB.RAW_IO(), (int)rawIoHolder.byteSize(), rawIoHolder, errorState) == 0) {
                WindowsUsbException.throwLastError(errorState, "setting raw IO failed", new Object[0]);
            }
        }
    }

    @Override
    public synchronized void clearHalt(UsbDirection direction, int endpointNumber) {
        UsbDeviceImpl.EndpointInfo endpoint = this.getEndpoint(direction, endpointNumber, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
        InterfaceHandle intfHandle = this.getInterfaceHandle(endpoint.interfaceNumber());
        try (Arena arena = Arena.ofConfined();){
            MemorySegment errorState = Win.allocateErrorState(arena);
            if (WinUSB2.WinUsb_ResetPipe(intfHandle.winusbHandle, endpoint.endpointAddress(), errorState) == 0) {
                WindowsUsbException.throwLastError(errorState, "clearing halt failed", new Object[0]);
            }
        }
    }

    @Override
    public synchronized void abortTransfers(UsbDirection direction, int endpointNumber) {
        UsbDeviceImpl.EndpointInfo endpoint = this.getEndpoint(direction, endpointNumber, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
        InterfaceHandle intfHandle = this.getInterfaceHandle(endpoint.interfaceNumber());
        try (Arena arena = Arena.ofConfined();){
            MemorySegment errorState = Win.allocateErrorState(arena);
            if (WinUSB2.WinUsb_AbortPipe(intfHandle.winusbHandle, endpoint.endpointAddress(), errorState) == 0) {
                WindowsUsbException.throwLastError(errorState, "aborting transfers on endpoint failed", new Object[0]);
            }
        }
    }

    @Override
    @NotNull
    public synchronized InputStream openInputStream(int endpointNumber, int bufferSize) {
        this.getEndpoint(UsbDirection.IN, endpointNumber, UsbTransferType.BULK, null);
        return new WindowsEndpointInputStream(this, endpointNumber, bufferSize);
    }

    @Override
    @NotNull
    public synchronized OutputStream openOutputStream(int endpointNumber, int bufferSize) {
        this.getEndpoint(UsbDirection.OUT, endpointNumber, UsbTransferType.BULK, null);
        return new WindowsEndpointOutputStream(this, endpointNumber, bufferSize);
    }

    private InterfaceHandle getInterfaceHandle(int interfaceNumber) {
        for (InterfaceHandle intfHandle : this.interfaceHandles) {
            if (intfHandle.interfaceNumber != interfaceNumber) continue;
            return intfHandle;
        }
        WindowsUsbException.throwException("invalid interface number %s", interfaceNumber);
        throw new AssertionError((Object)"not reached");
    }

    private InterfaceHandle findControlTransferInterface(UsbControlTransfer setup) {
        int interfaceNumber = -1;
        if (setup.recipient() == UsbRecipient.INTERFACE) {
            interfaceNumber = setup.index() & 0xFF;
        } else if (setup.recipient() == UsbRecipient.ENDPOINT) {
            UsbDirection direction;
            int endpointNumber = setup.index() & 0x7F;
            UsbDirection usbDirection = direction = (setup.index() & 0x80) != 0 ? UsbDirection.IN : UsbDirection.OUT;
            if (endpointNumber != 0 && (interfaceNumber = this.getInterfaceNumber(direction, endpointNumber)) == -1) {
                WindowsUsbException.throwException("invalid endpoint number %d or interface not claimed", endpointNumber);
            }
        }
        if (interfaceNumber >= 0) {
            InterfaceHandle intfHandle = this.getInterfaceHandle(interfaceNumber);
            if (intfHandle.winusbHandle == null) {
                WindowsUsbException.throwException("interface number %d has not been claimed", interfaceNumber);
            }
            return intfHandle;
        }
        for (InterfaceHandle intfHandle : this.interfaceHandles) {
            if (intfHandle.winusbHandle == null) continue;
            return intfHandle;
        }
        WindowsUsbException.throwException("control transfer cannot be executed as no interface has been claimed", new Object[0]);
        throw new AssertionError((Object)"not reached");
    }

    private String getInterfaceDevicePath(int interfaceNumber) {
        String devicePath = this.getCachedInterfaceDevicePath(interfaceNumber);
        if (devicePath != null) {
            return devicePath;
        }
        String parentDevicePath = (String)this.getUniqueId();
        try (DeviceInfoSet deviceInfoSet = DeviceInfoSet.ofPath(parentDevicePath);){
            List<String> childrenInstanceIDs = deviceInfoSet.getStringListProperty(DevicePropertyKey.Children);
            if (childrenInstanceIDs == null) {
                LOG.log(System.Logger.Level.DEBUG, "missing children instance IDs for device {0}", parentDevicePath);
                String string2 = null;
                return string2;
            }
            LOG.log(System.Logger.Level.DEBUG, "children instance IDs: {0}", childrenInstanceIDs);
            for (String instanceId : childrenInstanceIDs) {
                devicePath = this.getChildDevicePath(instanceId, interfaceNumber);
                if (devicePath == null) continue;
                String string3 = devicePath;
                return string3;
            }
        }
        return null;
    }

    private String getCachedInterfaceDevicePath(int interfaceNumber) {
        if (!this.isComposite) {
            return (String)this.getUniqueId();
        }
        return this.devicePaths.get(interfaceNumber);
    }

    private String getChildDevicePath(String instanceId, int interfaceNumber) {
        try (DeviceInfoSet deviceInfoSet = DeviceInfoSet.ofInstance(instanceId);){
            List<String> hardwareIds = deviceInfoSet.getStringListProperty(DevicePropertyKey.HardwareIds);
            if (hardwareIds == null) {
                LOG.log(System.Logger.Level.DEBUG, "child device {0} has no hardware IDs", instanceId);
                String string2 = null;
                return string2;
            }
            int extractedNumber = WindowsUsbDevice.extractInterfaceNumber(hardwareIds);
            if (extractedNumber == -1) {
                LOG.log(System.Logger.Level.DEBUG, "child device {0} has no interface number", instanceId);
                String string3 = null;
                return string3;
            }
            if (extractedNumber != interfaceNumber) {
                String string4 = null;
                return string4;
            }
            String devicePath = deviceInfoSet.getDevicePathByGUID(instanceId);
            if (devicePath == null) {
                LOG.log(System.Logger.Level.INFO, "Child device {0} has no device path / interface GUID", instanceId);
                throw new UsbException("claiming interface failed (function has no device path / interface GUID, might be missing WinUSB driver)");
            }
            if (this.devicePaths == null) {
                this.devicePaths = new HashMap<Integer, String>();
            }
            this.devicePaths.put(interfaceNumber, devicePath);
            String string5 = devicePath;
            return string5;
        }
    }

    private static int extractInterfaceNumber(List<String> hardwareIds) {
        for (String id : hardwareIds) {
            Matcher matcher = MULTIPLE_INTERFACE_ID.matcher(id);
            if (!matcher.find()) continue;
            String intfHexNumber = matcher.group(1);
            try {
                return Integer.parseInt(intfHexNumber, 16);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return -1;
    }
}

