/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntFunction;
import net.codecrete.usb.UsbDevice;
import net.codecrete.usb.UsbDirection;
import net.codecrete.usb.UsbEndpoint;
import net.codecrete.usb.UsbException;
import net.codecrete.usb.UsbInterface;
import net.codecrete.usb.UsbTimeoutException;
import net.codecrete.usb.UsbTransferType;
import net.codecrete.usb.Version;
import net.codecrete.usb.common.Configuration;
import net.codecrete.usb.common.ConfigurationParser;
import net.codecrete.usb.common.Transfer;
import net.codecrete.usb.common.UsbInterfaceImpl;
import net.codecrete.usb.usbstandard.DeviceDescriptor;
import org.jetbrains.annotations.NotNull;

public abstract class UsbDeviceImpl
implements UsbDevice {
    protected final Object uniqueDeviceId;
    protected List<UsbInterface> interfaceList;
    protected byte[] rawDeviceDescriptor;
    protected byte[] rawConfigurationDescriptor;
    protected final int vid;
    protected final int pid;
    protected String manufacturerString;
    protected String productString;
    protected String serialString;
    protected int deviceClass;
    protected int deviceSubclass;
    protected int deviceProtocol;
    protected Version versionUsb;
    protected Version versionDevice;

    protected UsbDeviceImpl(Object id, int vendorId, int productId) {
        assert (id != null);
        this.uniqueDeviceId = id;
        this.vid = vendorId;
        this.pid = productId;
    }

    @Override
    public void detachStandardDrivers() {
        if (this.isOpened()) {
            throw new UsbException("detachStandardDrivers() must not be called while the device is open");
        }
    }

    @Override
    public void attachStandardDrivers() {
        if (this.isOpened()) {
            throw new UsbException("attachStandardDrivers() must not be called while the device is open");
        }
    }

    protected void checkIsOpen() {
        if (!this.isOpened()) {
            throw new UsbException("device needs to be opened first for this operation");
        }
    }

    @Override
    public int getProductId() {
        return this.pid;
    }

    @Override
    public int getVendorId() {
        return this.vid;
    }

    @Override
    public String getProduct() {
        return this.productString;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturerString;
    }

    @Override
    public String getSerialNumber() {
        return this.serialString;
    }

    @Override
    public int getClassCode() {
        return this.deviceClass;
    }

    @Override
    public int getSubclassCode() {
        return this.deviceSubclass;
    }

    @Override
    public int getProtocolCode() {
        return this.deviceProtocol;
    }

    @Override
    @NotNull
    public Version getUsbVersion() {
        return this.versionUsb;
    }

    @Override
    @NotNull
    public Version getDeviceVersion() {
        return this.versionDevice;
    }

    @Override
    public byte @NotNull [] getConfigurationDescriptor() {
        return this.rawConfigurationDescriptor;
    }

    @Override
    public byte @NotNull [] getDeviceDescriptor() {
        return this.rawDeviceDescriptor;
    }

    public Object getUniqueId() {
        return this.uniqueDeviceId;
    }

    public void setFromDeviceDescriptor(MemorySegment descriptor) {
        this.rawDeviceDescriptor = descriptor.toArray(ValueLayout.JAVA_BYTE);
        DeviceDescriptor deviceDescriptor = new DeviceDescriptor(descriptor);
        this.deviceClass = deviceDescriptor.deviceClass() & 0xFF;
        this.deviceSubclass = deviceDescriptor.deviceSubClass() & 0xFF;
        this.deviceProtocol = deviceDescriptor.deviceProtocol() & 0xFF;
        this.versionUsb = new Version(deviceDescriptor.usbVersion());
        this.versionDevice = new Version(deviceDescriptor.deviceVersion());
    }

    protected Configuration setConfigurationDescriptor(MemorySegment descriptor) {
        this.rawConfigurationDescriptor = descriptor.toArray(ValueLayout.JAVA_BYTE);
        Configuration configuration = ConfigurationParser.parseConfigurationDescriptor(descriptor);
        this.interfaceList = configuration.interfaces();
        this.interfaceList.sort(Comparator.comparingInt(UsbInterface::getNumber));
        return configuration;
    }

    public void setProductStrings(String manufacturer, String product, String serialNumber) {
        this.manufacturerString = manufacturer;
        this.productString = product;
        this.serialString = serialNumber;
    }

    public void setProductString(MemorySegment descriptor, IntFunction<String> stringLookup) {
        DeviceDescriptor deviceDescriptor = new DeviceDescriptor(descriptor);
        this.manufacturerString = stringLookup.apply(deviceDescriptor.iManufacturer());
        this.productString = stringLookup.apply(deviceDescriptor.iProduct());
        this.serialString = stringLookup.apply(deviceDescriptor.iSerialNumber());
    }

    public void setClassCodes(int classCode, int subclassCode, int protocolCode) {
        this.deviceClass = classCode;
        this.deviceSubclass = subclassCode;
        this.deviceProtocol = protocolCode;
    }

    public void setVersions(int usbVersion, int deviceVersion) {
        this.versionUsb = new Version(usbVersion);
        this.versionDevice = new Version(deviceVersion);
    }

    @Override
    @NotNull
    public List<UsbInterface> getInterfaces() {
        return Collections.unmodifiableList(this.interfaceList);
    }

    public void setClaimed(int interfaceNumber, boolean claimed) {
        for (UsbInterface intf : this.interfaceList) {
            if (intf.getNumber() != interfaceNumber) continue;
            ((UsbInterfaceImpl)intf).setClaimed(claimed);
            return;
        }
        throw new UsbException("internal error (interface not found)");
    }

    @Override
    @NotNull
    public UsbInterfaceImpl getInterface(int interfaceNumber) {
        return (UsbInterfaceImpl)this.interfaceList.stream().filter(intf -> intf.getNumber() == interfaceNumber).findFirst().orElseThrow(() -> new UsbException(String.format("USB device has no interface %d", interfaceNumber)));
    }

    public UsbInterfaceImpl getInterfaceWithCheck(int interfaceNumber, boolean isClaimed) {
        UsbInterfaceImpl intf = this.getInterface(interfaceNumber);
        if (isClaimed && !intf.isClaimed()) {
            throw new UsbException(String.format("interface %d must be claimed first", interfaceNumber));
        }
        if (!isClaimed && intf.isClaimed()) {
            throw new UsbException(String.format("interface %d has already been claimed", interfaceNumber));
        }
        return intf;
    }

    @Override
    @NotNull
    public UsbEndpoint getEndpoint(UsbDirection direction, int endpointNumber) {
        for (UsbInterface intf : this.interfaceList) {
            for (UsbEndpoint endpoint : intf.getCurrentAlternate().getEndpoints()) {
                if (endpoint.getDirection() != direction || endpoint.getNumber() != endpointNumber) continue;
                return endpoint;
            }
        }
        throw new UsbException(String.format("endpoint %d (%s) does not exist", endpointNumber, direction.name()));
    }

    protected EndpointInfo getEndpoint(UsbDirection direction, int endpointNumber, UsbTransferType transferType1, UsbTransferType transferType2) {
        this.checkIsOpen();
        if (endpointNumber >= 1 && endpointNumber <= 127) {
            for (UsbInterface intf : this.interfaceList) {
                if (!intf.isClaimed()) continue;
                for (UsbEndpoint ep : intf.getCurrentAlternate().getEndpoints()) {
                    if (ep.getNumber() != endpointNumber || ep.getDirection() != direction || ep.getTransferType() != transferType1 && ep.getTransferType() != transferType2) continue;
                    return new EndpointInfo(intf.getNumber(), ep.getNumber(), (byte)(endpointNumber | (direction == UsbDirection.IN ? 128 : 0)), ep.getPacketSize(), ep.getTransferType());
                }
            }
        }
        this.throwInvalidEndpointException(direction, endpointNumber, transferType1, transferType2);
        return null;
    }

    protected void throwInvalidEndpointException(UsbDirection direction, int endpointNumber, UsbTransferType transferType1, UsbTransferType transferType2) {
        String transferTypeDesc = transferType2 == null ? transferType1.name() : String.format("%s or %s", transferType1.name(), transferType2.name());
        throw new UsbException(String.format("endpoint number %d does not exist, is not part of a claimed interface or is not valid for %s transfer in %s direction", endpointNumber, transferTypeDesc, direction.name()));
    }

    protected int getInterfaceNumber(UsbDirection direction, int endpointNumber) {
        if (endpointNumber < 1 || endpointNumber > 127) {
            return -1;
        }
        for (UsbInterface intf : this.interfaceList) {
            if (!intf.isClaimed()) continue;
            for (UsbEndpoint ep : intf.getCurrentAlternate().getEndpoints()) {
                if (ep.getNumber() != endpointNumber || ep.getDirection() != direction) continue;
                return intf.getNumber();
            }
        }
        return -1;
    }

    @Override
    public void transferOut(int endpointNumber, byte @NotNull [] data) {
        this.transferOut(endpointNumber, data, 0, data.length, 0);
    }

    @Override
    public void transferOut(int endpointNumber, byte @NotNull [] data, int timeout) {
        this.transferOut(endpointNumber, data, 0, data.length, timeout);
    }

    @Override
    public byte @NotNull [] transferIn(int endpointNumber) {
        return this.transferIn(endpointNumber, 0);
    }

    protected void waitForTransfer(Transfer transfer, int timeout, UsbDirection direction, int endpointNumber) {
        if (timeout <= 0) {
            UsbDeviceImpl.waitNoTimeout(transfer);
        } else {
            boolean hasTimedOut = UsbDeviceImpl.waitWithTimeout(transfer, timeout);
            if (hasTimedOut && transfer.resultCode() == 0) {
                this.abortTransfers(direction, endpointNumber);
                UsbDeviceImpl.waitNoTimeout(transfer);
                throw new UsbTimeoutException(UsbDeviceImpl.getOperationDescription(direction, endpointNumber) + " aborted due to timeout");
            }
        }
        if (transfer.resultCode() != 0) {
            String operation = UsbDeviceImpl.getOperationDescription(direction, endpointNumber);
            this.throwOSException(transfer.resultCode(), operation + " failed", new Object[0]);
        }
    }

    private static void waitNoTimeout(Transfer transfer) {
        while (transfer.resultSize() == -1) {
            try {
                transfer.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static boolean waitWithTimeout(Transfer transfer, int timeout) {
        long expiration = System.currentTimeMillis() + (long)timeout;
        long remainingTimeout = timeout;
        while (remainingTimeout > 0L && transfer.resultSize() == -1) {
            try {
                transfer.wait(remainingTimeout);
                remainingTimeout = expiration - System.currentTimeMillis();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return remainingTimeout <= 0L;
    }

    protected static String getOperationDescription(UsbDirection direction, int endpointNumber) {
        if (endpointNumber == 0) {
            return "control transfer";
        }
        return String.format("transfer %s on endpoint %d", direction.name(), endpointNumber);
    }

    protected abstract Transfer createTransfer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void onSyncTransferCompleted(Transfer transfer) {
        Transfer transfer2 = transfer;
        synchronized (transfer2) {
            transfer.notify();
        }
    }

    protected abstract void throwOSException(int var1, String var2, Object ... var3);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsbDeviceImpl that = (UsbDeviceImpl)o;
        return this.uniqueDeviceId.equals(that.uniqueDeviceId);
    }

    public int hashCode() {
        return this.uniqueDeviceId.hashCode();
    }

    public String toString() {
        return String.format("VID: 0x%04x, PID: 0x%04x, manufacturer: %s, product: %s, serial: %s, ID: %s", this.vid, this.pid, this.manufacturerString, this.productString, this.serialString, this.uniqueDeviceId);
    }

    public record EndpointInfo(int interfaceNumber, int endpointNumber, byte endpointAddress, int packetSize, UsbTransferType transferType) {
    }
}

