/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.codecrete.usb.UsbAlternateInterface;
import net.codecrete.usb.UsbControlTransfer;
import net.codecrete.usb.UsbDirection;
import net.codecrete.usb.UsbRecipient;
import net.codecrete.usb.UsbRequestType;
import net.codecrete.usb.UsbTransferType;
import net.codecrete.usb.common.Configuration;
import net.codecrete.usb.common.ForeignMemory;
import net.codecrete.usb.common.ScopeCleanup;
import net.codecrete.usb.common.Transfer;
import net.codecrete.usb.common.UsbDeviceImpl;
import net.codecrete.usb.common.UsbInterfaceImpl;
import net.codecrete.usb.macos.IoKitHelper;
import net.codecrete.usb.macos.IoKitUsb;
import net.codecrete.usb.macos.MacosAsyncTask;
import net.codecrete.usb.macos.MacosEndpointInputStream;
import net.codecrete.usb.macos.MacosEndpointOutputStream;
import net.codecrete.usb.macos.MacosTransfer;
import net.codecrete.usb.macos.MacosUsbException;
import net.codecrete.usb.macos.gen.iokit.IOKit;
import net.codecrete.usb.macos.gen.iokit.IOUSBDevRequest;
import net.codecrete.usb.macos.gen.iokit.IOUSBFindInterfaceRequest;
import net.codecrete.usb.usbstandard.ConfigurationDescriptor;
import org.jetbrains.annotations.NotNull;

public class MacosUsbDevice
extends UsbDeviceImpl {
    private final MacosAsyncTask asyncTask;
    private MemorySegment device;
    private int configurationValue;
    private List<InterfaceInfo> claimedInterfaces;
    private Map<Byte, EndpointInfo> endpoints;
    private final long discoveryTime = System.currentTimeMillis();

    MacosUsbDevice(MemorySegment device, Object id, int vendorId, int productId) {
        super(id, vendorId, productId);
        this.asyncTask = MacosAsyncTask.INSTANCE;
        this.loadDescription(device);
        this.device = device;
        IoKitUsb.AddRef(device);
    }

    @Override
    public void detachStandardDrivers() {
        int ret;
        if (this.isOpened()) {
            MacosUsbException.throwException("detachStandardDrivers() must not be called while the device is open", new Object[0]);
        }
        if ((ret = IoKitUsb.USBDeviceReEnumerate(this.device, IOKit.kUSBReEnumerateCaptureDeviceMask())) != 0) {
            MacosUsbException.throwException(ret, "detaching standard drivers failed", new Object[0]);
        }
    }

    @Override
    public void attachStandardDrivers() {
        int ret;
        if (this.isOpened()) {
            MacosUsbException.throwException("attachStandardDrivers() must not be called while the device is open", new Object[0]);
        }
        if ((ret = IoKitUsb.USBDeviceReEnumerate(this.device, IOKit.kUSBReEnumerateReleaseDeviceMask())) != 0) {
            MacosUsbException.throwException(ret, "attaching standard drivers failed", new Object[0]);
        }
    }

    @Override
    public boolean isOpened() {
        return this.claimedInterfaces != null;
    }

    @Override
    public synchronized void open() {
        long duration;
        if (this.isOpened()) {
            MacosUsbException.throwException("device is already open", new Object[0]);
        }
        int numTries = (duration = System.currentTimeMillis() - this.discoveryTime) < 1000L ? 4 : 1;
        int ret = 0;
        while (numTries > 0) {
            --numTries;
            ret = IoKitUsb.USBDeviceOpenSeize(this.device);
            if (ret != IOKit.kIOReturnExclusiveAccess()) break;
            try {
                Thread.sleep(90L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (ret != 0) {
            MacosUsbException.throwException(ret, "opening USB device failed", new Object[0]);
        }
        this.claimedInterfaces = new ArrayList<InterfaceInfo>();
        this.addDeviceEventSource();
        ret = IoKitUsb.SetConfiguration(this.device, (byte)this.configurationValue);
        if (ret != 0) {
            MacosUsbException.throwException(ret, "setting configuration failed", new Object[0]);
        }
        this.updateEndpointList();
    }

    @Override
    public synchronized void close() {
        if (!this.isOpened()) {
            return;
        }
        for (InterfaceInfo interfaceInfo : this.claimedInterfaces) {
            this.setClaimed(interfaceInfo.interfaceNumber, false);
            MemorySegment source = IoKitUsb.GetInterfaceAsyncEventSource(interfaceInfo.iokitInterface());
            IoKitUsb.USBInterfaceClose(interfaceInfo.iokitInterface);
            IoKitUsb.Release(interfaceInfo.iokitInterface);
            if (source.address() == 0L) continue;
            this.asyncTask.removeEventSource(source);
        }
        this.claimedInterfaces = null;
        this.endpoints = null;
        MemorySegment source = IoKitUsb.GetDeviceAsyncEventSource(this.device);
        IoKitUsb.USBDeviceClose(this.device);
        if (source.address() != 0L) {
            this.asyncTask.removeEventSource(source);
        }
    }

    synchronized void closeFully() {
        this.close();
        IoKitUsb.Release(this.device);
        this.device = null;
    }

    private void loadDescription(MemorySegment device) {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment data = arena.allocate(255L);
            MemorySegment deviceRequest = MacosUsbDevice.createDeviceRequest(arena, UsbDirection.IN, new UsbControlTransfer(UsbRequestType.STANDARD, UsbRecipient.DEVICE, 6, 256, 0), data);
            int ret = IoKitUsb.DeviceRequest(device, deviceRequest);
            if (ret != 0) {
                MacosUsbException.throwException(ret, "querying device descriptor failed", new Object[0]);
            }
            int len = IOUSBDevRequest.wLenDone(deviceRequest);
            this.rawDeviceDescriptor = data.asSlice(0L, len).toArray(ValueLayout.JAVA_BYTE);
            this.configurationValue = 0;
            MemorySegment descPtrHolder = arena.allocate(ValueLayout.ADDRESS);
            ret = IoKitUsb.GetConfigurationDescriptorPtr(device, (byte)0, descPtrHolder);
            if (ret != 0) {
                MacosUsbException.throwException(ret, "querying first configuration failed", new Object[0]);
            }
            MemorySegment configDesc = ForeignMemory.dereference(descPtrHolder).reinterpret(999999L);
            ConfigurationDescriptor configDescHeader = new ConfigurationDescriptor(configDesc);
            configDesc = configDesc.asSlice(0L, configDescHeader.totalLength());
            Configuration configuration = this.setConfigurationDescriptor(configDesc);
            this.configurationValue = 0xFF & configuration.configValue();
        }
    }

    /*
     * Loose catch block
     */
    private InterfaceInfo findInterfaceInfo(int interfaceNumber) {
        try (Arena arena = Arena.ofConfined();
             ScopeCleanup outerCleanup = new ScopeCleanup();){
            int service;
            MemorySegment request = IOUSBFindInterfaceRequest.allocate(arena);
            IOUSBFindInterfaceRequest.bInterfaceClass(request, (short)IOKit.kIOUSBFindInterfaceDontCare());
            IOUSBFindInterfaceRequest.bInterfaceSubClass(request, (short)IOKit.kIOUSBFindInterfaceDontCare());
            IOUSBFindInterfaceRequest.bInterfaceProtocol(request, (short)IOKit.kIOUSBFindInterfaceDontCare());
            IOUSBFindInterfaceRequest.bAlternateSetting(request, (short)IOKit.kIOUSBFindInterfaceDontCare());
            MemorySegment iterHolder = arena.allocate(ValueLayout.JAVA_INT);
            int ret = IoKitUsb.CreateInterfaceIterator(this.device, request, iterHolder);
            if (ret != 0) {
                MacosUsbException.throwException("internal error (CreateInterfaceIterator)", new Object[0]);
            }
            int iter = iterHolder.get(ValueLayout.JAVA_INT, 0L);
            outerCleanup.add(() -> IOKit.IOObjectRelease(iter));
            MemorySegment intfNumberHolder = arena.allocate(ValueLayout.JAVA_INT);
            while ((service = IOKit.IOIteratorNext(iter)) != 0) {
                MemorySegment intf;
                ScopeCleanup cleanup;
                block22: {
                    block21: {
                        cleanup = new ScopeCleanup();
                        int service_final = service;
                        cleanup.add(() -> IOKit.IOObjectRelease(service_final));
                        intf = IoKitHelper.getInterface(service, IoKitHelper.kIOUSBInterfaceUserClientTypeID, IoKitHelper.kIOUSBInterfaceInterfaceID190);
                        if (intf != null) break block21;
                        cleanup.close();
                        continue;
                    }
                    cleanup.add(() -> IoKitUsb.Release(intf));
                    IoKitUsb.GetInterfaceNumber(intf, intfNumberHolder);
                    if (intfNumberHolder.get(ValueLayout.JAVA_INT, 0L) == interfaceNumber) break block22;
                    cleanup.close();
                    continue;
                }
                try {
                    IoKitUsb.AddRef(intf);
                    InterfaceInfo interfaceInfo = new InterfaceInfo(intf, interfaceNumber);
                    cleanup.close();
                    return interfaceInfo;
                }
                catch (Throwable throwable) {
                    try {
                        cleanup.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    @Override
    public synchronized void claimInterface(int interfaceNumber) {
        this.checkIsOpen();
        this.getInterfaceWithCheck(interfaceNumber, false);
        try (ScopeCleanup cleanup = new ScopeCleanup();){
            InterfaceInfo interfaceInfo = this.findInterfaceInfo(interfaceNumber);
            cleanup.add(() -> IoKitUsb.Release(interfaceInfo.iokitInterface()));
            int ret = IoKitUsb.USBInterfaceOpen(interfaceInfo.iokitInterface());
            if (ret != 0) {
                MacosUsbException.throwException(ret, "claiming interface failed", new Object[0]);
            }
            IoKitUsb.AddRef(interfaceInfo.iokitInterface());
            this.claimedInterfaces.add(interfaceInfo);
            this.setClaimed(interfaceNumber, true);
            this.addInterfaceEventSource(interfaceInfo);
        }
        this.updateEndpointList();
    }

    @Override
    public synchronized void selectAlternateSetting(int interfaceNumber, int alternateNumber) {
        UsbInterfaceImpl intf = this.getInterfaceWithCheck(interfaceNumber, true);
        UsbAlternateInterface altSetting = intf.getAlternate(alternateNumber);
        InterfaceInfo intfInfo = this.claimedInterfaces.stream().filter(interf -> interf.interfaceNumber() == interfaceNumber).findFirst().get();
        int ret = IoKitUsb.SetAlternateInterface(intfInfo.iokitInterface(), (byte)alternateNumber);
        if (ret != 0) {
            MacosUsbException.throwException(ret, "setting alternate interface failed", new Object[0]);
        }
        intf.setAlternate(altSetting);
        this.updateEndpointList();
    }

    @Override
    public synchronized void releaseInterface(int interfaceNumber) {
        int ret;
        this.checkIsOpen();
        this.getInterfaceWithCheck(interfaceNumber, true);
        InterfaceInfo interfaceInfo = this.claimedInterfaces.stream().filter(info -> info.interfaceNumber == interfaceNumber).findFirst().get();
        MemorySegment source = IoKitUsb.GetInterfaceAsyncEventSource(interfaceInfo.iokitInterface());
        if (source.address() != 0L) {
            this.asyncTask.removeEventSource(source);
        }
        if ((ret = IoKitUsb.USBInterfaceClose(interfaceInfo.iokitInterface())) != 0) {
            MacosUsbException.throwException(ret, "releasing interface failed", new Object[0]);
        }
        this.claimedInterfaces.remove(interfaceInfo);
        IoKitUsb.Release(interfaceInfo.iokitInterface());
        this.setClaimed(interfaceNumber, false);
        this.updateEndpointList();
    }

    private void updateEndpointList() {
        this.endpoints = new HashMap<Byte, EndpointInfo>();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment directionHolder = arena.allocate(ValueLayout.JAVA_BYTE);
            MemorySegment numberHolder = arena.allocate(ValueLayout.JAVA_BYTE);
            MemorySegment transferTypeHolder = arena.allocate(ValueLayout.JAVA_BYTE);
            MemorySegment maxPacketSizeHolder = arena.allocate(ValueLayout.JAVA_SHORT);
            MemorySegment intervalHolder = arena.allocate(ValueLayout.JAVA_BYTE);
            for (InterfaceInfo interfaceInfo : this.claimedInterfaces) {
                MemorySegment numEndpointsHolder;
                MemorySegment intf = interfaceInfo.iokitInterface();
                int ret = IoKitUsb.GetNumEndpoints(intf, numEndpointsHolder = arena.allocate(ValueLayout.JAVA_BYTE));
                if (ret != 0) {
                    MacosUsbException.throwException(ret, "internal error (GetNumEndpoints)", new Object[0]);
                }
                int numEndpoints = numEndpointsHolder.get(ValueLayout.JAVA_BYTE, 0L) & 0xFF;
                for (int pipeIndex = 1; pipeIndex <= numEndpoints; ++pipeIndex) {
                    ret = IoKitUsb.GetPipeProperties(intf, (byte)pipeIndex, directionHolder, numberHolder, transferTypeHolder, maxPacketSizeHolder, intervalHolder);
                    if (ret != 0) {
                        MacosUsbException.throwException(ret, "internal error (GetPipeProperties)", new Object[0]);
                    }
                    int endpointNumber = numberHolder.get(ValueLayout.JAVA_BYTE, 0L) & 0xFF;
                    int direction = directionHolder.get(ValueLayout.JAVA_BYTE, 0L) & 0xFF;
                    byte endpointAddress = (byte)(endpointNumber | direction << 7);
                    byte transferType = transferTypeHolder.get(ValueLayout.JAVA_BYTE, 0L);
                    int maxPacketSize = maxPacketSizeHolder.get(ValueLayout.JAVA_SHORT, 0L) & 0xFFFF;
                    EndpointInfo endpointInfo = new EndpointInfo(interfaceInfo.iokitInterface(), (byte)pipeIndex, MacosUsbDevice.getTransferType(transferType), maxPacketSize);
                    this.endpoints.put(endpointAddress, endpointInfo);
                }
            }
        }
    }

    private synchronized EndpointInfo getEndpointInfo(int endpointNumber, UsbDirection direction, UsbTransferType transferType1, UsbTransferType transferType2) {
        byte endpointAddress;
        EndpointInfo endpointInfo;
        if (this.endpoints != null && (endpointInfo = this.endpoints.get(endpointAddress = (byte)(endpointNumber | (direction == UsbDirection.IN ? 128 : 0)))) != null && (endpointInfo.transferType == transferType1 || endpointInfo.transferType == transferType2)) {
            return endpointInfo;
        }
        String transferTypeDesc = transferType2 == null ? transferType1.name() : String.format("%s or %s", transferType1.name(), transferType2.name());
        MacosUsbException.throwException("endpoint number %d does not exist, is not part of a claimed interface or is not valid for %s transfer in %s direction", endpointNumber, transferTypeDesc, direction.name());
        throw new AssertionError((Object)"not reached");
    }

    private static MemorySegment createDeviceRequest(Arena arena, UsbDirection direction, UsbControlTransfer setup, MemorySegment data) {
        MemorySegment deviceRequest = IOUSBDevRequest.allocate(arena);
        int bmRequestType = (direction == UsbDirection.IN ? 128 : 0) | setup.requestType().ordinal() << 5 | setup.recipient().ordinal();
        IOUSBDevRequest.bmRequestType(deviceRequest, (byte)bmRequestType);
        IOUSBDevRequest.bRequest(deviceRequest, (byte)setup.request());
        IOUSBDevRequest.wValue(deviceRequest, (short)setup.value());
        IOUSBDevRequest.wIndex(deviceRequest, (short)setup.index());
        IOUSBDevRequest.wLength(deviceRequest, (short)data.byteSize());
        IOUSBDevRequest.pData(deviceRequest, data);
        return deviceRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte @NotNull [] controlTransferIn(@NotNull UsbControlTransfer setup, int length) {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment data = arena.allocate(length);
            MemorySegment deviceRequest = MacosUsbDevice.createDeviceRequest(arena, UsbDirection.IN, setup, data);
            MacosTransfer transfer = new MacosTransfer();
            transfer.setCompletion(x$0 -> UsbDeviceImpl.onSyncTransferCompleted(x$0));
            Object object = transfer;
            synchronized (object) {
                this.submitControlTransfer(deviceRequest, transfer);
                this.waitForTransfer(transfer, 0, UsbDirection.IN, 0);
            }
            object = data.asSlice(0L, transfer.resultSize()).toArray(ValueLayout.JAVA_BYTE);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void controlTransferOut(@NotNull UsbControlTransfer setup, byte[] data) {
        try (Arena arena = Arena.ofConfined();){
            int dataLength = data != null ? data.length : 0;
            MemorySegment dataSegment = arena.allocate(dataLength);
            if (dataLength > 0) {
                dataSegment.copyFrom(MemorySegment.ofArray(data));
            }
            MemorySegment deviceRequest = MacosUsbDevice.createDeviceRequest(arena, UsbDirection.OUT, setup, dataSegment);
            MacosTransfer transfer = new MacosTransfer();
            transfer.setCompletion(x$0 -> UsbDeviceImpl.onSyncTransferCompleted(x$0));
            MacosTransfer macosTransfer = transfer;
            synchronized (macosTransfer) {
                this.submitControlTransfer(deviceRequest, transfer);
                this.waitForTransfer(transfer, 0, UsbDirection.OUT, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferOut(int endpointNumber, byte @NotNull [] data, int offset, int length, int timeout) {
        EndpointInfo epInfo = this.getEndpointInfo(endpointNumber, UsbDirection.OUT, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
        try (Arena arena = Arena.ofConfined();){
            MemorySegment nativeData = arena.allocate(ValueLayout.JAVA_BYTE, length);
            nativeData.copyFrom(MemorySegment.ofArray(data).asSlice((long)offset, length));
            MacosTransfer transfer = new MacosTransfer();
            transfer.setData(nativeData);
            transfer.setDataSize(length);
            transfer.setCompletion(x$0 -> UsbDeviceImpl.onSyncTransferCompleted(x$0));
            MacosTransfer macosTransfer = transfer;
            synchronized (macosTransfer) {
                if (timeout <= 0 || epInfo.transferType() == UsbTransferType.BULK) {
                    this.submitTransferOut(endpointNumber, transfer, timeout);
                    this.waitForTransfer(transfer, 0, UsbDirection.OUT, endpointNumber);
                } else {
                    this.submitTransferOut(endpointNumber, transfer, 0);
                    this.waitForTransfer(transfer, timeout, UsbDirection.OUT, endpointNumber);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte @NotNull [] transferIn(int endpointNumber, int timeout) {
        EndpointInfo epInfo = this.getEndpointInfo(endpointNumber, UsbDirection.IN, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
        try (Arena arena = Arena.ofConfined();){
            MemorySegment nativeData = arena.allocate(ValueLayout.JAVA_BYTE, epInfo.packetSize());
            MacosTransfer transfer = new MacosTransfer();
            transfer.setData(nativeData);
            transfer.setDataSize(epInfo.packetSize());
            transfer.setCompletion(x$0 -> UsbDeviceImpl.onSyncTransferCompleted(x$0));
            Object object = transfer;
            synchronized (object) {
                if (timeout <= 0 || epInfo.transferType() == UsbTransferType.BULK) {
                    this.submitTransferIn(endpointNumber, transfer, timeout);
                    this.waitForTransfer(transfer, 0, UsbDirection.IN, endpointNumber);
                } else {
                    this.submitTransferIn(endpointNumber, transfer, 0);
                    this.waitForTransfer(transfer, timeout, UsbDirection.IN, endpointNumber);
                }
            }
            object = nativeData.asSlice(0L, transfer.resultSize()).toArray(ValueLayout.JAVA_BYTE);
            return object;
        }
    }

    synchronized void submitTransferIn(int endpointNumber, MacosTransfer transfer, int timeout) {
        EndpointInfo epInfo = this.getEndpointInfo(endpointNumber, UsbDirection.IN, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
        this.asyncTask.prepareForSubmission(transfer);
        int ret = timeout <= 0 ? IoKitUsb.ReadPipeAsync(epInfo.iokitInterface(), epInfo.pipeIndex(), transfer.data(), transfer.dataSize(), this.asyncTask.nativeCompletionCallback(), MemorySegment.ofAddress(transfer.id())) : IoKitUsb.ReadPipeAsyncTO(epInfo.iokitInterface(), epInfo.pipeIndex(), transfer.data(), transfer.dataSize(), timeout, timeout, this.asyncTask.nativeCompletionCallback(), MemorySegment.ofAddress(transfer.id()));
        if (ret != 0) {
            MacosUsbException.throwException(ret, "error occurred while reading from endpoint %d", endpointNumber);
        }
    }

    synchronized void submitTransferOut(int endpointNumber, MacosTransfer transfer, int timeout) {
        EndpointInfo epInfo = this.getEndpointInfo(endpointNumber, UsbDirection.OUT, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
        this.asyncTask.prepareForSubmission(transfer);
        int ret = timeout <= 0 ? IoKitUsb.WritePipeAsync(epInfo.iokitInterface(), epInfo.pipeIndex(), transfer.data(), transfer.dataSize(), this.asyncTask.nativeCompletionCallback(), MemorySegment.ofAddress(transfer.id())) : IoKitUsb.WritePipeAsyncTO(epInfo.iokitInterface(), epInfo.pipeIndex(), transfer.data(), transfer.dataSize(), timeout, timeout, this.asyncTask.nativeCompletionCallback(), MemorySegment.ofAddress(transfer.id()));
        if (ret != 0) {
            MacosUsbException.throwException(ret, "error occurred while transmitting to endpoint %d", endpointNumber);
        }
    }

    synchronized void submitControlTransfer(MemorySegment deviceRequest, MacosTransfer transfer) {
        this.checkIsOpen();
        this.asyncTask.prepareForSubmission(transfer);
        int ret = IoKitUsb.DeviceRequestAsync(this.device, deviceRequest, this.asyncTask.nativeCompletionCallback(), MemorySegment.ofAddress(transfer.id()));
        if (ret != 0) {
            MacosUsbException.throwException(ret, "control transfer failed", new Object[0]);
        }
    }

    @Override
    protected Transfer createTransfer() {
        return new MacosTransfer();
    }

    @Override
    public void abortTransfers(UsbDirection direction, int endpointNumber) {
        EndpointInfo epInfo = this.getEndpointInfo(endpointNumber, direction, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
        int ret = IoKitUsb.AbortPipe(epInfo.iokitInterface(), epInfo.pipeIndex());
        if (ret != 0) {
            MacosUsbException.throwException(ret, "aborting transfers failed", new Object[0]);
        }
    }

    @Override
    public void clearHalt(UsbDirection direction, int endpointNumber) {
        EndpointInfo epInfo = this.getEndpointInfo(endpointNumber, direction, UsbTransferType.BULK, UsbTransferType.INTERRUPT);
        int ret = IoKitUsb.ClearPipeStallBothEnds(epInfo.iokitInterface(), epInfo.pipeIndex());
        if (ret != 0) {
            MacosUsbException.throwException(ret, "clearing halt condition failed", new Object[0]);
        }
    }

    @Override
    @NotNull
    public synchronized InputStream openInputStream(int endpointNumber, int bufferSize) {
        this.getEndpointInfo(endpointNumber, UsbDirection.IN, UsbTransferType.BULK, null);
        return new MacosEndpointInputStream(this, endpointNumber, bufferSize);
    }

    @Override
    @NotNull
    public synchronized OutputStream openOutputStream(int endpointNumber, int bufferSize) {
        this.getEndpointInfo(endpointNumber, UsbDirection.OUT, UsbTransferType.BULK, null);
        return new MacosEndpointOutputStream(this, endpointNumber, bufferSize);
    }

    @Override
    protected void throwOSException(int errorCode, String message, Object ... args) {
        MacosUsbException.throwException(errorCode, message, args);
    }

    private static UsbTransferType getTransferType(byte macosTransferType) {
        return switch (macosTransferType) {
            case 1 -> UsbTransferType.ISOCHRONOUS;
            case 2 -> UsbTransferType.BULK;
            case 3 -> UsbTransferType.INTERRUPT;
            default -> null;
        };
    }

    private synchronized void addDeviceEventSource() {
        try (Arena innerArena = Arena.ofConfined();){
            MemorySegment sourceHolder = innerArena.allocate(ValueLayout.ADDRESS);
            int ret = IoKitUsb.CreateDeviceAsyncEventSource(this.device, sourceHolder);
            if (ret != 0) {
                MacosUsbException.throwException(ret, "internal error (CreateDeviceAsyncEventSource)", new Object[0]);
            }
            MemorySegment source = ForeignMemory.dereference(sourceHolder);
            this.asyncTask.addEventSource(source);
        }
    }

    private synchronized void addInterfaceEventSource(InterfaceInfo interfaceInfo) {
        try (Arena innerArena = Arena.ofConfined();){
            MemorySegment sourceHolder = innerArena.allocate(ValueLayout.ADDRESS);
            int ret = IoKitUsb.CreateInterfaceAsyncEventSource(interfaceInfo.iokitInterface(), sourceHolder);
            if (ret != 0) {
                MacosUsbException.throwException(ret, "internal error (CreateInterfaceAsyncEventSource)", new Object[0]);
            }
            MemorySegment source = ForeignMemory.dereference(sourceHolder);
            this.asyncTask.addEventSource(source);
        }
    }

    record InterfaceInfo(MemorySegment iokitInterface, int interfaceNumber) {
    }

    record EndpointInfo(MemorySegment iokitInterface, byte pipeIndex, UsbTransferType transferType, int packetSize) {
    }
}

