/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.codecrete.usb.UsbDevice;
import net.codecrete.usb.common.ScopeCleanup;
import net.codecrete.usb.common.UsbDeviceRegistry;
import net.codecrete.usb.macos.CoreFoundationHelper;
import net.codecrete.usb.macos.IoKitHelper;
import net.codecrete.usb.macos.IoKitUsb;
import net.codecrete.usb.macos.MacosUsbDevice;
import net.codecrete.usb.macos.MacosUsbException;
import net.codecrete.usb.macos.gen.corefoundation.CoreFoundation;
import net.codecrete.usb.macos.gen.iokit.IOKit;

public class MacosUsbDeviceRegistry
extends UsbDeviceRegistry {
    private static final System.Logger LOG = System.getLogger(MacosUsbDeviceRegistry.class.getName());
    private static final MemorySegment KEY_ID_VENDOR;
    private static final MemorySegment KEY_ID_PRODUCT;
    private static final MemorySegment KEY_VENDOR;
    private static final MemorySegment KEY_PRODUCT;
    private static final MemorySegment KEY_SERIAL_NUM;
    private static final MemorySegment KEY_DEVICE_CLASS;
    private static final MemorySegment KEY_DEVICE_SUBCLASS;
    private static final MemorySegment KEY_DEVICE_PROTOCOL;
    private static final MemorySegment KEY_USB_BCD;
    private static final MemorySegment KEY_DEVICE_BCD;

    @Override
    protected void monitorDevices() {
        Arena arena = Arena.ofConfined();
        try {
            try {
                MemorySegment notifyPort = IOKit.IONotificationPortCreate(IOKit.kIOMasterPortDefault());
                MemorySegment runLoopSource = IOKit.IONotificationPortGetRunLoopSource(notifyPort);
                MemorySegment runLoop = CoreFoundation.CFRunLoopGetCurrent();
                CoreFoundation.CFRunLoopAddSource(runLoop, runLoopSource, IOKit.kCFRunLoopDefaultMode());
                MethodHandle onDeviceConnectedMH = MethodHandles.lookup().findVirtual(MacosUsbDeviceRegistry.class, "onDevicesConnected", MethodType.methodType(Void.TYPE, MemorySegment.class, Integer.TYPE));
                int deviceConnectedIter = this.setupNotification(arena, notifyPort, IOKit.kIOFirstMatchNotification(), onDeviceConnectedMH);
                ArrayList<UsbDevice> deviceList = new ArrayList<UsbDevice>();
                this.iterateDevices(deviceConnectedIter, (UsbDevice device) -> deviceList.add((UsbDevice)device));
                this.setInitialDeviceList(deviceList);
                MethodHandle onDeviceDisconnectedMH = MethodHandles.lookup().findVirtual(MacosUsbDeviceRegistry.class, "onDevicesDisconnected", MethodType.methodType(Void.TYPE, MemorySegment.class, Integer.TYPE));
                int deviceDisconnectedIter = this.setupNotification(arena, notifyPort, IOKit.kIOTerminatedNotification(), onDeviceDisconnectedMH);
                this.onDevicesDisconnected(MemorySegment.NULL, deviceDisconnectedIter);
            }
            catch (Exception e) {
                this.enumerationFailed(e);
                if (arena != null) {
                    arena.close();
                }
                return;
            }
            CoreFoundation.CFRunLoopRun();
        }
        finally {
            if (arena != null) {
                try {
                    arena.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private void iterateDevices(int iterator, IOKitDeviceConsumer consumer) {
        try (Arena arena = Arena.ofConfined();){
            int svc;
            MemorySegment entryIdHolder = arena.allocate(ValueLayout.JAVA_LONG);
            while ((svc = IOKit.IOIteratorNext(iterator)) != 0) {
                try (ScopeCleanup cleanup = new ScopeCleanup();){
                    int ret;
                    int service = svc;
                    cleanup.add(() -> IOKit.IOObjectRelease(service));
                    MemorySegment device = IoKitHelper.getInterface(service, IoKitHelper.kIOUSBDeviceUserClientTypeID, IoKitHelper.kIOUSBDeviceInterfaceID187);
                    if (device != null) {
                        cleanup.add(() -> IoKitUsb.Release(device));
                    }
                    if ((ret = IOKit.IORegistryEntryGetRegistryEntryID(service, entryIdHolder)) != 0) {
                        MacosUsbException.throwException(ret, "internal error (IORegistryEntryGetRegistryEntryID)", new Object[0]);
                    }
                    long entryId = entryIdHolder.get(ValueLayout.JAVA_LONG, 0L);
                    consumer.accept(entryId, service, device);
                }
            }
        }
    }

    private void iterateDevices(int iterator, Consumer<UsbDevice> consumer) {
        this.iterateDevices(iterator, (long entryId, int service, MemorySegment deviceIntf) -> {
            VidPid deviceInfo = new VidPid();
            try {
                UsbDevice device = this.createDevice(entryId, service, deviceIntf, deviceInfo);
                if (device != null) {
                    consumer.accept(device);
                }
            }
            catch (Exception e) {
                LOG.log(System.Logger.Level.INFO, String.format("failed to retrieve information about device 0x%04x/0x%04x - ignoring device", deviceInfo.vid, deviceInfo.pid), (Throwable)e);
            }
        });
    }

    private UsbDevice createDevice(Long entryID, int service, MemorySegment deviceIntf, VidPid info) {
        if (deviceIntf == null) {
            return null;
        }
        try (Arena arena = Arena.ofConfined();){
            Integer vendorId = IoKitHelper.getPropertyInt(service, KEY_ID_VENDOR, arena);
            Integer productId = IoKitHelper.getPropertyInt(service, KEY_ID_PRODUCT, arena);
            if (vendorId == null || productId == null) {
                UsbDevice usbDevice = null;
                return usbDevice;
            }
            info.vid = vendorId;
            info.pid = productId;
            MacosUsbDevice device = new MacosUsbDevice(deviceIntf, entryID, vendorId, productId);
            String manufacturer = IoKitHelper.getPropertyString(service, KEY_VENDOR, arena);
            String product = IoKitHelper.getPropertyString(service, KEY_PRODUCT, arena);
            String serial = IoKitHelper.getPropertyString(service, KEY_SERIAL_NUM, arena);
            device.setProductStrings(manufacturer, product, serial);
            Integer classCode = IoKitHelper.getPropertyInt(service, KEY_DEVICE_CLASS, arena);
            Integer subclassCode = IoKitHelper.getPropertyInt(service, KEY_DEVICE_SUBCLASS, arena);
            Integer protocolCode = IoKitHelper.getPropertyInt(service, KEY_DEVICE_PROTOCOL, arena);
            device.setClassCodes(classCode != null ? classCode : 0, subclassCode != null ? subclassCode : 0, protocolCode != null ? protocolCode : 0);
            Integer usbVersion = IoKitHelper.getPropertyInt(service, KEY_USB_BCD, arena);
            Integer deviceVersion = IoKitHelper.getPropertyInt(service, KEY_DEVICE_BCD, arena);
            device.setVersions(usbVersion, deviceVersion != null ? deviceVersion : 0);
            MacosUsbDevice macosUsbDevice = device;
            return macosUsbDevice;
        }
    }

    private int setupNotification(Arena arena, MemorySegment notifyPort, MemorySegment notificationType, MethodHandle callback2) {
        MemorySegment deviceIterHolder;
        MemorySegment matchingDict = IOKit.IOServiceMatching(IOKit.kIOUSBDeviceClassName());
        MemorySegment onDeviceCallbackStub = Linker.nativeLinker().upcallStub(callback2.bindTo(this), FunctionDescriptor.ofVoid(ValueLayout.ADDRESS, ValueLayout.JAVA_INT), Arena.global(), new Linker.Option[0]);
        int ret = IOKit.IOServiceAddMatchingNotification(notifyPort, notificationType, matchingDict, onDeviceCallbackStub, MemorySegment.NULL, deviceIterHolder = arena.allocate(ValueLayout.JAVA_INT));
        if (ret != 0) {
            MacosUsbException.throwException(ret, "internal error (IOServiceAddMatchingNotification)", new Object[0]);
        }
        return deviceIterHolder.get(ValueLayout.JAVA_INT, 0L);
    }

    private void onDevicesConnected(MemorySegment ignoredRefCon, int iterator) {
        this.iterateDevices(iterator, (UsbDevice x$0) -> this.addDevice((UsbDevice)x$0));
    }

    private void onDevicesDisconnected(MemorySegment ignoredRefCon, int iterator) {
        this.iterateDevices(iterator, (long entryId, int n, MemorySegment memorySegment) -> {
            UsbDevice device = this.findDevice(entryId);
            if (device == null) {
                return;
            }
            try {
                ((MacosUsbDevice)device).closeFully();
            }
            catch (Exception e) {
                LOG.log(System.Logger.Level.INFO, "failed to close USB device - ignoring exception", (Throwable)e);
            }
            this.removeDevice(entryId);
        });
    }

    static {
        Arena global = Arena.global();
        KEY_ID_VENDOR = CoreFoundationHelper.createCFStringRef("idVendor", global);
        KEY_ID_PRODUCT = CoreFoundationHelper.createCFStringRef("idProduct", global);
        KEY_VENDOR = CoreFoundationHelper.createCFStringRef("kUSBVendorString", global);
        KEY_PRODUCT = CoreFoundationHelper.createCFStringRef("kUSBProductString", global);
        KEY_SERIAL_NUM = CoreFoundationHelper.createCFStringRef("kUSBSerialNumberString", global);
        KEY_DEVICE_CLASS = CoreFoundationHelper.createCFStringRef("bDeviceClass", global);
        KEY_DEVICE_SUBCLASS = CoreFoundationHelper.createCFStringRef("bDeviceSubClass", global);
        KEY_DEVICE_PROTOCOL = CoreFoundationHelper.createCFStringRef("bDeviceProtocol", global);
        KEY_USB_BCD = CoreFoundationHelper.createCFStringRef("bcdUSB", global);
        KEY_DEVICE_BCD = CoreFoundationHelper.createCFStringRef("bcdDevice", global);
    }

    @FunctionalInterface
    static interface IOKitDeviceConsumer {
        public void accept(long var1, int var3, MemorySegment var4);
    }

    static class VidPid {
        int vid;
        int pid;

        VidPid() {
        }
    }
}

