/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.usbstandard;

import java.lang.foreign.GroupLayout;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;

public class DeviceDescriptor {
    private final MemorySegment descriptor;
    public static final GroupLayout LAYOUT = MemoryLayout.structLayout(ValueLayout.JAVA_BYTE.withName("bLength"), ValueLayout.JAVA_BYTE.withName("bDescriptorType"), ValueLayout.JAVA_SHORT_UNALIGNED.withName("bcdUSB"), ValueLayout.JAVA_BYTE.withName("bDeviceClass"), ValueLayout.JAVA_BYTE.withName("bDeviceSubClass"), ValueLayout.JAVA_BYTE.withName("bDeviceProtocol"), ValueLayout.JAVA_BYTE.withName("bMaxPacketSize0"), ValueLayout.JAVA_SHORT_UNALIGNED.withName("idVendor"), ValueLayout.JAVA_SHORT_UNALIGNED.withName("idProduct"), ValueLayout.JAVA_SHORT_UNALIGNED.withName("bcdDevice"), ValueLayout.JAVA_BYTE.withName("iManufacturer"), ValueLayout.JAVA_BYTE.withName("iProduct"), ValueLayout.JAVA_BYTE.withName("iSerialNumber"), ValueLayout.JAVA_BYTE.withName("bNumConfigurations"));
    private static final long bcdUSB$OFFSET = 2L;
    private static final long bDeviceClass$OFFSET = 4L;
    private static final long bDeviceSubClass$OFFSET = 5L;
    private static final long bDeviceProtocol$OFFSET = 6L;
    private static final long idVendor$OFFSET = 8L;
    private static final long idProduct$OFFSET = 10L;
    private static final long bcdDevice$OFFSET = 12L;
    private static final long iManufacturer$OFFSET = 14L;
    private static final long iProduct$OFFSET = 15L;
    private static final long iSerialNumber$OFFSET = 16L;

    public DeviceDescriptor(MemorySegment descriptor) {
        this.descriptor = descriptor;
    }

    public int usbVersion() {
        return 0xFFFF & this.descriptor.get(ValueLayout.JAVA_SHORT_UNALIGNED, 2L);
    }

    public int deviceClass() {
        return 0xFF & this.descriptor.get(ValueLayout.JAVA_BYTE, 4L);
    }

    public int deviceSubClass() {
        return 0xFF & this.descriptor.get(ValueLayout.JAVA_BYTE, 5L);
    }

    public int deviceProtocol() {
        return 0xFF & this.descriptor.get(ValueLayout.JAVA_BYTE, 6L);
    }

    public int vendorID() {
        return 0xFFFF & this.descriptor.get(ValueLayout.JAVA_SHORT_UNALIGNED, 8L);
    }

    public int productID() {
        return 0xFFFF & this.descriptor.get(ValueLayout.JAVA_SHORT_UNALIGNED, 10L);
    }

    public int deviceVersion() {
        return 0xFFFF & this.descriptor.get(ValueLayout.JAVA_SHORT_UNALIGNED, 12L);
    }

    public int iManufacturer() {
        return 0xFFFF & this.descriptor.get(ValueLayout.JAVA_SHORT_UNALIGNED, 14L);
    }

    public int iProduct() {
        return 0xFFFF & this.descriptor.get(ValueLayout.JAVA_SHORT_UNALIGNED, 15L);
    }

    public int iSerialNumber() {
        return 0xFFFF & this.descriptor.get(ValueLayout.JAVA_SHORT_UNALIGNED, 16L);
    }

    static {
        assert (LAYOUT.byteSize() == 18L);
    }
}

