/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows.gen.kernel32;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.PaddingLayout;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class Kernel32 {
    static final Arena LIBRARY_ARENA = Arena.ofAuto();
    static final boolean TRACE_DOWNCALLS = Boolean.getBoolean("jextract.trace.downcalls");
    static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.libraryLookup(System.mapLibraryName("Kernel32"), LIBRARY_ARENA).or(SymbolLookup.loaderLookup()).or(Linker.nativeLinker().defaultLookup());
    public static final ValueLayout.OfBoolean C_BOOL = ValueLayout.JAVA_BOOLEAN;
    public static final ValueLayout.OfByte C_CHAR = ValueLayout.JAVA_BYTE;
    public static final ValueLayout.OfShort C_SHORT = ValueLayout.JAVA_SHORT;
    public static final ValueLayout.OfInt C_INT = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfLong C_LONG_LONG = ValueLayout.JAVA_LONG;
    public static final ValueLayout.OfFloat C_FLOAT = ValueLayout.JAVA_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE = ValueLayout.JAVA_DOUBLE;
    public static final AddressLayout C_POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
    public static final ValueLayout.OfInt C_LONG = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfDouble C_LONG_DOUBLE = ValueLayout.JAVA_DOUBLE;
    private static final int FILE_SHARE_READ = 1;
    private static final int FILE_SHARE_WRITE = 2;
    private static final int FILE_ATTRIBUTE_NORMAL = 128;
    private static final int OPEN_EXISTING = 3;
    private static final int FILE_FLAG_OVERLAPPED = 0x40000000;
    private static final int FORMAT_MESSAGE_ALLOCATE_BUFFER = 256;
    private static final int FORMAT_MESSAGE_IGNORE_INSERTS = 512;
    private static final int FORMAT_MESSAGE_FROM_HMODULE = 2048;
    private static final int FORMAT_MESSAGE_FROM_SYSTEM = 4096;
    private static final int GENERIC_READ = Integer.MIN_VALUE;
    private static final int GENERIC_WRITE = 0x40000000;
    private static final int INFINITE = -1;
    private static final int ERROR_FILE_NOT_FOUND = 2;
    private static final int ERROR_GEN_FAILURE = 31;
    private static final int ERROR_INSUFFICIENT_BUFFER = 122;
    private static final int ERROR_MORE_DATA = 234;
    private static final int ERROR_NO_MORE_ITEMS = 259;
    private static final int ERROR_IO_PENDING = 997;
    private static final int ERROR_NOT_FOUND = 1168;

    Kernel32() {
    }

    static void traceDowncall(String name, Object ... args) {
        String traceArgs = Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", "));
        System.out.printf("%s(%s)\n", name, traceArgs);
    }

    static MemorySegment findOrThrow(String symbol) {
        return SYMBOL_LOOKUP.find(symbol).orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + symbol));
    }

    static MethodHandle upcallHandle(Class<?> fi, String name, FunctionDescriptor fdesc) {
        try {
            return MethodHandles.lookup().findVirtual(fi, name, fdesc.toMethodType());
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static MemoryLayout align(MemoryLayout layout, long align) {
        MemoryLayout memoryLayout = layout;
        Objects.requireNonNull(memoryLayout);
        MemoryLayout memoryLayout2 = memoryLayout;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PaddingLayout.class, ValueLayout.class, GroupLayout.class, SequenceLayout.class}, (Object)memoryLayout2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PaddingLayout p;
                yield p = (PaddingLayout)memoryLayout2;
            }
            case 1 -> {
                ValueLayout v = (ValueLayout)memoryLayout2;
                yield v.withByteAlignment(align);
            }
            case 2 -> {
                GroupLayout g = (GroupLayout)memoryLayout2;
                MemoryLayout[] alignedMembers = (MemoryLayout[])g.memberLayouts().stream().map(m -> Kernel32.align(m, align)).toArray(MemoryLayout[]::new);
                if (g instanceof StructLayout) {
                    yield MemoryLayout.structLayout(alignedMembers);
                }
                yield MemoryLayout.unionLayout(alignedMembers);
            }
            case 3 -> {
                SequenceLayout s = (SequenceLayout)memoryLayout2;
                yield MemoryLayout.sequenceLayout(s.elementCount(), Kernel32.align(s.elementLayout(), align));
            }
        };
    }

    public static int FILE_SHARE_READ() {
        return 1;
    }

    public static int FILE_SHARE_WRITE() {
        return 2;
    }

    public static int FILE_ATTRIBUTE_NORMAL() {
        return 128;
    }

    public static int OPEN_EXISTING() {
        return 3;
    }

    public static int FILE_FLAG_OVERLAPPED() {
        return 0x40000000;
    }

    public static int FORMAT_MESSAGE_ALLOCATE_BUFFER() {
        return 256;
    }

    public static int FORMAT_MESSAGE_IGNORE_INSERTS() {
        return 512;
    }

    public static int FORMAT_MESSAGE_FROM_HMODULE() {
        return 2048;
    }

    public static int FORMAT_MESSAGE_FROM_SYSTEM() {
        return 4096;
    }

    public static FunctionDescriptor CloseHandle$descriptor() {
        return CloseHandle.DESC;
    }

    public static MethodHandle CloseHandle$handle() {
        return CloseHandle.HANDLE;
    }

    public static int CloseHandle(MemorySegment hObject) {
        MethodHandle mh$ = CloseHandle.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                Kernel32.traceDowncall("CloseHandle", hObject);
            }
            return mh$.invokeExact(hObject);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor GetModuleHandleW$descriptor() {
        return GetModuleHandleW.DESC;
    }

    public static MethodHandle GetModuleHandleW$handle() {
        return GetModuleHandleW.HANDLE;
    }

    public static MemorySegment GetModuleHandleW(MemorySegment lpModuleName) {
        MethodHandle mh$ = GetModuleHandleW.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                Kernel32.traceDowncall("GetModuleHandleW", lpModuleName);
            }
            return mh$.invokeExact(lpModuleName);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor LocalFree$descriptor() {
        return LocalFree.DESC;
    }

    public static MethodHandle LocalFree$handle() {
        return LocalFree.HANDLE;
    }

    public static MemorySegment LocalFree(MemorySegment hMem) {
        MethodHandle mh$ = LocalFree.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                Kernel32.traceDowncall("LocalFree", hMem);
            }
            return mh$.invokeExact(hMem);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor FormatMessageW$descriptor() {
        return FormatMessageW.DESC;
    }

    public static MethodHandle FormatMessageW$handle() {
        return FormatMessageW.HANDLE;
    }

    public static int FormatMessageW(int dwFlags, MemorySegment lpSource, int dwMessageId, int dwLanguageId, MemorySegment lpBuffer, int nSize, MemorySegment Arguments) {
        MethodHandle mh$ = FormatMessageW.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                Kernel32.traceDowncall("FormatMessageW", dwFlags, lpSource, dwMessageId, dwLanguageId, lpBuffer, nSize, Arguments);
            }
            return mh$.invokeExact(dwFlags, lpSource, dwMessageId, dwLanguageId, lpBuffer, nSize, Arguments);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int GENERIC_READ() {
        return Integer.MIN_VALUE;
    }

    public static int GENERIC_WRITE() {
        return 0x40000000;
    }

    public static int INFINITE() {
        return -1;
    }

    public static int ERROR_FILE_NOT_FOUND() {
        return 2;
    }

    public static int ERROR_GEN_FAILURE() {
        return 31;
    }

    public static int ERROR_INSUFFICIENT_BUFFER() {
        return 122;
    }

    public static int ERROR_MORE_DATA() {
        return 234;
    }

    public static int ERROR_NO_MORE_ITEMS() {
        return 259;
    }

    public static int ERROR_IO_PENDING() {
        return 997;
    }

    public static int ERROR_NOT_FOUND() {
        return 1168;
    }

    private static class CloseHandle {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(Kernel32.findOrThrow("CloseHandle"), DESC, new Linker.Option[0]);

        private CloseHandle() {
        }
    }

    private static class GetModuleHandleW {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(Kernel32.findOrThrow("GetModuleHandleW"), DESC, new Linker.Option[0]);

        private GetModuleHandleW() {
        }
    }

    private static class LocalFree {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(Kernel32.findOrThrow("LocalFree"), DESC, new Linker.Option[0]);

        private LocalFree() {
        }
    }

    private static class FormatMessageW {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG, C_LONG, C_POINTER, C_LONG, C_LONG, C_POINTER, C_LONG, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(Kernel32.findOrThrow("FormatMessageW"), DESC, new Linker.Option[0]);

        private FormatMessageW() {
        }
    }
}

