/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows.gen.ole32;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.PaddingLayout;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class Ole32 {
    static final Arena LIBRARY_ARENA = Arena.ofAuto();
    static final boolean TRACE_DOWNCALLS = Boolean.getBoolean("jextract.trace.downcalls");
    static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.libraryLookup(System.mapLibraryName("Ole32"), LIBRARY_ARENA).or(SymbolLookup.loaderLookup()).or(Linker.nativeLinker().defaultLookup());
    public static final ValueLayout.OfBoolean C_BOOL = ValueLayout.JAVA_BOOLEAN;
    public static final ValueLayout.OfByte C_CHAR = ValueLayout.JAVA_BYTE;
    public static final ValueLayout.OfShort C_SHORT = ValueLayout.JAVA_SHORT;
    public static final ValueLayout.OfInt C_INT = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfLong C_LONG_LONG = ValueLayout.JAVA_LONG;
    public static final ValueLayout.OfFloat C_FLOAT = ValueLayout.JAVA_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE = ValueLayout.JAVA_DOUBLE;
    public static final AddressLayout C_POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
    public static final ValueLayout.OfInt C_LONG = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfDouble C_LONG_DOUBLE = ValueLayout.JAVA_DOUBLE;

    Ole32() {
    }

    static void traceDowncall(String name, Object ... args) {
        String traceArgs = Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", "));
        System.out.printf("%s(%s)\n", name, traceArgs);
    }

    static MemorySegment findOrThrow(String symbol) {
        return SYMBOL_LOOKUP.find(symbol).orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + symbol));
    }

    static MethodHandle upcallHandle(Class<?> fi, String name, FunctionDescriptor fdesc) {
        try {
            return MethodHandles.lookup().findVirtual(fi, name, fdesc.toMethodType());
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static MemoryLayout align(MemoryLayout layout, long align) {
        MemoryLayout memoryLayout = layout;
        Objects.requireNonNull(memoryLayout);
        MemoryLayout memoryLayout2 = memoryLayout;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PaddingLayout.class, ValueLayout.class, GroupLayout.class, SequenceLayout.class}, (Object)memoryLayout2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PaddingLayout p;
                yield p = (PaddingLayout)memoryLayout2;
            }
            case 1 -> {
                ValueLayout v = (ValueLayout)memoryLayout2;
                yield v.withByteAlignment(align);
            }
            case 2 -> {
                GroupLayout g = (GroupLayout)memoryLayout2;
                MemoryLayout[] alignedMembers = (MemoryLayout[])g.memberLayouts().stream().map(m -> Ole32.align(m, align)).toArray(MemoryLayout[]::new);
                if (g instanceof StructLayout) {
                    yield MemoryLayout.structLayout(alignedMembers);
                }
                yield MemoryLayout.unionLayout(alignedMembers);
            }
            case 3 -> {
                SequenceLayout s = (SequenceLayout)memoryLayout2;
                yield MemoryLayout.sequenceLayout(s.elementCount(), Ole32.align(s.elementLayout(), align));
            }
        };
    }

    public static FunctionDescriptor CLSIDFromString$descriptor() {
        return CLSIDFromString.DESC;
    }

    public static MethodHandle CLSIDFromString$handle() {
        return CLSIDFromString.HANDLE;
    }

    public static int CLSIDFromString(MemorySegment lpsz, MemorySegment pclsid) {
        MethodHandle mh$ = CLSIDFromString.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                Ole32.traceDowncall("CLSIDFromString", lpsz, pclsid);
            }
            return mh$.invokeExact(lpsz, pclsid);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class CLSIDFromString {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG, C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(Ole32.findOrThrow("CLSIDFromString"), DESC, new Linker.Option[0]);

        private CLSIDFromString() {
        }
    }
}

