/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.linux;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;
import net.codecrete.usb.linux.Linux;
import net.codecrete.usb.linux.LinuxUsbException;
import net.codecrete.usb.linux.gen.epoll.epoll;
import net.codecrete.usb.linux.gen.errno.errno;

public class EPoll {
    private static final boolean IS_AARCH64 = System.getProperty("os.arch").equals("aarch64");
    private static final GroupLayout DATA$LAYOUT = MemoryLayout.unionLayout(ValueLayout.ADDRESS_UNALIGNED.withName("ptr"), ValueLayout.JAVA_INT_UNALIGNED.withName("fd"), ValueLayout.JAVA_INT_UNALIGNED.withName("u32"), ValueLayout.JAVA_LONG_UNALIGNED.withName("u64")).withName("epoll_data");
    static final GroupLayout EVENT$LAYOUT = IS_AARCH64 ? MemoryLayout.structLayout(ValueLayout.JAVA_INT.withName("events"), MemoryLayout.paddingLayout(4L), DATA$LAYOUT.withName("data")).withName("epoll_event") : MemoryLayout.structLayout(ValueLayout.JAVA_INT_UNALIGNED.withName("events"), DATA$LAYOUT.withName("data")).withName("epoll_event");
    static final VarHandle EVENT_ARRAY_DATA_FD$VH = EVENT$LAYOUT.arrayElementVarHandle(new MemoryLayout.PathElement[]{MemoryLayout.PathElement.groupElement("data"), MemoryLayout.PathElement.groupElement("fd")});
    private static final VarHandle EVENT_DATA_FD$VH = EVENT$LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("data"), MemoryLayout.PathElement.groupElement("fd"));
    private static final VarHandle EVENTS$VH = EVENT$LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("events"));
    private static final Linker linker = Linker.nativeLinker();
    private static final FunctionDescriptor epoll_create1$FUNC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT);
    private static final MethodHandle epoll_create1$MH = linker.downcallHandle(linker.defaultLookup().find("epoll_create").get(), epoll_create1$FUNC, Linux.ERRNO_STATE);
    private static final FunctionDescriptor epoll_ctl$FUNC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS);
    private static final MethodHandle epoll_ctl$MH = linker.downcallHandle(linker.defaultLookup().find("epoll_ctl").get(), epoll_ctl$FUNC, Linux.ERRNO_STATE);
    private static final FunctionDescriptor epoll_wait$FUNC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT);
    private static final MethodHandle epoll_wait$MH = linker.downcallHandle(linker.defaultLookup().find("epoll_wait").get(), epoll_wait$FUNC, Linux.ERRNO_STATE);

    private EPoll() {
    }

    static int epoll_create1(int flags, MemorySegment errno2) {
        try {
            return epoll_create1$MH.invokeExact(errno2, flags);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private static int epoll_ctl(int epfd, int op, int fd, MemorySegment event, MemorySegment errno2) {
        try {
            return epoll_ctl$MH.invokeExact(errno2, epfd, op, fd, event);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static int epoll_wait(int epfd, MemorySegment events, int maxevent, int timeout, MemorySegment errno2) {
        try {
            return epoll_wait$MH.invokeExact(errno2, epfd, events, maxevent, timeout);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static void addFileDescriptor(int epfd, int op, int fd) {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment errorState = Linux.allocateErrorState(arena);
            MemorySegment event = arena.allocate(EVENT$LAYOUT);
            EVENTS$VH.set(event, 0, op);
            EVENT_DATA_FD$VH.set(event, 0, fd);
            int ret = EPoll.epoll_ctl(epfd, epoll.EPOLL_CTL_ADD(), fd, event, errorState);
            if (ret < 0) {
                LinuxUsbException.throwLastError(errorState, "internal error (epoll_ctl_add)", new Object[0]);
            }
        }
    }

    static void removeFileDescriptor(int epfd, int fd) {
        try (Arena arena = Arena.ofConfined();){
            int err;
            MemorySegment errorState = Linux.allocateErrorState(arena);
            MemorySegment event = arena.allocate(EVENT$LAYOUT);
            EVENTS$VH.set(event, 0, 0);
            EVENT_DATA_FD$VH.set(event, 0, fd);
            int ret = EPoll.epoll_ctl(epfd, epoll.EPOLL_CTL_DEL(), fd, event, errorState);
            if (ret < 0 && (err = Linux.getErrno(errorState)) != errno.ENOENT()) {
                LinuxUsbException.throwLastError(errorState, "internal error (epoll_ctl_del)", new Object[0]);
            }
        }
    }
}

