/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.VarHandle;
import net.codecrete.usb.common.ForeignMemory;
import net.codecrete.usb.macos.CoreFoundationHelper;
import net.codecrete.usb.macos.IoKitUsb;
import net.codecrete.usb.macos.UUID;
import net.codecrete.usb.macos.gen.corefoundation.CoreFoundation;
import net.codecrete.usb.macos.gen.iokit.IOKit;

class IoKitHelper {
    static final MemorySegment kIOUSBDeviceUserClientTypeID = UUID.createCFUUID(new byte[]{-99, -57, -73, -128, -98, -64, 17, -44, -91, 79, 0, 10, 39, 5, 40, 97});
    static final MemorySegment kIOUSBInterfaceUserClientTypeID = UUID.createCFUUID(new byte[]{45, -105, -122, -58, -98, -13, 17, -44, -83, 81, 0, 10, 39, 5, 40, 97});
    static final MemorySegment kIOUSBDeviceInterfaceID187 = UUID.createCFUUID(new byte[]{60, -98, -31, -21, 36, 2, 17, -78, -114, 126, 0, 10, 39, -128, 30, -122});
    static final MemorySegment kIOUSBInterfaceInterfaceID190 = UUID.createCFUUID(new byte[]{-113, -37, -124, 85, 116, -90, 17, -42, -105, -79, 0, 48, 101, -45, 96, -114});
    static final MemorySegment kIOCFPlugInInterfaceID = UUID.createCFUUID(new byte[]{-62, 68, -24, 88, 16, -100, 17, -44, -111, -44, 0, 80, -28, -58, 66, 111});
    static final StructLayout COM_OBJECT = MemoryLayout.structLayout(ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.structLayout(MemoryLayout.sequenceLayout(100L, ValueLayout.ADDRESS))).withName("vtable"), ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.structLayout(ValueLayout.ADDRESS.withName("unknown"), ValueLayout.JAVA_INT.withName("refCount"))).withName("data"));
    static final VarHandle vtable$VH = COM_OBJECT.varHandle(MemoryLayout.PathElement.groupElement("vtable"));
    static final VarHandle refCount$VH = COM_OBJECT.varHandle(MemoryLayout.PathElement.groupElement("data"), MemoryLayout.PathElement.dereferenceElement(), MemoryLayout.PathElement.groupElement("refCount"));

    private IoKitHelper() {
    }

    static MemorySegment getVtable(MemorySegment self) {
        return vtable$VH.get(self, 0);
    }

    static MemorySegment getInterface(int service, MemorySegment pluginType, MemorySegment interfaceId) {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment plugHolder = arena.allocate(ValueLayout.ADDRESS);
            MemorySegment score = arena.allocate(ValueLayout.JAVA_INT);
            int ret = IOKit.IOCreatePlugInInterfaceForService(service, pluginType, kIOCFPlugInInterfaceID, plugHolder, score);
            if (ret != 0) {
                MemorySegment memorySegment = null;
                return memorySegment;
            }
            MemorySegment plug = ForeignMemory.dereference(plugHolder, COM_OBJECT);
            MemorySegment refiid = CoreFoundation.CFUUIDGetUUIDBytes(arena, interfaceId);
            MemorySegment intfHolder = arena.allocate(ValueLayout.ADDRESS);
            ret = IoKitUsb.QueryInterface(plug, refiid, intfHolder);
            IoKitUsb.Release(plug);
            if (ret != 0) {
                MemorySegment memorySegment = null;
                return memorySegment;
            }
            MemorySegment memorySegment = ForeignMemory.dereference(intfHolder, COM_OBJECT);
            return memorySegment;
        }
    }

    static Integer getPropertyInt(int service, MemorySegment key, Arena arena) {
        MemorySegment value = IOKit.IORegistryEntryCreateCFProperty(service, key, MemorySegment.NULL, 0);
        if (value.address() == 0L) {
            return null;
        }
        Integer result = null;
        long type = CoreFoundation.CFGetTypeID(value);
        if (type == CoreFoundation.CFNumberGetTypeID()) {
            MemorySegment numberValue = arena.allocate(ValueLayout.JAVA_INT);
            if (CoreFoundation.CFNumberGetValue(value, CoreFoundation.kCFNumberSInt32Type(), numberValue) != 0) {
                result = numberValue.get(ValueLayout.JAVA_INT, 0L);
            }
        }
        CoreFoundation.CFRelease(value);
        return result;
    }

    static String getPropertyString(int service, MemorySegment key, Arena arena) {
        MemorySegment value = IOKit.IORegistryEntryCreateCFProperty(service, key, MemorySegment.NULL, 0);
        if (value.address() == 0L) {
            return null;
        }
        String result = null;
        long type = CoreFoundation.CFGetTypeID(value);
        if (type == CoreFoundation.CFStringGetTypeID()) {
            result = CoreFoundationHelper.stringFromCFStringRef(value, arena);
        }
        CoreFoundation.CFRelease(value);
        return result;
    }

    static int getRefCount(MemorySegment self) {
        return refCount$VH.get(self);
    }
}

