/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos.gen.iokit;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.PaddingLayout;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.codecrete.usb.macos.gen.iokit.IOKit;

public class IOKit {
    static final Arena LIBRARY_ARENA = Arena.ofAuto();
    static final boolean TRACE_DOWNCALLS = Boolean.getBoolean("jextract.trace.downcalls");
    static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.libraryLookup("/System/Library/Frameworks/IOKit.framework/IOKit", LIBRARY_ARENA).or(SymbolLookup.loaderLookup()).or(Linker.nativeLinker().defaultLookup());
    public static final ValueLayout.OfBoolean C_BOOL = ValueLayout.JAVA_BOOLEAN;
    public static final ValueLayout.OfByte C_CHAR = ValueLayout.JAVA_BYTE;
    public static final ValueLayout.OfShort C_SHORT = ValueLayout.JAVA_SHORT;
    public static final ValueLayout.OfInt C_INT = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfLong C_LONG_LONG = ValueLayout.JAVA_LONG;
    public static final ValueLayout.OfFloat C_FLOAT = ValueLayout.JAVA_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE = ValueLayout.JAVA_DOUBLE;
    public static final AddressLayout C_POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
    public static final ValueLayout.OfLong C_LONG = ValueLayout.JAVA_LONG;
    private static final int kIOUSBFindInterfaceDontCare = 65535;
    private static final int kUSBReEnumerateCaptureDeviceMask = 0x40000000;
    private static final int kUSBReEnumerateReleaseDeviceMask = 0x20000000;
    private static final int kIOReturnExclusiveAccess = -536870203;
    private static final int kIOReturnAborted = -536870165;
    private static final int kIOUSBPipeStalled = -536854449;
    private static final int kIOUSBTransactionTimeout = -536854447;

    IOKit() {
    }

    static void traceDowncall(String name, Object ... args) {
        String traceArgs = Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", "));
        System.out.printf("%s(%s)\n", name, traceArgs);
    }

    static MemorySegment findOrThrow(String symbol) {
        return SYMBOL_LOOKUP.find(symbol).orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + symbol));
    }

    static MethodHandle upcallHandle(Class<?> fi, String name, FunctionDescriptor fdesc) {
        try {
            return MethodHandles.lookup().findVirtual(fi, name, fdesc.toMethodType());
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static MemoryLayout align(MemoryLayout layout, long align) {
        MemoryLayout memoryLayout = layout;
        Objects.requireNonNull(memoryLayout);
        MemoryLayout memoryLayout2 = memoryLayout;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PaddingLayout.class, ValueLayout.class, GroupLayout.class, SequenceLayout.class}, (Object)memoryLayout2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PaddingLayout p;
                yield p = (PaddingLayout)memoryLayout2;
            }
            case 1 -> {
                ValueLayout v = (ValueLayout)memoryLayout2;
                yield v.withByteAlignment(align);
            }
            case 2 -> {
                GroupLayout g = (GroupLayout)memoryLayout2;
                MemoryLayout[] alignedMembers = (MemoryLayout[])g.memberLayouts().stream().map(m -> IOKit.align(m, align)).toArray(MemoryLayout[]::new);
                if (g instanceof StructLayout) {
                    yield MemoryLayout.structLayout(alignedMembers);
                }
                yield MemoryLayout.unionLayout(alignedMembers);
            }
            case 3 -> {
                SequenceLayout s = (SequenceLayout)memoryLayout2;
                yield MemoryLayout.sequenceLayout(s.elementCount(), IOKit.align(s.elementLayout(), align));
            }
        };
    }

    public static int kIOUSBFindInterfaceDontCare() {
        return 65535;
    }

    public static int kUSBReEnumerateCaptureDeviceMask() {
        return 0x40000000;
    }

    public static int kUSBReEnumerateReleaseDeviceMask() {
        return 0x20000000;
    }

    public static AddressLayout kCFRunLoopDefaultMode$layout() {
        return kCFRunLoopDefaultMode.constants.LAYOUT;
    }

    public static MemorySegment kCFRunLoopDefaultMode$segment() {
        return kCFRunLoopDefaultMode.constants.SEGMENT;
    }

    public static MemorySegment kCFRunLoopDefaultMode() {
        return kCFRunLoopDefaultMode.constants.SEGMENT.get(kCFRunLoopDefaultMode.constants.LAYOUT, 0L);
    }

    public static void kCFRunLoopDefaultMode(MemorySegment varValue) {
        kCFRunLoopDefaultMode.constants.SEGMENT.set(kCFRunLoopDefaultMode.constants.LAYOUT, 0L, varValue);
    }

    public static ValueLayout.OfInt kIOMasterPortDefault$layout() {
        return kIOMasterPortDefault.constants.LAYOUT;
    }

    public static MemorySegment kIOMasterPortDefault$segment() {
        return kIOMasterPortDefault.constants.SEGMENT;
    }

    public static int kIOMasterPortDefault() {
        return kIOMasterPortDefault.constants.SEGMENT.get(kIOMasterPortDefault.constants.LAYOUT, 0L);
    }

    public static void kIOMasterPortDefault(int varValue) {
        kIOMasterPortDefault.constants.SEGMENT.set(kIOMasterPortDefault.constants.LAYOUT, 0L, varValue);
    }

    public static FunctionDescriptor IONotificationPortCreate$descriptor() {
        return IONotificationPortCreate.DESC;
    }

    public static MethodHandle IONotificationPortCreate$handle() {
        return IONotificationPortCreate.HANDLE;
    }

    public static MemorySegment IONotificationPortCreate(int mainPort) {
        MethodHandle mh$ = IONotificationPortCreate.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                IOKit.traceDowncall("IONotificationPortCreate", mainPort);
            }
            return mh$.invokeExact(mainPort);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor IONotificationPortGetRunLoopSource$descriptor() {
        return IONotificationPortGetRunLoopSource.DESC;
    }

    public static MethodHandle IONotificationPortGetRunLoopSource$handle() {
        return IONotificationPortGetRunLoopSource.HANDLE;
    }

    public static MemorySegment IONotificationPortGetRunLoopSource(MemorySegment notify) {
        MethodHandle mh$ = IONotificationPortGetRunLoopSource.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                IOKit.traceDowncall("IONotificationPortGetRunLoopSource", notify);
            }
            return mh$.invokeExact(notify);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor IOObjectRelease$descriptor() {
        return IOObjectRelease.DESC;
    }

    public static MethodHandle IOObjectRelease$handle() {
        return IOObjectRelease.HANDLE;
    }

    public static int IOObjectRelease(int object) {
        MethodHandle mh$ = IOObjectRelease.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                IOKit.traceDowncall("IOObjectRelease", object);
            }
            return mh$.invokeExact(object);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor IOIteratorNext$descriptor() {
        return IOIteratorNext.DESC;
    }

    public static MethodHandle IOIteratorNext$handle() {
        return IOIteratorNext.HANDLE;
    }

    public static int IOIteratorNext(int iterator) {
        MethodHandle mh$ = IOIteratorNext.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                IOKit.traceDowncall("IOIteratorNext", iterator);
            }
            return mh$.invokeExact(iterator);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor IOServiceAddMatchingNotification$descriptor() {
        return IOServiceAddMatchingNotification.DESC;
    }

    public static MethodHandle IOServiceAddMatchingNotification$handle() {
        return IOServiceAddMatchingNotification.HANDLE;
    }

    public static int IOServiceAddMatchingNotification(MemorySegment notifyPort, MemorySegment notificationType, MemorySegment matching, MemorySegment callback2, MemorySegment refCon, MemorySegment notification) {
        MethodHandle mh$ = IOServiceAddMatchingNotification.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                IOKit.traceDowncall("IOServiceAddMatchingNotification", notifyPort, notificationType, matching, callback2, refCon, notification);
            }
            return mh$.invokeExact(notifyPort, notificationType, matching, callback2, refCon, notification);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor IORegistryEntryGetRegistryEntryID$descriptor() {
        return IORegistryEntryGetRegistryEntryID.DESC;
    }

    public static MethodHandle IORegistryEntryGetRegistryEntryID$handle() {
        return IORegistryEntryGetRegistryEntryID.HANDLE;
    }

    public static int IORegistryEntryGetRegistryEntryID(int entry, MemorySegment entryID) {
        MethodHandle mh$ = IORegistryEntryGetRegistryEntryID.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                IOKit.traceDowncall("IORegistryEntryGetRegistryEntryID", entry, entryID);
            }
            return mh$.invokeExact(entry, entryID);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor IORegistryEntryCreateCFProperty$descriptor() {
        return IORegistryEntryCreateCFProperty.DESC;
    }

    public static MethodHandle IORegistryEntryCreateCFProperty$handle() {
        return IORegistryEntryCreateCFProperty.HANDLE;
    }

    public static MemorySegment IORegistryEntryCreateCFProperty(int entry, MemorySegment key, MemorySegment allocator, int options) {
        MethodHandle mh$ = IORegistryEntryCreateCFProperty.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                IOKit.traceDowncall("IORegistryEntryCreateCFProperty", entry, key, allocator, options);
            }
            return mh$.invokeExact(entry, key, allocator, options);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor IOServiceMatching$descriptor() {
        return IOServiceMatching.DESC;
    }

    public static MethodHandle IOServiceMatching$handle() {
        return IOServiceMatching.HANDLE;
    }

    public static MemorySegment IOServiceMatching(MemorySegment name) {
        MethodHandle mh$ = IOServiceMatching.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                IOKit.traceDowncall("IOServiceMatching", name);
            }
            return mh$.invokeExact(name);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor IOCreatePlugInInterfaceForService$descriptor() {
        return IOCreatePlugInInterfaceForService.DESC;
    }

    public static MethodHandle IOCreatePlugInInterfaceForService$handle() {
        return IOCreatePlugInInterfaceForService.HANDLE;
    }

    public static int IOCreatePlugInInterfaceForService(int service, MemorySegment pluginType, MemorySegment interfaceType, MemorySegment theInterface, MemorySegment theScore) {
        MethodHandle mh$ = IOCreatePlugInInterfaceForService.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                IOKit.traceDowncall("IOCreatePlugInInterfaceForService", service, pluginType, interfaceType, theInterface, theScore);
            }
            return mh$.invokeExact(service, pluginType, interfaceType, theInterface, theScore);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static int kIOReturnExclusiveAccess() {
        return -536870203;
    }

    public static int kIOReturnAborted() {
        return -536870165;
    }

    public static int kIOUSBPipeStalled() {
        return -536854449;
    }

    public static int kIOUSBTransactionTimeout() {
        return -536854447;
    }

    public static MemorySegment kIOFirstMatchNotification() {
        class Holder {
            static final MemorySegment kIOFirstMatchNotification = LIBRARY_ARENA.allocateFrom("IOServiceFirstMatch");

            Holder() {
            }
        }
        return Holder.kIOFirstMatchNotification;
    }

    public static MemorySegment kIOTerminatedNotification() {
        class Holder {
            static final MemorySegment kIOTerminatedNotification = LIBRARY_ARENA.allocateFrom("IOServiceTerminate");

            Holder() {
            }
        }
        return Holder.kIOTerminatedNotification;
    }

    public static MemorySegment kIOUSBDeviceClassName() {
        class Holder {
            static final MemorySegment kIOUSBDeviceClassName = LIBRARY_ARENA.allocateFrom("IOUSBDevice");

            Holder() {
            }
        }
        return Holder.kIOUSBDeviceClassName;
    }

    private static class IONotificationPortCreate {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_INT);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(IOKit.findOrThrow("IONotificationPortCreate"), DESC, new Linker.Option[0]);

        private IONotificationPortCreate() {
        }
    }

    private static class IONotificationPortGetRunLoopSource {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(IOKit.findOrThrow("IONotificationPortGetRunLoopSource"), DESC, new Linker.Option[0]);

        private IONotificationPortGetRunLoopSource() {
        }
    }

    private static class IOObjectRelease {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_INT);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(IOKit.findOrThrow("IOObjectRelease"), DESC, new Linker.Option[0]);

        private IOObjectRelease() {
        }
    }

    private static class IOIteratorNext {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_INT);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(IOKit.findOrThrow("IOIteratorNext"), DESC, new Linker.Option[0]);

        private IOIteratorNext() {
        }
    }

    private static class IOServiceAddMatchingNotification {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER, C_POINTER, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(IOKit.findOrThrow("IOServiceAddMatchingNotification"), DESC, new Linker.Option[0]);

        private IOServiceAddMatchingNotification() {
        }
    }

    private static class IORegistryEntryGetRegistryEntryID {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_INT, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(IOKit.findOrThrow("IORegistryEntryGetRegistryEntryID"), DESC, new Linker.Option[0]);

        private IORegistryEntryGetRegistryEntryID() {
        }
    }

    private static class IORegistryEntryCreateCFProperty {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_INT, C_POINTER, C_POINTER, C_INT);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(IOKit.findOrThrow("IORegistryEntryCreateCFProperty"), DESC, new Linker.Option[0]);

        private IORegistryEntryCreateCFProperty() {
        }
    }

    private static class IOServiceMatching {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(IOKit.findOrThrow("IOServiceMatching"), DESC, new Linker.Option[0]);

        private IOServiceMatching() {
        }
    }

    private static class IOCreatePlugInInterfaceForService {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_INT, C_POINTER, C_POINTER, C_POINTER, C_POINTER);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(IOKit.findOrThrow("IOCreatePlugInInterfaceForService"), DESC, new Linker.Option[0]);

        private IOCreatePlugInInterfaceForService() {
        }
    }
}

