/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.usbstandard;

import java.lang.foreign.GroupLayout;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.charset.StandardCharsets;
import net.codecrete.usb.UsbException;

public class StringDescriptor {
    private final MemorySegment descriptor;
    public static final GroupLayout LAYOUT = MemoryLayout.structLayout(ValueLayout.JAVA_BYTE.withName("bLength"), ValueLayout.JAVA_BYTE.withName("bDescriptorType"), ValueLayout.JAVA_SHORT.withName("string"));
    private static final long bLength$OFFSET = 0L;
    private static final long bDescriptorType$OFFSET = 1L;
    private static final long string$OFFSET = 2L;

    public StringDescriptor(MemorySegment descriptor) {
        this.descriptor = descriptor;
    }

    public boolean isValid() {
        return this.descriptor.byteSize() >= 2L && this.descriptor.get(ValueLayout.JAVA_BYTE, 1L) == 3 && (long)this.length() == this.descriptor.byteSize() && (this.descriptor.byteSize() & 1L) == 0L;
    }

    public int length() {
        return 0xFF & this.descriptor.get(ValueLayout.JAVA_BYTE, 0L);
    }

    public String string() {
        int len;
        if (!this.isValid()) {
            throw new UsbException("String descriptor is invalid");
        }
        byte[] bytes = this.descriptor.asSlice(2L, len).toArray(ValueLayout.JAVA_BYTE);
        for (len = (int)((long)this.length() - 2L); len > 0 && bytes[len - 2] == 0 && bytes[len - 1] == 0; --len) {
        }
        return new String(bytes, 0, len, StandardCharsets.UTF_16LE);
    }
}

