/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.List;
import net.codecrete.usb.windows.gen.kernel32._GUID;

public class Win {
    public static final Linker.Option LAST_ERROR_STATE = Linker.Option.captureCallState("GetLastError");
    private static final StructLayout LAST_ERROR_STATE_LAYOUT = Linker.Option.captureStateLayout();
    private static final VarHandle callState_GetLastError$VH = LAST_ERROR_STATE_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("GetLastError"));

    private Win() {
    }

    static MemorySegment allocateErrorState(Arena arena) {
        return arena.allocate(LAST_ERROR_STATE_LAYOUT);
    }

    public static int getLastError(MemorySegment callState) {
        return callState_GetLastError$VH.get(callState, 0);
    }

    public static boolean isInvalidHandle(MemorySegment handle) {
        return handle.address() == -1L;
    }

    public static MemorySegment createSegmentFromString(String str, Arena arena) {
        MemorySegment segment = arena.allocate(ValueLayout.JAVA_CHAR, (long)str.length() + 1L);
        segment.copyFrom(MemorySegment.ofArray(str.toCharArray()));
        return segment;
    }

    public static String createStringFromSegment(MemorySegment segment) {
        int len = 0;
        while (segment.get(ValueLayout.JAVA_CHAR, (long)len) != '\u0000') {
            len += 2;
        }
        return new String(segment.asSlice(0L, len).toArray(ValueLayout.JAVA_CHAR));
    }

    public static List<String> createStringListFromSegment(MemorySegment segment) {
        ArrayList<String> stringList = new ArrayList<String>();
        int offset = 0;
        while (segment.get(ValueLayout.JAVA_CHAR, (long)offset) != '\u0000') {
            String str = Win.createStringFromSegment(segment.asSlice(offset));
            offset += str.length() * 2 + 2;
            stringList.add(str);
        }
        return stringList;
    }

    public static MemorySegment createGUID(int data1, short data2, short data3, byte data4_0, byte data4_1, byte data4_2, byte data4_3, byte data4_4, byte data4_5, byte data4_6, byte data4_7) {
        MemorySegment guid = Arena.global().allocate(_GUID.layout());
        Win.setGUID(guid, data1, data2, data3, data4_0, data4_1, data4_2, data4_3, data4_4, data4_5, data4_6, data4_7);
        return guid;
    }

    public static void setGUID(MemorySegment guid, int data1, short data2, short data3, byte data4_0, byte data4_1, byte data4_2, byte data4_3, byte data4_4, byte data4_5, byte data4_6, byte data4_7) {
        _GUID.Data1(guid, data1);
        _GUID.Data2(guid, data2);
        _GUID.Data3(guid, data3);
        MemorySegment data4 = _GUID.Data4(guid);
        data4.set(ValueLayout.JAVA_BYTE, 0L, data4_0);
        data4.set(ValueLayout.JAVA_BYTE, 1L, data4_1);
        data4.set(ValueLayout.JAVA_BYTE, 2L, data4_2);
        data4.set(ValueLayout.JAVA_BYTE, 3L, data4_3);
        data4.set(ValueLayout.JAVA_BYTE, 4L, data4_4);
        data4.set(ValueLayout.JAVA_BYTE, 5L, data4_5);
        data4.set(ValueLayout.JAVA_BYTE, 6L, data4_6);
        data4.set(ValueLayout.JAVA_BYTE, 7L, data4_7);
    }
}

