/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows.gen.user32;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.PaddingLayout;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class User32 {
    static final Arena LIBRARY_ARENA = Arena.ofAuto();
    static final boolean TRACE_DOWNCALLS = Boolean.getBoolean("jextract.trace.downcalls");
    static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.libraryLookup(System.mapLibraryName("User32"), LIBRARY_ARENA).or(SymbolLookup.loaderLookup()).or(Linker.nativeLinker().defaultLookup());
    public static final ValueLayout.OfBoolean C_BOOL = ValueLayout.JAVA_BOOLEAN;
    public static final ValueLayout.OfByte C_CHAR = ValueLayout.JAVA_BYTE;
    public static final ValueLayout.OfShort C_SHORT = ValueLayout.JAVA_SHORT;
    public static final ValueLayout.OfInt C_INT = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfLong C_LONG_LONG = ValueLayout.JAVA_LONG;
    public static final ValueLayout.OfFloat C_FLOAT = ValueLayout.JAVA_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE = ValueLayout.JAVA_DOUBLE;
    public static final AddressLayout C_POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
    public static final ValueLayout.OfInt C_LONG = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfDouble C_LONG_DOUBLE = ValueLayout.JAVA_DOUBLE;
    private static final int WM_DEVICECHANGE = 537;
    private static final int DEVICE_NOTIFY_WINDOW_HANDLE = 0;
    private static final int DBT_DEVICEARRIVAL = 32768;
    private static final int DBT_DEVICEREMOVECOMPLETE = 32772;
    private static final int DBT_DEVTYP_DEVICEINTERFACE = 5;
    private static final MemorySegment HWND_MESSAGE = MemorySegment.ofAddress(-3L);

    User32() {
    }

    static void traceDowncall(String name, Object ... args) {
        String traceArgs = Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", "));
        System.out.printf("%s(%s)\n", name, traceArgs);
    }

    static MemorySegment findOrThrow(String symbol) {
        return SYMBOL_LOOKUP.find(symbol).orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + symbol));
    }

    static MethodHandle upcallHandle(Class<?> fi, String name, FunctionDescriptor fdesc) {
        try {
            return MethodHandles.lookup().findVirtual(fi, name, fdesc.toMethodType());
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static MemoryLayout align(MemoryLayout layout, long align) {
        MemoryLayout memoryLayout = layout;
        Objects.requireNonNull(memoryLayout);
        MemoryLayout memoryLayout2 = memoryLayout;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PaddingLayout.class, ValueLayout.class, GroupLayout.class, SequenceLayout.class}, (Object)memoryLayout2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PaddingLayout p;
                yield p = (PaddingLayout)memoryLayout2;
            }
            case 1 -> {
                ValueLayout v = (ValueLayout)memoryLayout2;
                yield v.withByteAlignment(align);
            }
            case 2 -> {
                GroupLayout g = (GroupLayout)memoryLayout2;
                MemoryLayout[] alignedMembers = (MemoryLayout[])g.memberLayouts().stream().map(m -> User32.align(m, align)).toArray(MemoryLayout[]::new);
                if (g instanceof StructLayout) {
                    yield MemoryLayout.structLayout(alignedMembers);
                }
                yield MemoryLayout.unionLayout(alignedMembers);
            }
            case 3 -> {
                SequenceLayout s = (SequenceLayout)memoryLayout2;
                yield MemoryLayout.sequenceLayout(s.elementCount(), User32.align(s.elementLayout(), align));
            }
        };
    }

    public static int WM_DEVICECHANGE() {
        return 537;
    }

    public static int DEVICE_NOTIFY_WINDOW_HANDLE() {
        return 0;
    }

    public static int DBT_DEVICEARRIVAL() {
        return 32768;
    }

    public static int DBT_DEVICEREMOVECOMPLETE() {
        return 32772;
    }

    public static int DBT_DEVTYP_DEVICEINTERFACE() {
        return 5;
    }

    public static FunctionDescriptor DefWindowProcW$descriptor() {
        return DefWindowProcW.DESC;
    }

    public static MethodHandle DefWindowProcW$handle() {
        return DefWindowProcW.HANDLE;
    }

    public static long DefWindowProcW(MemorySegment hWnd, int Msg, long wParam, long lParam) {
        MethodHandle mh$ = DefWindowProcW.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                User32.traceDowncall("DefWindowProcW", hWnd, Msg, wParam, lParam);
            }
            return mh$.invokeExact(hWnd, Msg, wParam, lParam);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MemorySegment HWND_MESSAGE() {
        return HWND_MESSAGE;
    }

    private static class DefWindowProcW {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG_LONG, C_POINTER, C_INT, C_LONG_LONG, C_LONG_LONG);
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(User32.findOrThrow("DefWindowProcW"), DESC, new Linker.Option[0]);

        private DefWindowProcW() {
        }
    }
}

