/*
 * #%L
 * OME-XML Java library for working with OME-XML metadata structures.
 * %%
 * Copyright (C) 2006 - 2016 Open Microscopy Environment:
 *   - Massachusetts Institute of Technology
 *   - National Institutes of Health
 *   - University of Dundee
 *   - Board of Regents of the University of Wisconsin-Madison
 *   - Glencoe Software, Inc.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of any organization.
 * #L%
 */

/*-----------------------------------------------------------------------------
 *
 * THIS IS AUTOMATICALLY GENERATED CODE.  DO NOT MODIFY.
 *
 *-----------------------------------------------------------------------------
 */

package ome.xml.model;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ome.units.quantity.Angle;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.units.quantity.Power;
import ome.units.quantity.Pressure;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.units.unit.Unit;

import ome.xml.model.enums.*;
import ome.xml.model.enums.handlers.*;
import ome.xml.model.primitives.*;

public class Folder extends AbstractOMEModelObject
{
  // Base:  -- Name: Folder -- Type: Folder -- modelBaseType: AbstractOMEModelObject -- langBaseType: Object

  // -- Constants --

  public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";

  /** Logger for this class. */
  private static final Logger LOGGER =
    LoggerFactory.getLogger(Folder.class);

  // -- Instance variables --

  // ID property
  private String id;

  // Name property
  private String name;

  // Description property
  private String description;

  // FolderRef reference (occurs more than once)
  private List<Folder> folders = new ReferenceList<Folder>();

  // ImageRef reference (occurs more than once)
  private List<Image> imageLinks = new ReferenceList<Image>();

  // ROIRef reference (occurs more than once)
  private List<ROI> roiLinks = new ReferenceList<ROI>();

  // AnnotationRef reference (occurs more than once)
  private List<Annotation> annotationLinks = new ReferenceList<Annotation>();

  // Folder_BackReference back reference (occurs more than once)
  private List<Folder> folder = new ReferenceList<Folder>();

  // -- Constructors --

  /** Default constructor. */
  public Folder()
  {
  }



  /**
   * Constructs Folder recursively from an XML DOM tree.
   * @param element Root of the XML DOM tree to construct a model object
   * graph from.
   * @param model Handler for the OME model which keeps track of instances
   * and references seen during object population.
   * @throws EnumerationException If there is an error instantiating an
   * enumeration during model object creation.
   */
  public Folder(Element element, OMEModel model)
    throws EnumerationException
  {
    update(element, model);
  }

  /** Copy constructor. */
  public Folder(Folder orig)
  {
    id = orig.id;
    name = orig.name;
    description = orig.description;
    folders = orig.folders;
    imageLinks = orig.imageLinks;
    roiLinks = orig.roiLinks;
    annotationLinks = orig.annotationLinks;
    folder = orig.folder;
  }

  // -- Custom content from Folder specific template --


  // -- OMEModelObject API methods --

  /**
   * Updates Folder recursively from an XML DOM tree. <b>NOTE:</b> No
   * properties are removed, only added or updated.
   * @param element Root of the XML DOM tree to construct a model object
   * graph from.
   * @param model Handler for the OME model which keeps track of instances
   * and references seen during object population.
   * @throws EnumerationException If there is an error instantiating an
   * enumeration during model object creation.
   */
  public void update(Element element, OMEModel model)
    throws EnumerationException
  {
    super.update(element, model);
    String tagName = element.getTagName();
    if (!element.hasAttribute("ID") && getID() == null)
    {
      // TODO: Should be its own exception
      throw new RuntimeException(String.format(
        "Folder missing required ID property."));
    }
    if (element.hasAttribute("ID"))
    {
      // ID property
      setID(String.valueOf(
        element.getAttribute("ID")));
      // Adding this model object to the model handler
      model.addModelObject(getID(), this);
    }
    if (element.hasAttribute("Name"))
    {
      // Attribute property Name
      setName(String.valueOf(
        element.getAttribute("Name")));
    }
    List<Element> Description_nodeList =
      getChildrenByTagName(element, "Description");
    if (Description_nodeList.size() > 1)
    {
      // TODO: Should be its own Exception
      throw new RuntimeException(String.format(
        "Description node list size %d != 1",
        Description_nodeList.size()));
    }
    else if (Description_nodeList.size() != 0)
    {
      // Element property Description which is not complex (has no
      // sub-elements)
      setDescription(
        String.valueOf(Description_nodeList.get(0).getTextContent()));
    }
    // Element reference FolderRef
    List<Element> FolderRef_nodeList =
      getChildrenByTagName(element, "FolderRef");
    for (Element FolderRef_element : FolderRef_nodeList)
    {
      FolderRef folders_reference = new FolderRef();
      folders_reference.setID(FolderRef_element.getAttribute("ID"));
      model.addReference(this, folders_reference);
    }
    // Element reference ImageRef
    List<Element> ImageRef_nodeList =
      getChildrenByTagName(element, "ImageRef");
    for (Element ImageRef_element : ImageRef_nodeList)
    {
      ImageRef imageLinks_reference = new ImageRef();
      imageLinks_reference.setID(ImageRef_element.getAttribute("ID"));
      model.addReference(this, imageLinks_reference);
    }
    // Element reference ROIRef
    List<Element> ROIRef_nodeList =
      getChildrenByTagName(element, "ROIRef");
    for (Element ROIRef_element : ROIRef_nodeList)
    {
      ROIRef roiLinks_reference = new ROIRef();
      roiLinks_reference.setID(ROIRef_element.getAttribute("ID"));
      model.addReference(this, roiLinks_reference);
    }
    // Element reference AnnotationRef
    List<Element> AnnotationRef_nodeList =
      getChildrenByTagName(element, "AnnotationRef");
    for (Element AnnotationRef_element : AnnotationRef_nodeList)
    {
      AnnotationRef annotationLinks_reference = new AnnotationRef();
      annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
      model.addReference(this, annotationLinks_reference);
    }
  }

  // -- Folder API methods --

  public boolean link(Reference reference, OMEModelObject o)
  {
    if (reference instanceof FolderRef)
    {
      Folder o_casted = (Folder) o;
      folders.add(o_casted);
      return true;
    }
    if (reference instanceof ImageRef)
    {
      Image o_casted = (Image) o;
      o_casted.linkFolder(this);
      imageLinks.add(o_casted);
      return true;
    }
    if (reference instanceof ROIRef)
    {
      ROI o_casted = (ROI) o;
      o_casted.linkFolder(this);
      roiLinks.add(o_casted);
      return true;
    }
    if (reference instanceof AnnotationRef)
    {
      Annotation o_casted = (Annotation) o;
      o_casted.linkFolder(this);
      annotationLinks.add(o_casted);
      return true;
    }
    return super.link(reference, o);
  }

  // Property ID
  public String getID()
  {
    return id;
  }

  public void setID(String id)
  {
    this.id = id;
  }

  // Property Name
  public String getName()
  {
    return name;
  }

  public void setName(String name)
  {
    this.name = name;
  }

  // Property Description
  public String getDescription()
  {
    return description;
  }

  public void setDescription(String description)
  {
    this.description = description;
  }

  // Reference which occurs more than once
  public int sizeOfLinkedFolderList()
  {
    return folders.size();
  }

  public List<Folder> copyLinkedFolderList()
  {
    return new ArrayList<Folder>(folders);
  }

  public Folder getLinkedFolder(int index)
  {
    return folders.get(index);
  }

  public Folder setLinkedFolder(int index, Folder o)
  {
    return folders.set(index, o);
  }

  public boolean linkFolder(Folder o)
  {
    return folders.add(o);
  }

  public boolean unlinkFolder(Folder o)
  {
    return folders.remove(o);
  }

  // Reference which occurs more than once
  public int sizeOfLinkedImageList()
  {
    return imageLinks.size();
  }

  public List<Image> copyLinkedImageList()
  {
    return new ArrayList<Image>(imageLinks);
  }

  public Image getLinkedImage(int index)
  {
    return imageLinks.get(index);
  }

  public Image setLinkedImage(int index, Image o)
  {
    return imageLinks.set(index, o);
  }

  public boolean linkImage(Image o)
  {

    o.linkFolder(this);
    return imageLinks.add(o);
  }

  public boolean unlinkImage(Image o)
  {

    o.unlinkFolder(this);
    return imageLinks.remove(o);
  }

  // Reference which occurs more than once
  public int sizeOfLinkedROIList()
  {
    return roiLinks.size();
  }

  public List<ROI> copyLinkedROIList()
  {
    return new ArrayList<ROI>(roiLinks);
  }

  public ROI getLinkedROI(int index)
  {
    return roiLinks.get(index);
  }

  public ROI setLinkedROI(int index, ROI o)
  {
    return roiLinks.set(index, o);
  }

  public boolean linkROI(ROI o)
  {

    o.linkFolder(this);
    return roiLinks.add(o);
  }

  public boolean unlinkROI(ROI o)
  {

    o.unlinkFolder(this);
    return roiLinks.remove(o);
  }

  // Reference which occurs more than once
  public int sizeOfLinkedAnnotationList()
  {
    return annotationLinks.size();
  }

  public List<Annotation> copyLinkedAnnotationList()
  {
    return new ArrayList<Annotation>(annotationLinks);
  }

  public Annotation getLinkedAnnotation(int index)
  {
    return annotationLinks.get(index);
  }

  public Annotation setLinkedAnnotation(int index, Annotation o)
  {
    return annotationLinks.set(index, o);
  }

  public boolean linkAnnotation(Annotation o)
  {

    o.linkFolder(this);
    return annotationLinks.add(o);
  }

  public boolean unlinkAnnotation(Annotation o)
  {

    o.unlinkFolder(this);
    return annotationLinks.remove(o);
  }

  // Reference which occurs more than once
  public int sizeOfLinkedChildFolderList()
  {
    return folder.size();
  }

  public List<Folder> copyLinkedChildFolderList()
  {
    return new ArrayList<Folder>(folder);
  }

  public Folder getLinkedChildFolder(int index)
  {
    return folder.get(index);
  }

  public Folder setLinkedChildFolder(int index, Folder o)
  {
    return folder.set(index, o);
  }

  public boolean linkChildFolder(Folder o)
  {
    return folder.add(o);
  }

  public boolean unlinkChildFolder(Folder o)
  {
    return folder.remove(o);
  }

  public Element asXMLElement(Document document)
  {
    return asXMLElement(document, null);
  }

  public Element asXMLElement(Document document, Element Folder_element)
  {
    // Creating XML block for Folder
    if (Folder_element == null)
    {
      Folder_element =
        document.createElementNS(NAMESPACE, "Folder");
    }

    // Ensure any base annotations add their Elements first
    super.asXMLElement(document, Folder_element);

    if (id != null)
    {
      // Attribute property ID
      Folder_element.setAttribute("ID", id.toString());
    }
    if (name != null)
    {
      // Attribute property Name
      Folder_element.setAttribute("Name", name.toString());
    }
    if (description != null)
    {
    // Element property Description which is not complex (has no
    // sub-elements)
    Element description_element =
      document.createElementNS(NAMESPACE, "Description");
      description_element.setTextContent(description.toString());
      Folder_element.appendChild(description_element);
    }
    if (folders != null)
    {
      // Reference property FolderRef which occurs more than once
      for (Folder folders_value : folders)
      {
        FolderRef o = new FolderRef();
        o.setID(folders_value.getID());
        Element child =
          document.createElementNS(NAMESPACE, "FolderRef");
        o.asXMLElement(document, child);
        Folder_element.appendChild(child);
      }
    }
    if (imageLinks != null)
    {
      // Reference property ImageRef which occurs more than once
      for (Image imageLinks_value : imageLinks)
      {
        ImageRef o = new ImageRef();
        o.setID(imageLinks_value.getID());
        Element child =
          document.createElementNS(NAMESPACE, "ImageRef");
        o.asXMLElement(document, child);
        Folder_element.appendChild(child);
      }
    }
    if (roiLinks != null)
    {
      // Reference property ROIRef which occurs more than once
      for (ROI roiLinks_value : roiLinks)
      {
        ROIRef o = new ROIRef();
        o.setID(roiLinks_value.getID());
        Element child =
          document.createElementNS(NAMESPACE, "ROIRef");
        o.asXMLElement(document, child);
        Folder_element.appendChild(child);
      }
    }
    if (annotationLinks != null)
    {
      // Reference property AnnotationRef which occurs more than once
      for (Annotation annotationLinks_value : annotationLinks)
      {
        AnnotationRef o = new AnnotationRef();
        o.setID(annotationLinks_value.getID());
        Element child =
          document.createElementNS(NAMESPACE, "AnnotationRef");
        o.asXMLElement(document, child);
        Folder_element.appendChild(child);
      }
    }
    if (folder != null)
    {
      // *** IGNORING *** Skipped back reference Folder_BackReference
    }

    return Folder_element;
  }
}
