/*
 * #%L
 * OME-XML Java library for working with OME-XML metadata structures.
 * %%
 * Copyright (C) 2006 - 2016 Open Microscopy Environment:
 *   - Massachusetts Institute of Technology
 *   - National Institutes of Health
 *   - University of Dundee
 *   - Board of Regents of the University of Wisconsin-Madison
 *   - Glencoe Software, Inc.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of any organization.
 * #L%
 */

/*-----------------------------------------------------------------------------
 *
 * THIS IS AUTOMATICALLY GENERATED CODE.  DO NOT MODIFY.
 *
 *-----------------------------------------------------------------------------
 */

package ome.xml.model;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ome.units.quantity.Angle;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.units.quantity.Power;
import ome.units.quantity.Pressure;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.units.unit.Unit;

import ome.xml.model.enums.*;
import ome.xml.model.enums.handlers.*;
import ome.xml.model.primitives.*;

public class Union extends AbstractOMEModelObject
{
  // Base:  -- Name: Union -- Type: Union -- modelBaseType: AbstractOMEModelObject -- langBaseType: Object

  // -- Constants --

  public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";

  /** Logger for this class. */
  private static final Logger LOGGER =
    LoggerFactory.getLogger(Union.class);

  // -- Instance variables --

  // Shape property (occurs more than once)
  private List<Shape> shapes = new ArrayList<Shape>();

  // -- Constructors --

  /** Default constructor. */
  public Union()
  {
  }



  /**
   * Constructs Union recursively from an XML DOM tree.
   * @param element Root of the XML DOM tree to construct a model object
   * graph from.
   * @param model Handler for the OME model which keeps track of instances
   * and references seen during object population.
   * @throws EnumerationException If there is an error instantiating an
   * enumeration during model object creation.
   */
  public Union(Element element, OMEModel model)
    throws EnumerationException
  {
    update(element, model);
  }

  /** Copy constructor. */
  public Union(Union orig)
  {
    shapes = orig.shapes;
  }

  // -- Custom content from Union specific template --


  // -- OMEModelObject API methods --

  /**
   * Updates Union recursively from an XML DOM tree. <b>NOTE:</b> No
   * properties are removed, only added or updated.
   * @param element Root of the XML DOM tree to construct a model object
   * graph from.
   * @param model Handler for the OME model which keeps track of instances
   * and references seen during object population.
   * @throws EnumerationException If there is an error instantiating an
   * enumeration during model object creation.
   */
  public void update(Element element, OMEModel model)
    throws EnumerationException
  {
    super.update(element, model);
    String tagName = element.getTagName();
    // Element property Shape which is complex (has
    // sub-elements) and occurs more than once. The element's model
    // object type is also abstract so we need to have a handler for
    // each "subclass".
    List<Element> Ellipse_nodeList =
      getChildrenByTagName(element, "Ellipse");
    for (Element Ellipse_element : Ellipse_nodeList)
    {
      addShape(
      new Ellipse(Ellipse_element, model));
    }
    List<Element> Label_nodeList =
      getChildrenByTagName(element, "Label");
    for (Element Label_element : Label_nodeList)
    {
      addShape(
      new Label(Label_element, model));
    }
    List<Element> Line_nodeList =
      getChildrenByTagName(element, "Line");
    for (Element Line_element : Line_nodeList)
    {
      addShape(
      new Line(Line_element, model));
    }
    List<Element> Mask_nodeList =
      getChildrenByTagName(element, "Mask");
    for (Element Mask_element : Mask_nodeList)
    {
      addShape(
      new Mask(Mask_element, model));
    }
    List<Element> Point_nodeList =
      getChildrenByTagName(element, "Point");
    for (Element Point_element : Point_nodeList)
    {
      addShape(
      new Point(Point_element, model));
    }
    List<Element> Polygon_nodeList =
      getChildrenByTagName(element, "Polygon");
    for (Element Polygon_element : Polygon_nodeList)
    {
      addShape(
      new Polygon(Polygon_element, model));
    }
    List<Element> Polyline_nodeList =
      getChildrenByTagName(element, "Polyline");
    for (Element Polyline_element : Polyline_nodeList)
    {
      addShape(
      new Polyline(Polyline_element, model));
    }
    List<Element> Rectangle_nodeList =
      getChildrenByTagName(element, "Rectangle");
    for (Element Rectangle_element : Rectangle_nodeList)
    {
      addShape(
      new Rectangle(Rectangle_element, model));
    }
  }

  // -- Union API methods --

  public boolean link(Reference reference, OMEModelObject o)
  {
    return super.link(reference, o);
  }

  // Property which occurs more than once
  public int sizeOfShapeList()
  {
    return shapes.size();
  }

  public List<Shape> copyShapeList()
  {
    return new ArrayList<Shape>(shapes);
  }

  public Shape getShape(int index)
  {
    return shapes.get(index);
  }

  public Shape setShape(int index, Shape shape)
  {
    shape.setUnion(this);
    return shapes.set(index, shape);
  }

  public void addShape(Shape shape)
  {
    shape.setUnion(this);
    shapes.add(shape);
  }

  public void removeShape(Shape shape)
  {
    shapes.remove(shape);
  }

  public Element asXMLElement(Document document)
  {
    return asXMLElement(document, null);
  }

  public Element asXMLElement(Document document, Element Union_element)
  {
    // Creating XML block for Union
    if (Union_element == null)
    {
      Union_element =
        document.createElementNS(NAMESPACE, "Union");
    }

    // Ensure any base annotations add their Elements first
    super.asXMLElement(document, Union_element);

    if (shapes != null)
    {
      // Element property Shape which is complex (has
      // sub-elements) and occurs more than once
      for (Shape shapes_value : shapes)
      {
        Element child =
          document.createElementNS(NAMESPACE, shapes_value.getClass().getSimpleName());
        shapes_value.asXMLElement(document, child);
        Union_element.appendChild(child);
      }
    }

    return Union_element;
  }
}
