/*
 * #%L
 * OME-XML Java library for working with OME-XML metadata structures.
 * %%
 * Copyright (C) 2006 - 2016 Open Microscopy Environment:
 *   - Massachusetts Institute of Technology
 *   - National Institutes of Health
 *   - University of Dundee
 *   - Board of Regents of the University of Wisconsin-Madison
 *   - Glencoe Software, Inc.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of any organization.
 * #L%
 */

/*-----------------------------------------------------------------------------
 *
 * THIS IS AUTOMATICALLY GENERATED CODE.  DO NOT MODIFY.
 *
 *-----------------------------------------------------------------------------
 */

package ome.xml.model.enums;


import ome.units.quantity.Angle;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.units.quantity.Power;
import ome.units.quantity.Pressure;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.units.unit.Unit;

import ome.xml.model.enums.handlers.PixelTypeEnumHandler;
import ome.xml.model.primitives.*;

public enum PixelType implements Enumeration
{
  /** 8 bit signed integer. */
  INT8("int8"),
  /** 16 bit signed integer. */
  INT16("int16"),
  /** 32 bit signed integer. */
  INT32("int32"),
  /** 8 bit unsigned integer. */
  UINT8("uint8"),
  /** 16 bit unsigned integer. */
  UINT16("uint16"),
  /** 32 bit unsigned integer. */
  UINT32("uint32"),
  /** single-precision floating point. */
  FLOAT("float"),
  /** double-precision floating point. */
  DOUBLE("double"),
  /** complex single-precision floating point. */
  COMPLEXFLOAT("complex"),
  /** complex double-precision floating point. */
  COMPLEXDOUBLE("double-complex"),
  /** bit mask. */
  BIT("bit");

  private PixelType(String value)
  {
    this.value = value;
  }

  public static PixelType fromString(String value)
    throws EnumerationException
  {
    if ("int8".equals(value))
    {
      return INT8;
    }
    if ("int16".equals(value))
    {
      return INT16;
    }
    if ("int32".equals(value))
    {
      return INT32;
    }
    if ("uint8".equals(value))
    {
      return UINT8;
    }
    if ("uint16".equals(value))
    {
      return UINT16;
    }
    if ("uint32".equals(value))
    {
      return UINT32;
    }
    if ("float".equals(value))
    {
      return FLOAT;
    }
    if ("double".equals(value))
    {
      return DOUBLE;
    }
    if ("complex".equals(value))
    {
      return COMPLEXFLOAT;
    }
    if ("double-complex".equals(value))
    {
      return COMPLEXDOUBLE;
    }
    if ("bit".equals(value))
    {
      return BIT;
    }

    String s = String.format("'%s' not a supported value of '%s'",
                             value, PixelType.class);
    throw new EnumerationException(s);
  }

  public String getValue()
  {
    return value;
  }

  @Override
  public String toString()
  {
    return value;
  }

  private final String value;
}
