/*
 * #%L
 * OME-XML Java library for working with OME-XML metadata structures.
 * %%
 * Copyright (C) 2006 - 2016 Open Microscopy Environment:
 *   - Massachusetts Institute of Technology
 *   - National Institutes of Health
 *   - University of Dundee
 *   - Board of Regents of the University of Wisconsin-Madison
 *   - Glencoe Software, Inc.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of any organization.
 * #L%
 */

/*-----------------------------------------------------------------------------
 *
 * THIS IS AUTOMATICALLY GENERATED CODE.  DO NOT MODIFY.
 *
 *-----------------------------------------------------------------------------
 */

package ome.xml.model.enums;


import ome.units.quantity.Angle;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.units.quantity.Power;
import ome.units.quantity.Pressure;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.units.unit.Unit;

import ome.xml.model.enums.handlers.UnitsElectricPotentialEnumHandler;
import ome.xml.model.primitives.*;

public enum UnitsElectricPotential implements Enumeration
{
  /** yottavolt unit. */
  YOTTAVOLT("YV"),
  /** zettavolt unit. */
  ZETTAVOLT("ZV"),
  /** exavolt unit. */
  EXAVOLT("EV"),
  /** petavolt unit. */
  PETAVOLT("PV"),
  /** teravolt unit. */
  TERAVOLT("TV"),
  /** gigavolt unit. */
  GIGAVOLT("GV"),
  /** megavolt unit. */
  MEGAVOLT("MV"),
  /** kilovolt unit. */
  KILOVOLT("kV"),
  /** hectovolt unit. */
  HECTOVOLT("hV"),
  /** decavolt unit. */
  DECAVOLT("daV"),
  /** volt unit. */
  VOLT("V"),
  /** decivolt unit. */
  DECIVOLT("dV"),
  /** centivolt unit. */
  CENTIVOLT("cV"),
  /** millivolt unit. */
  MILLIVOLT("mV"),
  /** microvolt unit. */
  MICROVOLT("µV"),
  /** nanovolt unit. */
  NANOVOLT("nV"),
  /** picovolt unit. */
  PICOVOLT("pV"),
  /** femtovolt unit. */
  FEMTOVOLT("fV"),
  /** attovolt unit. */
  ATTOVOLT("aV"),
  /** zeptovolt unit. */
  ZEPTOVOLT("zV"),
  /** yoctovolt unit. */
  YOCTOVOLT("yV");

  private UnitsElectricPotential(String value)
  {
    this.value = value;
  }

  public static UnitsElectricPotential fromString(String value)
    throws EnumerationException
  {
    if ("YV".equals(value))
    {
      return YOTTAVOLT;
    }
    if ("ZV".equals(value))
    {
      return ZETTAVOLT;
    }
    if ("EV".equals(value))
    {
      return EXAVOLT;
    }
    if ("PV".equals(value))
    {
      return PETAVOLT;
    }
    if ("TV".equals(value))
    {
      return TERAVOLT;
    }
    if ("GV".equals(value))
    {
      return GIGAVOLT;
    }
    if ("MV".equals(value))
    {
      return MEGAVOLT;
    }
    if ("kV".equals(value))
    {
      return KILOVOLT;
    }
    if ("hV".equals(value))
    {
      return HECTOVOLT;
    }
    if ("daV".equals(value))
    {
      return DECAVOLT;
    }
    if ("V".equals(value))
    {
      return VOLT;
    }
    if ("dV".equals(value))
    {
      return DECIVOLT;
    }
    if ("cV".equals(value))
    {
      return CENTIVOLT;
    }
    if ("mV".equals(value))
    {
      return MILLIVOLT;
    }
    if ("µV".equals(value))
    {
      return MICROVOLT;
    }
    if ("nV".equals(value))
    {
      return NANOVOLT;
    }
    if ("pV".equals(value))
    {
      return PICOVOLT;
    }
    if ("fV".equals(value))
    {
      return FEMTOVOLT;
    }
    if ("aV".equals(value))
    {
      return ATTOVOLT;
    }
    if ("zV".equals(value))
    {
      return ZEPTOVOLT;
    }
    if ("yV".equals(value))
    {
      return YOCTOVOLT;
    }

    String s = String.format("'%s' not a supported value of '%s'",
                             value, UnitsElectricPotential.class);
    throw new EnumerationException(s);
  }

  public String getValue()
  {
    return value;
  }

  @Override
  public String toString()
  {
    return value;
  }

  public static <T extends PrimitiveNumber> ElectricPotential create(T newValue, UnitsElectricPotential newUnit)
  {
    ElectricPotential theQuantity = null;

    try
    {
      theQuantity = UnitsElectricPotentialEnumHandler.getQuantity(newValue, newUnit);
    }
    finally
    {
      return theQuantity;
    }
  }

  public static <T extends Number> ElectricPotential create(T newValue, UnitsElectricPotential newUnit)
  {
    ElectricPotential theQuantity = null;

    try
    {
      theQuantity = UnitsElectricPotentialEnumHandler.getQuantity(newValue, newUnit);
    }
    finally
    {
      return theQuantity;
    }
  }

  private final String value;
}
