/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterGroup;
import ome.xml.model.ExperimenterGroupRef;
import ome.xml.model.ExperimenterRef;
import ome.xml.model.Image;
import ome.xml.model.ImageRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Project;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Dataset
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Dataset.class);
    private String name;
    private String id;
    private String description;
    private Experimenter experimenter;
    private ExperimenterGroup experimenterGroup;
    private List<Image> imageLinks = new ReferenceList<Image>();
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private List<Project> projectLinks = new ReferenceList<Project>();

    public Dataset() {
    }

    public Dataset(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Dataset(Dataset orig) {
        this.name = orig.name;
        this.id = orig.id;
        this.description = orig.description;
        this.experimenter = orig.experimenter;
        this.experimenterGroup = orig.experimenterGroup;
        this.imageLinks = orig.imageLinks;
        this.annotationLinks = orig.annotationLinks;
        this.projectLinks = orig.projectLinks;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Dataset missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if ((Description_nodeList = Dataset.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> ExperimenterRef_nodeList = Dataset.getChildrenByTagName(element, "ExperimenterRef");
        for (Element element2 : ExperimenterRef_nodeList) {
            ExperimenterRef experimenterRef = new ExperimenterRef();
            experimenterRef.setID(element2.getAttribute("ID"));
            model.addReference(this, experimenterRef);
        }
        List<Element> ExperimenterGroupRef_nodeList = Dataset.getChildrenByTagName(element, "ExperimenterGroupRef");
        for (Element element3 : ExperimenterGroupRef_nodeList) {
            ExperimenterGroupRef experimenterGroup_reference = new ExperimenterGroupRef();
            experimenterGroup_reference.setID(element3.getAttribute("ID"));
            model.addReference(this, experimenterGroup_reference);
        }
        List<Element> list = Dataset.getChildrenByTagName(element, "ImageRef");
        for (Element ImageRef_element : list) {
            ImageRef imageLinks_reference = new ImageRef();
            imageLinks_reference.setID(ImageRef_element.getAttribute("ID"));
            model.addReference(this, imageLinks_reference);
        }
        List<Element> list2 = Dataset.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : list2) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        if (reference instanceof ExperimenterRef) {
            Experimenter o_casted = (Experimenter)o;
            o_casted.linkDataset(this);
            this.experimenter = o_casted;
            return true;
        }
        if (reference instanceof ExperimenterGroupRef) {
            ExperimenterGroup o_casted = (ExperimenterGroup)o;
            o_casted.linkDataset(this);
            this.experimenterGroup = o_casted;
            return true;
        }
        if (reference instanceof ImageRef) {
            Image o_casted = (Image)o;
            o_casted.linkDataset(this);
            this.imageLinks.add(o_casted);
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkDataset(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        return super.link(reference, o);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Experimenter getLinkedExperimenter() {
        return this.experimenter;
    }

    public void linkExperimenter(Experimenter o) {
        this.experimenter = o;
    }

    public void unlinkExperimenter(Experimenter o) {
        if (this.experimenter == o) {
            this.experimenter = null;
        }
    }

    public ExperimenterGroup getLinkedExperimenterGroup() {
        return this.experimenterGroup;
    }

    public void linkExperimenterGroup(ExperimenterGroup o) {
        this.experimenterGroup = o;
    }

    public void unlinkExperimenterGroup(ExperimenterGroup o) {
        if (this.experimenterGroup == o) {
            this.experimenterGroup = null;
        }
    }

    public int sizeOfLinkedImageList() {
        return this.imageLinks.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.imageLinks);
    }

    public Image getLinkedImage(int index) {
        return this.imageLinks.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.imageLinks.set(index, o);
    }

    public boolean linkImage(Image o) {
        o.linkDataset(this);
        return this.imageLinks.add(o);
    }

    public boolean unlinkImage(Image o) {
        o.unlinkDataset(this);
        return this.imageLinks.remove(o);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkDataset(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkDataset(this);
        return this.annotationLinks.remove(o);
    }

    public int sizeOfLinkedProjectList() {
        return this.projectLinks.size();
    }

    public List<Project> copyLinkedProjectList() {
        return new ArrayList<Project>(this.projectLinks);
    }

    public Project getLinkedProject(int index) {
        return this.projectLinks.get(index);
    }

    public Project setLinkedProject(int index, Project o) {
        return this.projectLinks.set(index, o);
    }

    public boolean linkProject(Project o) {
        return this.projectLinks.add(o);
    }

    public boolean unlinkProject(Project o) {
        return this.projectLinks.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Dataset_element) {
        Element child;
        Reference o;
        Element child2;
        Reference o2;
        if (Dataset_element == null) {
            Dataset_element = document.createElementNS(NAMESPACE, "Dataset");
        }
        super.asXMLElement(document, Dataset_element);
        if (this.name != null) {
            Dataset_element.setAttribute("Name", this.name.toString());
        }
        if (this.id != null) {
            Dataset_element.setAttribute("ID", this.id.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            Dataset_element.appendChild(description_element);
        }
        if (this.experimenter != null) {
            o2 = new ExperimenterRef();
            ((ExperimenterRef)o2).setID(this.experimenter.getID());
            child2 = document.createElementNS(NAMESPACE, "ExperimenterRef");
            ((ExperimenterRef)o2).asXMLElement(document, child2);
            Dataset_element.appendChild(child2);
        }
        if (this.experimenterGroup != null) {
            o2 = new ExperimenterGroupRef();
            ((ExperimenterGroupRef)o2).setID(this.experimenterGroup.getID());
            child2 = document.createElementNS(NAMESPACE, "ExperimenterGroupRef");
            ((ExperimenterGroupRef)o2).asXMLElement(document, child2);
            Dataset_element.appendChild(child2);
        }
        if (this.imageLinks != null) {
            for (Image imageLinks_value : this.imageLinks) {
                o = new ImageRef();
                ((ImageRef)o).setID(imageLinks_value.getID());
                child = document.createElementNS(NAMESPACE, "ImageRef");
                ((ImageRef)o).asXMLElement(document, child);
                Dataset_element.appendChild(child);
            }
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                o = new AnnotationRef();
                ((AnnotationRef)o).setID(annotationLinks_value.getID());
                child = document.createElementNS(NAMESPACE, "AnnotationRef");
                ((AnnotationRef)o).asXMLElement(document, child);
                Dataset_element.appendChild(child);
            }
        }
        if (this.projectLinks != null) {
            // empty if block
        }
        return Dataset_element;
    }
}

