/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.units.quantity.ElectricPotential;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Instrument;
import ome.xml.model.ManufacturerSpec;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsElectricPotential;
import ome.xml.model.enums.handlers.UnitsElectricPotentialEnumHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Detector
extends ManufacturerSpec {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Detector.class);
    private Double gain;
    private ElectricPotential voltage;
    private Double offset;
    private Double zoom;
    private Double amplificationGain;
    private String id;
    private DetectorType type;
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private Instrument instrument;

    public Detector() {
    }

    public Detector(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Detector(Detector orig) {
        super(orig);
        this.gain = orig.gain;
        this.voltage = orig.voltage;
        this.offset = orig.offset;
        this.zoom = orig.zoom;
        this.amplificationGain = orig.amplificationGain;
        this.id = orig.id;
        this.type = orig.type;
        this.annotationLinks = orig.annotationLinks;
        this.instrument = orig.instrument;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (element.hasAttribute("Gain")) {
            this.setGain(Double.valueOf(element.getAttribute("Gain")));
        }
        if (element.hasAttribute("Voltage")) {
            String unitSymbol = element.getAttribute("VoltageUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Detector.getVoltageUnitXsdDefault();
            }
            UnitsElectricPotential modelUnit = UnitsElectricPotential.fromString(unitSymbol);
            Double baseValue = Double.valueOf(element.getAttribute("Voltage"));
            if (baseValue != null) {
                this.setVoltage(UnitsElectricPotentialEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        if (element.hasAttribute("Offset")) {
            this.setOffset(Double.valueOf(element.getAttribute("Offset")));
        }
        if (element.hasAttribute("Zoom")) {
            this.setZoom(Double.valueOf(element.getAttribute("Zoom")));
        }
        if (element.hasAttribute("AmplificationGain")) {
            this.setAmplificationGain(Double.valueOf(element.getAttribute("AmplificationGain")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Detector missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Type")) {
            this.setType(DetectorType.fromString(element.getAttribute("Type")));
        }
        List<Element> AnnotationRef_nodeList = Detector.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkDetector(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        return super.link(reference, o);
    }

    public Double getGain() {
        return this.gain;
    }

    public void setGain(Double gain) {
        this.gain = gain;
    }

    public ElectricPotential getVoltage() {
        return this.voltage;
    }

    public void setVoltage(ElectricPotential voltage) {
        this.voltage = voltage;
    }

    public static String getVoltageUnitXsdDefault() {
        return "V";
    }

    public Double getOffset() {
        return this.offset;
    }

    public void setOffset(Double offset) {
        this.offset = offset;
    }

    public Double getZoom() {
        return this.zoom;
    }

    public void setZoom(Double zoom) {
        this.zoom = zoom;
    }

    public Double getAmplificationGain() {
        return this.amplificationGain;
    }

    public void setAmplificationGain(Double amplificationGain) {
        this.amplificationGain = amplificationGain;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public DetectorType getType() {
        return this.type;
    }

    public void setType(DetectorType type) {
        this.type = type;
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkDetector(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkDetector(this);
        return this.annotationLinks.remove(o);
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument_BackReference) {
        this.instrument = instrument_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Detector_element) {
        if (Detector_element == null) {
            Detector_element = document.createElementNS(NAMESPACE, "Detector");
        }
        super.asXMLElement(document, Detector_element);
        if (this.gain != null) {
            Detector_element.setAttribute("Gain", this.gain.toString());
        }
        if (this.voltage != null) {
            if (this.voltage.value() != null) {
                Detector_element.setAttribute("Voltage", this.voltage.value().toString());
            }
            if (this.voltage.unit() != null) {
                try {
                    UnitsElectricPotential enumUnits = UnitsElectricPotential.fromString(this.voltage.unit().getSymbol());
                    Detector_element.setAttribute("VoltageUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Detector:VoltageUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.offset != null) {
            Detector_element.setAttribute("Offset", this.offset.toString());
        }
        if (this.zoom != null) {
            Detector_element.setAttribute("Zoom", this.zoom.toString());
        }
        if (this.amplificationGain != null) {
            Detector_element.setAttribute("AmplificationGain", this.amplificationGain.toString());
        }
        if (this.id != null) {
            Detector_element.setAttribute("ID", this.id.toString());
        }
        if (this.type != null) {
            Detector_element.setAttribute("Type", this.type.toString());
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Element child = document.createElementNS(NAMESPACE, "AnnotationRef");
                o.asXMLElement(document, child);
                Detector_element.appendChild(child);
            }
        }
        if (this.instrument != null) {
            // empty if block
        }
        return Detector_element;
    }
}

