/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.BinaryFile;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.TypeAnnotation;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileAnnotation
extends TypeAnnotation {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAnnotation.class);
    private BinaryFile binaryFile;
    private StructuredAnnotations structuredAnnotations;

    public FileAnnotation() {
    }

    public FileAnnotation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public FileAnnotation(FileAnnotation orig) {
        super(orig);
        this.binaryFile = orig.binaryFile;
        this.structuredAnnotations = orig.structuredAnnotations;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        List<Element> BinaryFile_nodeList = FileAnnotation.getChildrenByTagName(element, "BinaryFile");
        if (BinaryFile_nodeList.size() > 1) {
            throw new RuntimeException(String.format("BinaryFile node list size %d != 1", BinaryFile_nodeList.size()));
        }
        if (BinaryFile_nodeList.size() != 0) {
            this.setBinaryFile(new BinaryFile(BinaryFile_nodeList.get(0), model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    public BinaryFile getBinaryFile() {
        return this.binaryFile;
    }

    public void setBinaryFile(BinaryFile binaryFile) {
        this.binaryFile = binaryFile;
    }

    public StructuredAnnotations getStructuredAnnotations() {
        return this.structuredAnnotations;
    }

    public void setStructuredAnnotations(StructuredAnnotations structuredAnnotations_BackReference) {
        this.structuredAnnotations = structuredAnnotations_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element FileAnnotation_element) {
        if (FileAnnotation_element == null) {
            FileAnnotation_element = document.createElementNS(NAMESPACE, "FileAnnotation");
        }
        super.asXMLElement(document, FileAnnotation_element);
        if (this.binaryFile != null) {
            Element child = document.createElementNS(NAMESPACE, "BinaryFile");
            this.binaryFile.asXMLElement(document, child);
            FileAnnotation_element.appendChild(child);
        }
        if (this.structuredAnnotations != null) {
            // empty if block
        }
        return FileAnnotation_element;
    }
}

